<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class HrUserPath extends Model
{
    use HasFactory;

    protected $fillable = [
        'hr_user_id',
        'path',
        'team_director'
    ];
    
    
    public function user(): HasOne
    {
        return $this->hasOne(HrUser::class, 'id', 'team_director');
    }
  
    

}
