<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class Item extends Model
{
    use HasFactory;

    protected $fillable = [
        'category_id',
        'type',
        'price',
        'status',
        'sort',
        'store_type'
    ];

    public function detail(): HasOne
    {
        return $this->hasOne(ItemDetail::class)->where('language_locale', session('locale'));
    }

    public function details()
    {
        return $this->hasMany(ItemDetail::class);
    }
    
    public function override_commission(): HasOne
    {
        return $this->hasOne(ItemOverrideCommission::class);
    }
    
    public function stores()
    {
        return $this->hasMany(ItemStore::class);
    }

    public function category()
    {
        return $this->hasMany(CategoryDetail::class, 'category_id', 'category_id');
    }

}
