<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class ItemStore extends Model
{
    use HasFactory;

    protected $fillable = [
        'item_id',
        'store_id',
    ];
    
    public function item(): HasOne
    {
        return $this->hasOne(Item::class, 'id','item_id');
    }
    
    public function store(): HasOne
    {
        return $this->hasOne(CooperationStore::class, 'id', 'store_id');
    }
    
}
