<?php

namespace App\Models\Member;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;

class CooperationStore extends Model
{
    use HasFactory;

    protected $fillable = [
        'cooperation_company_id',
        'language_id',
        'language_locale',
        'logo',
        'name',
        'address',
        'telephone',
        'email',
        'business_hours',
        'status',
        'login_email',
        'password',
        'category_array',
        'require_update_password',
        'uniqid'
    ];
    
    public function company(): HasOne
    {
        return $this->hasOne(CooperationCompany::class, 'id', 'cooperation_company_id');
    }
    
    public function categories()
    {
        return $this->hasMany(BranchCategory::class);
    }

}
