<?php

namespace App\Models\Member;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasOne;


class MemberOrder extends Model
{
    use HasFactory;

    protected $fillable = [
        'member_id',
        'store_id',
        'order_date',
        'type',
        'total',
        'uniqid',
        'status',
        'paypal_order_id'
    ];

    // public function customer(): BelongsTo
    // {
    //     return $this->belongsTo(Customer::class);
    // }
    
    public function details()
    {
        return $this->hasMany(MemberOrderDetail::class, 'member_order_id', 'id');
    }
    
    public function store(): HasOne
    {
        return $this->hasOne(CooperationStore::class, 'id', 'store_id');
    }
    
    public function status(): HasOne
    {
        return $this->hasOne(MemberCatalogueRedeemItemStatusDetail::class, 'member_catalogue_redeem_item_status_id', 'status')->where('language_locale', session('locale'));
    }

    // public function statusdetail(): HasOne
    // {
    //     return $this->hasOne(AppointmentStatusDetail::class, 'appointment_status_id', 'status')->where('language_locale', session('locale'));
    // }
    
    // public function hr_user_link(): HasOne
    // {
    //     return $this->hasOne(HrAppointmentLink::class, 'appointment_id', 'id');
    // }

}
