<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Order extends Model
{
    use HasFactory;

    protected $fillable = [
        'total',
        'payment_method_id',
        'payment_method',
        'payment_option',
        'comment',
        'user_id',
        'order_type',
        'order_date',
        'status',
        'uniqid',
    ];

    public function items()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function transactions()
    {
        return $this->hasMany(OrderTransaction::class);
    }

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function order_customers()
    {
        return $this->hasMany(OrderCustomer::class);
    }

    public function order_items()
    {
        return $this->hasMany(OrderItem::class);
    }

}
