<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class OrderCustomer extends Model
{
    use HasFactory;

    protected $fillable = [
        'order_id',
        'customer_id',
        'company',
        'name',
        'email',
        'telephone',
    ];

    public function detail(): HasOne
    {
        return $this->hasOne(Order::class, 'id', 'order_id');
    }

    public function items()
    {
        return $this->hasMany(OrderItem::class, 'order_id', 'order_id');
    }

    public function orders()
    {
        return $this->hasMany(Order::class, 'id', 'order_id');
    }

    public function transactions()
    {
        return $this->hasMany(OrderTransaction::class, 'order_id', 'order_id');
    }


}
