<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OrderItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'order_id',
        'service_id',
        'type',
        'detail',
        'unit_price',
        'quantity',
        'total'
    ];

    public function due_amount()
    {
        return $this->belongsTo(OrderTransaction::class);
    }

}
