<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class PackageItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'package_id',
        'item_id',
        'duration',
        'type',
        'times',
    ];

    public function item(): HasOne
    {
        return $this->hasOne(ItemDetail::class, 'item_id', 'item_id')->where('language_locale', session('locale'));
    }

    public function detail(): HasOne
    {
        return $this->hasOne(PackageItemDetail::class)->where('language_locale', session('locale'));
    }

    public function details()
    {
        return $this->hasMany(PackageItemDetail::class);
    }

}
