<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;

class PaymentMethod extends Model
{
    use HasFactory;

    protected $fillable = [
        'upload_receipt',
        'upload_payment_record',
        'sort',
        'status'
    ];

    public function detail(): HasOne
    {
        return $this->hasOne(PaymentMethodDetail::class)->where('language_locale', session('locale'));
    }

    public function details()
    {
        return $this->hasMany(PaymentMethodDetail::class);
    }

}
