<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Task extends Model
{
    use HasFactory;

    protected $fillable = [
        'project_id',
        'title',
        'description',
        'staff_id',
        'expiry_date',
        'status'
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class, 'staff_id');
    }

    public function task_status(): BelongsTo
    {
            return $this->belongsTo(TaskStatusDetail::class, 'status', 'task_status_id')->where('language_locale', session('locale'));
    }



}
