<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use App\Models\Setting;
use Illuminate\Support\Facades\Config;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        try {
            $settings = Setting::all();
            $settings_array = [];

            foreach($settings as $k => $v) {
                $settings_array[$v->key] = $v->value;
            }
            // $settings_array = convertDbSettingsToConfig($settings);
            // print_r($settings_array);

            Config::set($settings_array);
        }
        catch (\Throwable $th) {

        }

    }
}
