import {
  computed,
  reactive,
  watchEffect
} from "./chunk-U6BEPC57.js";
import "./chunk-HKJ2B2AA.js";

// node_modules/laravel-vue-i18n/dist/utils/get-plural-index.mjs
function getPluralIndex(lang, number) {
  switch (lang.replace("_", "-")) {
    case "af":
    case "af-ZA":
    case "bn":
    case "bn-BD":
    case "bn-IN":
    case "bg":
    case "bg-BG":
    case "ca":
    case "ca-AD":
    case "ca-ES":
    case "ca-FR":
    case "ca-IT":
    case "da":
    case "da-DK":
    case "de":
    case "de-AT":
    case "de-BE":
    case "de-CH":
    case "de-DE":
    case "de-LI":
    case "de-LU":
    case "el":
    case "el-CY":
    case "el-GR":
    case "en":
    case "en-AG":
    case "en-AU":
    case "en-BW":
    case "en-CA":
    case "en-DK":
    case "en-GB":
    case "en-HK":
    case "en-IE":
    case "en-IN":
    case "en-NG":
    case "en-NZ":
    case "en-PH":
    case "en-SG":
    case "en-US":
    case "en-ZA":
    case "en-ZM":
    case "en-ZW":
    case "eo":
    case "eo-US":
    case "es":
    case "es-AR":
    case "es-BO":
    case "es-CL":
    case "es-CO":
    case "es-CR":
    case "es-CU":
    case "es-DO":
    case "es-EC":
    case "es-ES":
    case "es-GT":
    case "es-HN":
    case "es-MX":
    case "es-NI":
    case "es-PA":
    case "es-PE":
    case "es-PR":
    case "es-PY":
    case "es-SV":
    case "es-US":
    case "es-UY":
    case "es-VE":
    case "et":
    case "et-EE":
    case "eu":
    case "eu-ES":
    case "eu-FR":
    case "fa":
    case "fa-IR":
    case "fi":
    case "fi-FI":
    case "fo":
    case "fo-FO":
    case "fur":
    case "fur-IT":
    case "fy":
    case "fy-DE":
    case "fy-NL":
    case "gl":
    case "gl-ES":
    case "gu":
    case "gu-IN":
    case "ha":
    case "ha-NG":
    case "he":
    case "he-IL":
    case "hu":
    case "hu-HU":
    case "is":
    case "is-IS":
    case "it":
    case "it-CH":
    case "it-IT":
    case "ku":
    case "ku-TR":
    case "lb":
    case "lb-LU":
    case "ml":
    case "ml-IN":
    case "mn":
    case "mn-MN":
    case "mr":
    case "mr-IN":
    case "nah":
    case "nb":
    case "nb-NO":
    case "ne":
    case "ne-NP":
    case "nl":
    case "nl-AW":
    case "nl-BE":
    case "nl-NL":
    case "nn":
    case "nn-NO":
    case "no":
    case "om":
    case "om-ET":
    case "om-KE":
    case "or":
    case "or-IN":
    case "pa":
    case "pa-IN":
    case "pa-PK":
    case "pap":
    case "pap-AN":
    case "pap-AW":
    case "pap-CW":
    case "ps":
    case "ps-AF":
    case "pt":
    case "pt-BR":
    case "pt-PT":
    case "so":
    case "so-DJ":
    case "so-ET":
    case "so-KE":
    case "so-SO":
    case "sq":
    case "sq-AL":
    case "sq-MK":
    case "sv":
    case "sv-FI":
    case "sv-SE":
    case "sw":
    case "sw-KE":
    case "sw-TZ":
    case "ta":
    case "ta-IN":
    case "ta-LK":
    case "te":
    case "te-IN":
    case "tk":
    case "tk-TM":
    case "ur":
    case "ur-IN":
    case "ur-PK":
    case "zu":
    case "zu-ZA":
      return number === 1 ? 0 : 1;
    case "am":
    case "am-ET":
    case "bh":
    case "fil":
    case "fil-PH":
    case "fr":
    case "fr-BE":
    case "fr-CA":
    case "fr-CH":
    case "fr-FR":
    case "fr-LU":
    case "gun":
    case "hi":
    case "hi-IN":
    case "hy":
    case "hy-AM":
    case "ln":
    case "ln-CD":
    case "mg":
    case "mg-MG":
    case "nso":
    case "nso-ZA":
    case "ti":
    case "ti-ER":
    case "ti-ET":
    case "wa":
    case "wa-BE":
    case "xbr":
      return number === 0 || number === 1 ? 0 : 1;
    case "be":
    case "be-BY":
    case "bs":
    case "bs-BA":
    case "hr":
    case "hr-HR":
    case "ru":
    case "ru-RU":
    case "ru-UA":
    case "sr":
    case "sr-ME":
    case "sr-RS":
    case "uk":
    case "uk-UA":
      return number % 10 == 1 && number % 100 != 11 ? 0 : number % 10 >= 2 && number % 10 <= 4 && (number % 100 < 10 || number % 100 >= 20) ? 1 : 2;
    case "cs":
    case "cs-CZ":
    case "sk":
    case "sk-SK":
      return number == 1 ? 0 : number >= 2 && number <= 4 ? 1 : 2;
    case "ga":
    case "ga-IE":
      return number == 1 ? 0 : number == 2 ? 1 : 2;
    case "lt":
    case "lt-LT":
      return number % 10 == 1 && number % 100 != 11 ? 0 : number % 10 >= 2 && (number % 100 < 10 || number % 100 >= 20) ? 1 : 2;
    case "sl":
    case "sl-SI":
      return number % 100 == 1 ? 0 : number % 100 == 2 ? 1 : number % 100 == 3 || number % 100 == 4 ? 2 : 3;
    case "mk":
    case "mk-MK":
      return number % 10 == 1 ? 0 : 1;
    case "mt":
    case "mt-MT":
      return number == 1 ? 0 : number == 0 || number % 100 > 1 && number % 100 < 11 ? 1 : number % 100 > 10 && number % 100 < 20 ? 2 : 3;
    case "lv":
    case "lv-LV":
      return number == 0 ? 0 : number % 10 == 1 && number % 100 != 11 ? 1 : 2;
    case "pl":
    case "pl-PL":
      return number == 1 ? 0 : number % 10 >= 2 && number % 10 <= 4 && (number % 100 < 12 || number % 100 > 14) ? 1 : 2;
    case "cy":
    case "cy-GB":
      return number == 1 ? 0 : number == 2 ? 1 : number == 8 || number == 11 ? 2 : 3;
    case "ro":
    case "ro-RO":
      return number == 1 ? 0 : number == 0 || number % 100 > 0 && number % 100 < 20 ? 1 : 2;
    case "ar":
    case "ar-AE":
    case "ar-BH":
    case "ar-DZ":
    case "ar-EG":
    case "ar-IN":
    case "ar-IQ":
    case "ar-JO":
    case "ar-KW":
    case "ar-LB":
    case "ar-LY":
    case "ar-MA":
    case "ar-OM":
    case "ar-QA":
    case "ar-SA":
    case "ar-SD":
    case "ar-SS":
    case "ar-SY":
    case "ar-TN":
    case "ar-YE":
      return number == 0 ? 0 : number == 1 ? 1 : number == 2 ? 2 : number % 100 >= 3 && number % 100 <= 10 ? 3 : number % 100 >= 11 && number % 100 <= 99 ? 4 : 5;
    default:
      return 0;
  }
}

// node_modules/laravel-vue-i18n/dist/pluralization.mjs
function choose(message, number, lang) {
  let segments = message.split("|");
  const extracted = extract(segments, number);
  if (extracted !== null) {
    return extracted.trim();
  }
  segments = stripConditions(segments);
  const pluralIndex = getPluralIndex(lang, number);
  if (segments.length === 1 || !segments[pluralIndex]) {
    return segments[0];
  }
  return segments[pluralIndex];
}
function extract(segments, number) {
  for (const part of segments) {
    let line = extractFromString(part, number);
    if (line !== null) {
      return line;
    }
  }
  return null;
}
function extractFromString(part, number) {
  const matches = part.match(/^[\{\[]([^\[\]\{\}]*)[\}\]](.*)/s) || [];
  if (matches.length !== 3) {
    return null;
  }
  const condition = matches[1];
  const value = matches[2];
  if (condition.includes(",")) {
    let [from, to] = condition.split(",");
    if (to === "*" && number >= parseFloat(from)) {
      return value;
    } else if (from === "*" && number <= parseFloat(to)) {
      return value;
    } else if (number >= parseFloat(from) && number <= parseFloat(to)) {
      return value;
    }
  }
  return parseFloat(condition) === number ? value : null;
}
function stripConditions(segments) {
  return segments.map((part) => part.replace(/^[\{\[]([^\[\]\{\}]*)[\}\]]/, ""));
}

// node_modules/laravel-vue-i18n/dist/utils/avoid-exceptions.mjs
var avoidException = (callback, param, defaults = {}) => {
  try {
    return callback(param);
  } catch {
    return defaults;
  }
};
var avoidExceptionOnPromise = async (promise, defaults = {}) => {
  try {
    return (await promise).default || defaults;
  } catch (e) {
    return defaults;
  }
};

// node_modules/laravel-vue-i18n/dist/utils/has-php-translations.mjs
function hasPhpTranslations(isServer2) {
  return isServer2 || checkProcessEnv() || checkImportMeta();
}
function checkProcessEnv() {
  var _a;
  return typeof process !== "undefined" && ((_a = process.env) == null ? void 0 : _a.LARAVEL_VUE_I18N_HAS_PHP) ? true : false;
}
function checkImportMeta() {
  return typeof import.meta.env !== "undefined" && /** @ts-ignore */
  import.meta.env.VITE_LARAVEL_VUE_I18N_HAS_PHP ? true : false;
}

// node_modules/laravel-vue-i18n/dist/index.mjs
var isServer = typeof window === "undefined";
var sharedInstance = null;
var DEFAULT_OPTIONS = {
  lang: !isServer && document.documentElement.lang ? document.documentElement.lang.replace("-", "_") : null,
  fallbackLang: "en",
  fallbackMissingTranslations: false,
  resolve: (lang) => new Promise((resolve) => resolve({ default: {} })),
  onLoad: (lang) => {
  }
};
var DEFAULT_PLUGIN_OPTIONS = {
  shared: true
};
function isLoaded(lang) {
  return I18n.getSharedInstance().isLoaded(lang);
}
function loadLanguageAsync(lang, dashLangTry = false) {
  return I18n.getSharedInstance().loadLanguageAsync(lang, dashLangTry);
}
function trans(key, replacements = {}) {
  return I18n.getSharedInstance().trans(key, replacements);
}
function wTrans(key, replacements = {}) {
  return I18n.getSharedInstance().wTrans(key, replacements);
}
function transChoice(key, number, replacements = {}) {
  return I18n.getSharedInstance().transChoice(key, number, replacements);
}
function wTransChoice(key, number, replacements = {}) {
  return I18n.getSharedInstance().wTransChoice(key, number, replacements);
}
function getActiveLanguage() {
  return I18n.getSharedInstance().getActiveLanguage();
}
var reset = () => {
  sharedInstance == null ? void 0 : sharedInstance.reset();
};
var trans_choice = transChoice;
var i18nVue = {
  install(app, options = {}) {
    options = { ...DEFAULT_PLUGIN_OPTIONS, ...options };
    const i18n = options.shared ? I18n.getSharedInstance(options, true) : new I18n(options);
    app.config.globalProperties.$t = (key, replacements) => i18n.trans(key, replacements);
    app.config.globalProperties.$tChoice = (key, number, replacements) => i18n.transChoice(key, number, replacements);
    app.provide("i18n", i18n);
  }
};
var I18n = class _I18n {
  /**
   * Creates a new instance of the I18n class, applying default options
   */
  constructor(options = {}) {
    this.activeMessages = reactive({});
    this.fallbackMessages = reactive({});
    this.reset = () => {
      _I18n.loaded = [];
      this.options = DEFAULT_OPTIONS;
      for (const [key] of Object.entries(this.activeMessages)) {
        this.activeMessages[key] = null;
      }
      if (this === sharedInstance) {
        sharedInstance = null;
      }
    };
    this.options = { ...DEFAULT_OPTIONS, ...options };
    if (this.options.fallbackMissingTranslations) {
      this.loadFallbackLanguage();
    } else {
      this.load();
    }
  }
  /**
   * Sets options on the instance, preserving any values not present in new options
   */
  setOptions(options = {}, forceLoad = false) {
    this.options = { ...this.options, ...options };
    if (forceLoad) {
      this.load();
    }
    return this;
  }
  /**
   * Loads the language.
   */
  load() {
    this[isServer ? "loadLanguage" : "loadLanguageAsync"](this.getActiveLanguage());
  }
  /**
   * Load fallback language
   */
  loadFallbackLanguage() {
    if (!isServer) {
      this.resolveLangAsync(this.options.resolve, this.options.fallbackLang).then(({ default: messages2 }) => {
        this.applyFallbackLanguage(this.options.fallbackLang, messages2);
        this.load();
      });
      return;
    }
    const { default: messages } = this.resolveLang(this.options.resolve, this.options.fallbackLang);
    this.applyFallbackLanguage(this.options.fallbackLang, messages);
    this.loadLanguage(this.getActiveLanguage());
  }
  /**
   * Loads the language async.
   */
  loadLanguage(lang, dashLangTry = false) {
    const loadedLang = _I18n.loaded.find((row) => row.lang === lang);
    if (loadedLang) {
      this.setLanguage(loadedLang);
      return;
    }
    const { default: messages } = this.resolveLang(this.options.resolve, lang);
    this.applyLanguage(lang, messages, dashLangTry, this.loadLanguage);
  }
  /**
   * Loads the language file.
   */
  loadLanguageAsync(lang, dashLangTry = false, ignoreAbort = false) {
    var _a;
    if (!ignoreAbort) {
      (_a = this.abortController) == null ? void 0 : _a.abort();
      this.abortController = new AbortController();
    }
    const loadedLang = _I18n.loaded.find((row) => row.lang === lang);
    if (loadedLang) {
      return Promise.resolve(this.setLanguage(loadedLang));
    }
    return new Promise((resolve, reject) => {
      this.abortController.signal.addEventListener("abort", () => {
        resolve();
      });
      this.resolveLangAsync(this.options.resolve, lang).then(({ default: messages }) => {
        resolve(this.applyLanguage(lang, messages, dashLangTry, this.loadLanguageAsync));
      });
    });
  }
  /**
   * Resolves the language file or data, from direct data, synchronously.
   */
  resolveLang(callable, lang, data = {}) {
    if (!Object.keys(data).length) {
      data = avoidException(callable, lang);
    }
    if (hasPhpTranslations(isServer)) {
      return {
        default: {
          ...data,
          ...avoidException(callable, `php_${lang}`)
        }
      };
    }
    return { default: data };
  }
  /**
   * It resolves the language file or data, from direct data, require or Promise.
   */
  async resolveLangAsync(callable, lang) {
    let data = avoidException(callable, lang);
    if (!(data instanceof Promise)) {
      return this.resolveLang(callable, lang, data);
    }
    if (hasPhpTranslations(isServer)) {
      const phpLang = await avoidExceptionOnPromise(callable(`php_${lang}`));
      const jsonLang = await avoidExceptionOnPromise(data);
      return new Promise((resolve) => resolve({
        default: {
          ...phpLang,
          ...jsonLang
        }
      }));
    }
    return new Promise(async (resolve) => resolve({
      default: await avoidExceptionOnPromise(data)
    }));
  }
  /**
   * Applies the language data and saves it to the loaded storage.
   */
  applyLanguage(lang, messages, dashLangTry = false, callable) {
    if (Object.keys(messages).length < 1) {
      if (/[-_]/g.test(lang) && !dashLangTry) {
        return callable.call(this, lang.replace(/[-_]/g, (char) => char === "-" ? "_" : "-"), true, true);
      }
      if (lang !== this.options.fallbackLang) {
        return callable.call(this, this.options.fallbackLang, false, true);
      }
    }
    const data = { lang, messages };
    this.addLoadedLang(data);
    return this.setLanguage(data);
  }
  applyFallbackLanguage(lang, messages) {
    for (const [key, value] of Object.entries(messages)) {
      this.fallbackMessages[key] = value;
    }
    this.addLoadedLang({
      lang: this.options.fallbackLang,
      messages
    });
  }
  /**
   * Adds to the array of loaded languages.
   */
  addLoadedLang(data) {
    const foundIndex = _I18n.loaded.findIndex((item) => item.lang === data.lang);
    if (foundIndex !== -1) {
      _I18n.loaded[foundIndex] = data;
      return;
    }
    _I18n.loaded.push(data);
  }
  /**
   * Sets the language messages to the activeMessages.
   */
  setLanguage({ lang, messages }) {
    if (!isServer) {
      document.documentElement.setAttribute("lang", lang.replace("_", "-"));
    }
    this.options.lang = lang;
    for (const [key, value] of Object.entries(messages)) {
      this.activeMessages[key] = value;
    }
    for (const [key, value] of Object.entries(this.fallbackMessages)) {
      if (!this.isValid(messages[key]) || this.activeMessages[key] === key) {
        this.activeMessages[key] = value;
      }
    }
    for (const [key] of Object.entries(this.activeMessages)) {
      if (!this.isValid(messages[key]) && !this.isValid(this.fallbackMessages[key])) {
        this.activeMessages[key] = null;
      }
    }
    this.options.onLoad(lang);
    return lang;
  }
  /**
   * Returns the current active language.
   */
  getActiveLanguage() {
    return this.options.lang || this.options.fallbackLang;
  }
  /**
   * Checks if the language is loaded.
   */
  isLoaded(lang) {
    lang ?? (lang = this.getActiveLanguage());
    return _I18n.loaded.some((row) => row.lang.replace(/[-_]/g, "-") === lang.replace(/[-_]/g, "-"));
  }
  /**
   * Get the translation for the given key.
   */
  trans(key, replacements = {}) {
    return this.wTrans(key, replacements).value;
  }
  /**
   * Get the translation for the given key and watch for any changes.
   */
  wTrans(key, replacements = {}) {
    watchEffect(() => {
      let value = this.findTranslation(key);
      if (!this.isValid(value)) {
        value = this.findTranslation(key.replace(/\//g, "."));
      }
      this.activeMessages[key] = this.isValid(value) ? value : key;
    });
    return computed(() => this.makeReplacements(this.activeMessages[key], replacements));
  }
  /**
   * Translates the given message based on a count.
   */
  transChoice(key, number, replacements = {}) {
    return this.wTransChoice(key, number, replacements).value;
  }
  /**
   * Translates the given message based on a count and watch for changes.
   */
  wTransChoice(key, number, replacements = {}) {
    const message = this.wTrans(key, replacements);
    replacements.count = number.toString();
    return computed(() => this.makeReplacements(choose(message.value, number, this.options.lang), replacements));
  }
  /**
   * Find translation in memory.
   */
  findTranslation(key) {
    if (this.isValid(this.activeMessages[key])) {
      return this.activeMessages[key];
    }
    const hasChildItems = this.activeMessages[`${key}.0`] !== void 0;
    if (hasChildItems) {
      const childItems = Object.entries(this.activeMessages).filter((item) => item[0].startsWith(`${key}.`)).map((item) => item[1]);
      return reactive(childItems);
    }
    return this.activeMessages[key];
  }
  /**
   * Make the place-holder replacements on a line.
   */
  makeReplacements(message, replacements) {
    const capitalize = (s) => s.charAt(0).toUpperCase() + s.slice(1);
    Object.entries(replacements || []).sort((a, b) => a[0].length >= b[0].length ? -1 : 1).forEach(([key, value]) => {
      value = value.toString();
      message = (message || "").replace(new RegExp(`:${key}`, "g"), value).replace(new RegExp(`:${key.toUpperCase()}`, "g"), value.toUpperCase()).replace(new RegExp(`:${capitalize(key)}`, "g"), capitalize(value));
    });
    return message;
  }
  /**
   * Checks if the message provided is valid.
   */
  isValid(message) {
    return message !== void 0 && message !== null;
  }
  /**
   * Gets the shared I18n instance, instantiating it if not yet created
   */
  static getSharedInstance(options, forceLoad = false) {
    return (sharedInstance == null ? void 0 : sharedInstance.setOptions(options, forceLoad)) || (sharedInstance = new _I18n(options));
  }
};
I18n.loaded = [];
export {
  I18n,
  getActiveLanguage,
  i18nVue,
  isLoaded,
  loadLanguageAsync,
  reset,
  trans,
  transChoice,
  trans_choice,
  wTrans,
  wTransChoice
};
//# sourceMappingURL=laravel-vue-i18n.js.map
