import { Node, Schema } from '@tiptap/pm/model';
/**
 * Returns the HTML string representation of a given document node.
 *
 * @param doc - The document node to serialize.
 * @param schema - The Prosemirror schema to use for serialization.
 * @returns The HTML string representation of the document fragment.
 *
 * @example
 * ```typescript
 * const html = getHTMLFromFragment(doc, schema)
 * ```
 */
export declare function getHTMLFromFragment(doc: Node, schema: Schema, options?: {
    document?: Document;
}): string;
//# sourceMappingURL=getHTMLFromFragment.d.ts.map