(function (global, factory) {
  typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports) :
  typeof define === 'function' && define.amd ? define(['exports'], factory) :
  (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.VueTablerIcons = {}));
})(this, (function (exports) { 'use strict';

  function makeMap(str, expectsLowerCase) {
    const map = /* @__PURE__ */ Object.create(null);
    const list = str.split(",");
    for (let i = 0; i < list.length; i++) {
      map[list[i]] = true;
    }
    return expectsLowerCase ? (val) => !!map[val.toLowerCase()] : (val) => !!map[val];
  }

  const EMPTY_OBJ = Object.freeze({}) ;
  Object.freeze([]) ;
  const NOOP = () => {
  };
  const onRE = /^on[^a-z]/;
  const isOn = (key) => onRE.test(key);
  const extend = Object.assign;
  const remove = (arr, el) => {
    const i = arr.indexOf(el);
    if (i > -1) {
      arr.splice(i, 1);
    }
  };
  const hasOwnProperty$1 = Object.prototype.hasOwnProperty;
  const hasOwn = (val, key) => hasOwnProperty$1.call(val, key);
  const isArray = Array.isArray;
  const isMap = (val) => toTypeString(val) === "[object Map]";
  const isSet = (val) => toTypeString(val) === "[object Set]";
  const isFunction = (val) => typeof val === "function";
  const isString = (val) => typeof val === "string";
  const isSymbol = (val) => typeof val === "symbol";
  const isObject = (val) => val !== null && typeof val === "object";
  const isPromise = (val) => {
    return isObject(val) && isFunction(val.then) && isFunction(val.catch);
  };
  const objectToString = Object.prototype.toString;
  const toTypeString = (value) => objectToString.call(value);
  const toRawType = (value) => {
    return toTypeString(value).slice(8, -1);
  };
  const isPlainObject = (val) => toTypeString(val) === "[object Object]";
  const isIntegerKey = (key) => isString(key) && key !== "NaN" && key[0] !== "-" && "" + parseInt(key, 10) === key;
  const cacheStringFunction = (fn) => {
    const cache = /* @__PURE__ */ Object.create(null);
    return (str) => {
      const hit = cache[str];
      return hit || (cache[str] = fn(str));
    };
  };
  const capitalize = cacheStringFunction(
    (str) => str.charAt(0).toUpperCase() + str.slice(1)
  );
  const hasChanged = (value, oldValue) => !Object.is(value, oldValue);
  const def = (obj, key, value) => {
    Object.defineProperty(obj, key, {
      configurable: true,
      enumerable: false,
      value
    });
  };
  let _globalThis;
  const getGlobalThis = () => {
    return _globalThis || (_globalThis = typeof globalThis !== "undefined" ? globalThis : typeof self !== "undefined" ? self : typeof window !== "undefined" ? window : typeof global !== "undefined" ? global : {});
  };

  function normalizeStyle(value) {
    if (isArray(value)) {
      const res = {};
      for (let i = 0; i < value.length; i++) {
        const item = value[i];
        const normalized = isString(item) ? parseStringStyle(item) : normalizeStyle(item);
        if (normalized) {
          for (const key in normalized) {
            res[key] = normalized[key];
          }
        }
      }
      return res;
    } else if (isString(value)) {
      return value;
    } else if (isObject(value)) {
      return value;
    }
  }
  const listDelimiterRE = /;(?![^(]*\))/g;
  const propertyDelimiterRE = /:([^]+)/;
  const styleCommentRE = /\/\*[^]*?\*\//g;
  function parseStringStyle(cssText) {
    const ret = {};
    cssText.replace(styleCommentRE, "").split(listDelimiterRE).forEach((item) => {
      if (item) {
        const tmp = item.split(propertyDelimiterRE);
        tmp.length > 1 && (ret[tmp[0].trim()] = tmp[1].trim());
      }
    });
    return ret;
  }
  function normalizeClass(value) {
    let res = "";
    if (isString(value)) {
      res = value;
    } else if (isArray(value)) {
      for (let i = 0; i < value.length; i++) {
        const normalized = normalizeClass(value[i]);
        if (normalized) {
          res += normalized + " ";
        }
      }
    } else if (isObject(value)) {
      for (const name in value) {
        if (value[name]) {
          res += name + " ";
        }
      }
    }
    return res.trim();
  }

  function warn$1(msg, ...args) {
    console.warn(`[Vue warn] ${msg}`, ...args);
  }

  let activeEffectScope;
  function recordEffectScope(effect, scope = activeEffectScope) {
    if (scope && scope.active) {
      scope.effects.push(effect);
    }
  }
  function getCurrentScope() {
    return activeEffectScope;
  }

  const createDep = (effects) => {
    const dep = new Set(effects);
    dep.w = 0;
    dep.n = 0;
    return dep;
  };
  const wasTracked = (dep) => (dep.w & trackOpBit) > 0;
  const newTracked = (dep) => (dep.n & trackOpBit) > 0;
  const initDepMarkers = ({ deps }) => {
    if (deps.length) {
      for (let i = 0; i < deps.length; i++) {
        deps[i].w |= trackOpBit;
      }
    }
  };
  const finalizeDepMarkers = (effect) => {
    const { deps } = effect;
    if (deps.length) {
      let ptr = 0;
      for (let i = 0; i < deps.length; i++) {
        const dep = deps[i];
        if (wasTracked(dep) && !newTracked(dep)) {
          dep.delete(effect);
        } else {
          deps[ptr++] = dep;
        }
        dep.w &= ~trackOpBit;
        dep.n &= ~trackOpBit;
      }
      deps.length = ptr;
    }
  };

  const targetMap = /* @__PURE__ */ new WeakMap();
  let effectTrackDepth = 0;
  let trackOpBit = 1;
  const maxMarkerBits = 30;
  let activeEffect;
  const ITERATE_KEY = Symbol("iterate" );
  const MAP_KEY_ITERATE_KEY = Symbol("Map key iterate" );
  class ReactiveEffect {
    constructor(fn, scheduler = null, scope) {
      this.fn = fn;
      this.scheduler = scheduler;
      this.active = true;
      this.deps = [];
      this.parent = void 0;
      recordEffectScope(this, scope);
    }
    run() {
      if (!this.active) {
        return this.fn();
      }
      let parent = activeEffect;
      let lastShouldTrack = shouldTrack;
      while (parent) {
        if (parent === this) {
          return;
        }
        parent = parent.parent;
      }
      try {
        this.parent = activeEffect;
        activeEffect = this;
        shouldTrack = true;
        trackOpBit = 1 << ++effectTrackDepth;
        if (effectTrackDepth <= maxMarkerBits) {
          initDepMarkers(this);
        } else {
          cleanupEffect(this);
        }
        return this.fn();
      } finally {
        if (effectTrackDepth <= maxMarkerBits) {
          finalizeDepMarkers(this);
        }
        trackOpBit = 1 << --effectTrackDepth;
        activeEffect = this.parent;
        shouldTrack = lastShouldTrack;
        this.parent = void 0;
        if (this.deferStop) {
          this.stop();
        }
      }
    }
    stop() {
      if (activeEffect === this) {
        this.deferStop = true;
      } else if (this.active) {
        cleanupEffect(this);
        if (this.onStop) {
          this.onStop();
        }
        this.active = false;
      }
    }
  }
  function cleanupEffect(effect2) {
    const { deps } = effect2;
    if (deps.length) {
      for (let i = 0; i < deps.length; i++) {
        deps[i].delete(effect2);
      }
      deps.length = 0;
    }
  }
  let shouldTrack = true;
  const trackStack = [];
  function pauseTracking() {
    trackStack.push(shouldTrack);
    shouldTrack = false;
  }
  function resetTracking() {
    const last = trackStack.pop();
    shouldTrack = last === void 0 ? true : last;
  }
  function track(target, type, key) {
    if (shouldTrack && activeEffect) {
      let depsMap = targetMap.get(target);
      if (!depsMap) {
        targetMap.set(target, depsMap = /* @__PURE__ */ new Map());
      }
      let dep = depsMap.get(key);
      if (!dep) {
        depsMap.set(key, dep = createDep());
      }
      const eventInfo = { effect: activeEffect, target, type, key } ;
      trackEffects(dep, eventInfo);
    }
  }
  function trackEffects(dep, debuggerEventExtraInfo) {
    let shouldTrack2 = false;
    if (effectTrackDepth <= maxMarkerBits) {
      if (!newTracked(dep)) {
        dep.n |= trackOpBit;
        shouldTrack2 = !wasTracked(dep);
      }
    } else {
      shouldTrack2 = !dep.has(activeEffect);
    }
    if (shouldTrack2) {
      dep.add(activeEffect);
      activeEffect.deps.push(dep);
      if (activeEffect.onTrack) {
        activeEffect.onTrack(
          extend(
            {
              effect: activeEffect
            },
            debuggerEventExtraInfo
          )
        );
      }
    }
  }
  function trigger(target, type, key, newValue, oldValue, oldTarget) {
    const depsMap = targetMap.get(target);
    if (!depsMap) {
      return;
    }
    let deps = [];
    if (type === "clear") {
      deps = [...depsMap.values()];
    } else if (key === "length" && isArray(target)) {
      const newLength = Number(newValue);
      depsMap.forEach((dep, key2) => {
        if (key2 === "length" || key2 >= newLength) {
          deps.push(dep);
        }
      });
    } else {
      if (key !== void 0) {
        deps.push(depsMap.get(key));
      }
      switch (type) {
        case "add":
          if (!isArray(target)) {
            deps.push(depsMap.get(ITERATE_KEY));
            if (isMap(target)) {
              deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
            }
          } else if (isIntegerKey(key)) {
            deps.push(depsMap.get("length"));
          }
          break;
        case "delete":
          if (!isArray(target)) {
            deps.push(depsMap.get(ITERATE_KEY));
            if (isMap(target)) {
              deps.push(depsMap.get(MAP_KEY_ITERATE_KEY));
            }
          }
          break;
        case "set":
          if (isMap(target)) {
            deps.push(depsMap.get(ITERATE_KEY));
          }
          break;
      }
    }
    const eventInfo = { target, type, key, newValue, oldValue, oldTarget } ;
    if (deps.length === 1) {
      if (deps[0]) {
        {
          triggerEffects(deps[0], eventInfo);
        }
      }
    } else {
      const effects = [];
      for (const dep of deps) {
        if (dep) {
          effects.push(...dep);
        }
      }
      {
        triggerEffects(createDep(effects), eventInfo);
      }
    }
  }
  function triggerEffects(dep, debuggerEventExtraInfo) {
    const effects = isArray(dep) ? dep : [...dep];
    for (const effect2 of effects) {
      if (effect2.computed) {
        triggerEffect(effect2, debuggerEventExtraInfo);
      }
    }
    for (const effect2 of effects) {
      if (!effect2.computed) {
        triggerEffect(effect2, debuggerEventExtraInfo);
      }
    }
  }
  function triggerEffect(effect2, debuggerEventExtraInfo) {
    if (effect2 !== activeEffect || effect2.allowRecurse) {
      if (effect2.onTrigger) {
        effect2.onTrigger(extend({ effect: effect2 }, debuggerEventExtraInfo));
      }
      if (effect2.scheduler) {
        effect2.scheduler();
      } else {
        effect2.run();
      }
    }
  }

  const isNonTrackableKeys = /* @__PURE__ */ makeMap(`__proto__,__v_isRef,__isVue`);
  const builtInSymbols = new Set(
    /* @__PURE__ */ Object.getOwnPropertyNames(Symbol).filter((key) => key !== "arguments" && key !== "caller").map((key) => Symbol[key]).filter(isSymbol)
  );
  const get$1 = /* @__PURE__ */ createGetter();
  const readonlyGet = /* @__PURE__ */ createGetter(true);
  const shallowReadonlyGet = /* @__PURE__ */ createGetter(true, true);
  const arrayInstrumentations = /* @__PURE__ */ createArrayInstrumentations();
  function createArrayInstrumentations() {
    const instrumentations = {};
    ["includes", "indexOf", "lastIndexOf"].forEach((key) => {
      instrumentations[key] = function(...args) {
        const arr = toRaw(this);
        for (let i = 0, l = this.length; i < l; i++) {
          track(arr, "get", i + "");
        }
        const res = arr[key](...args);
        if (res === -1 || res === false) {
          return arr[key](...args.map(toRaw));
        } else {
          return res;
        }
      };
    });
    ["push", "pop", "shift", "unshift", "splice"].forEach((key) => {
      instrumentations[key] = function(...args) {
        pauseTracking();
        const res = toRaw(this)[key].apply(this, args);
        resetTracking();
        return res;
      };
    });
    return instrumentations;
  }
  function hasOwnProperty(key) {
    const obj = toRaw(this);
    track(obj, "has", key);
    return obj.hasOwnProperty(key);
  }
  function createGetter(isReadonly2 = false, shallow = false) {
    return function get2(target, key, receiver) {
      if (key === "__v_isReactive") {
        return !isReadonly2;
      } else if (key === "__v_isReadonly") {
        return isReadonly2;
      } else if (key === "__v_isShallow") {
        return shallow;
      } else if (key === "__v_raw" && receiver === (isReadonly2 ? shallow ? shallowReadonlyMap : readonlyMap : shallow ? shallowReactiveMap : reactiveMap).get(target)) {
        return target;
      }
      const targetIsArray = isArray(target);
      if (!isReadonly2) {
        if (targetIsArray && hasOwn(arrayInstrumentations, key)) {
          return Reflect.get(arrayInstrumentations, key, receiver);
        }
        if (key === "hasOwnProperty") {
          return hasOwnProperty;
        }
      }
      const res = Reflect.get(target, key, receiver);
      if (isSymbol(key) ? builtInSymbols.has(key) : isNonTrackableKeys(key)) {
        return res;
      }
      if (!isReadonly2) {
        track(target, "get", key);
      }
      if (shallow) {
        return res;
      }
      if (isRef(res)) {
        return targetIsArray && isIntegerKey(key) ? res : res.value;
      }
      if (isObject(res)) {
        return isReadonly2 ? readonly(res) : reactive(res);
      }
      return res;
    };
  }
  const set$1 = /* @__PURE__ */ createSetter();
  function createSetter(shallow = false) {
    return function set2(target, key, value, receiver) {
      let oldValue = target[key];
      if (isReadonly(oldValue) && isRef(oldValue) && !isRef(value)) {
        return false;
      }
      if (!shallow) {
        if (!isShallow$1(value) && !isReadonly(value)) {
          oldValue = toRaw(oldValue);
          value = toRaw(value);
        }
        if (!isArray(target) && isRef(oldValue) && !isRef(value)) {
          oldValue.value = value;
          return true;
        }
      }
      const hadKey = isArray(target) && isIntegerKey(key) ? Number(key) < target.length : hasOwn(target, key);
      const result = Reflect.set(target, key, value, receiver);
      if (target === toRaw(receiver)) {
        if (!hadKey) {
          trigger(target, "add", key, value);
        } else if (hasChanged(value, oldValue)) {
          trigger(target, "set", key, value, oldValue);
        }
      }
      return result;
    };
  }
  function deleteProperty(target, key) {
    const hadKey = hasOwn(target, key);
    const oldValue = target[key];
    const result = Reflect.deleteProperty(target, key);
    if (result && hadKey) {
      trigger(target, "delete", key, void 0, oldValue);
    }
    return result;
  }
  function has$1(target, key) {
    const result = Reflect.has(target, key);
    if (!isSymbol(key) || !builtInSymbols.has(key)) {
      track(target, "has", key);
    }
    return result;
  }
  function ownKeys(target) {
    track(target, "iterate", isArray(target) ? "length" : ITERATE_KEY);
    return Reflect.ownKeys(target);
  }
  const mutableHandlers = {
    get: get$1,
    set: set$1,
    deleteProperty,
    has: has$1,
    ownKeys
  };
  const readonlyHandlers = {
    get: readonlyGet,
    set(target, key) {
      {
        warn$1(
          `Set operation on key "${String(key)}" failed: target is readonly.`,
          target
        );
      }
      return true;
    },
    deleteProperty(target, key) {
      {
        warn$1(
          `Delete operation on key "${String(key)}" failed: target is readonly.`,
          target
        );
      }
      return true;
    }
  };
  const shallowReadonlyHandlers = /* @__PURE__ */ extend(
    {},
    readonlyHandlers,
    {
      get: shallowReadonlyGet
    }
  );

  const toShallow = (value) => value;
  const getProto = (v) => Reflect.getPrototypeOf(v);
  function get(target, key, isReadonly = false, isShallow = false) {
    target = target["__v_raw"];
    const rawTarget = toRaw(target);
    const rawKey = toRaw(key);
    if (!isReadonly) {
      if (key !== rawKey) {
        track(rawTarget, "get", key);
      }
      track(rawTarget, "get", rawKey);
    }
    const { has: has2 } = getProto(rawTarget);
    const wrap = isShallow ? toShallow : isReadonly ? toReadonly : toReactive;
    if (has2.call(rawTarget, key)) {
      return wrap(target.get(key));
    } else if (has2.call(rawTarget, rawKey)) {
      return wrap(target.get(rawKey));
    } else if (target !== rawTarget) {
      target.get(key);
    }
  }
  function has(key, isReadonly = false) {
    const target = this["__v_raw"];
    const rawTarget = toRaw(target);
    const rawKey = toRaw(key);
    if (!isReadonly) {
      if (key !== rawKey) {
        track(rawTarget, "has", key);
      }
      track(rawTarget, "has", rawKey);
    }
    return key === rawKey ? target.has(key) : target.has(key) || target.has(rawKey);
  }
  function size(target, isReadonly = false) {
    target = target["__v_raw"];
    !isReadonly && track(toRaw(target), "iterate", ITERATE_KEY);
    return Reflect.get(target, "size", target);
  }
  function add(value) {
    value = toRaw(value);
    const target = toRaw(this);
    const proto = getProto(target);
    const hadKey = proto.has.call(target, value);
    if (!hadKey) {
      target.add(value);
      trigger(target, "add", value, value);
    }
    return this;
  }
  function set(key, value) {
    value = toRaw(value);
    const target = toRaw(this);
    const { has: has2, get: get2 } = getProto(target);
    let hadKey = has2.call(target, key);
    if (!hadKey) {
      key = toRaw(key);
      hadKey = has2.call(target, key);
    } else {
      checkIdentityKeys(target, has2, key);
    }
    const oldValue = get2.call(target, key);
    target.set(key, value);
    if (!hadKey) {
      trigger(target, "add", key, value);
    } else if (hasChanged(value, oldValue)) {
      trigger(target, "set", key, value, oldValue);
    }
    return this;
  }
  function deleteEntry(key) {
    const target = toRaw(this);
    const { has: has2, get: get2 } = getProto(target);
    let hadKey = has2.call(target, key);
    if (!hadKey) {
      key = toRaw(key);
      hadKey = has2.call(target, key);
    } else {
      checkIdentityKeys(target, has2, key);
    }
    const oldValue = get2 ? get2.call(target, key) : void 0;
    const result = target.delete(key);
    if (hadKey) {
      trigger(target, "delete", key, void 0, oldValue);
    }
    return result;
  }
  function clear() {
    const target = toRaw(this);
    const hadItems = target.size !== 0;
    const oldTarget = isMap(target) ? new Map(target) : new Set(target) ;
    const result = target.clear();
    if (hadItems) {
      trigger(target, "clear", void 0, void 0, oldTarget);
    }
    return result;
  }
  function createForEach(isReadonly, isShallow) {
    return function forEach(callback, thisArg) {
      const observed = this;
      const target = observed["__v_raw"];
      const rawTarget = toRaw(target);
      const wrap = isShallow ? toShallow : isReadonly ? toReadonly : toReactive;
      !isReadonly && track(rawTarget, "iterate", ITERATE_KEY);
      return target.forEach((value, key) => {
        return callback.call(thisArg, wrap(value), wrap(key), observed);
      });
    };
  }
  function createIterableMethod(method, isReadonly, isShallow) {
    return function(...args) {
      const target = this["__v_raw"];
      const rawTarget = toRaw(target);
      const targetIsMap = isMap(rawTarget);
      const isPair = method === "entries" || method === Symbol.iterator && targetIsMap;
      const isKeyOnly = method === "keys" && targetIsMap;
      const innerIterator = target[method](...args);
      const wrap = isShallow ? toShallow : isReadonly ? toReadonly : toReactive;
      !isReadonly && track(
        rawTarget,
        "iterate",
        isKeyOnly ? MAP_KEY_ITERATE_KEY : ITERATE_KEY
      );
      return {
        // iterator protocol
        next() {
          const { value, done } = innerIterator.next();
          return done ? { value, done } : {
            value: isPair ? [wrap(value[0]), wrap(value[1])] : wrap(value),
            done
          };
        },
        // iterable protocol
        [Symbol.iterator]() {
          return this;
        }
      };
    };
  }
  function createReadonlyMethod(type) {
    return function(...args) {
      {
        const key = args[0] ? `on key "${args[0]}" ` : ``;
        console.warn(
          `${capitalize(type)} operation ${key}failed: target is readonly.`,
          toRaw(this)
        );
      }
      return type === "delete" ? false : this;
    };
  }
  function createInstrumentations() {
    const mutableInstrumentations2 = {
      get(key) {
        return get(this, key);
      },
      get size() {
        return size(this);
      },
      has,
      add,
      set,
      delete: deleteEntry,
      clear,
      forEach: createForEach(false, false)
    };
    const shallowInstrumentations2 = {
      get(key) {
        return get(this, key, false, true);
      },
      get size() {
        return size(this);
      },
      has,
      add,
      set,
      delete: deleteEntry,
      clear,
      forEach: createForEach(false, true)
    };
    const readonlyInstrumentations2 = {
      get(key) {
        return get(this, key, true);
      },
      get size() {
        return size(this, true);
      },
      has(key) {
        return has.call(this, key, true);
      },
      add: createReadonlyMethod("add"),
      set: createReadonlyMethod("set"),
      delete: createReadonlyMethod("delete"),
      clear: createReadonlyMethod("clear"),
      forEach: createForEach(true, false)
    };
    const shallowReadonlyInstrumentations2 = {
      get(key) {
        return get(this, key, true, true);
      },
      get size() {
        return size(this, true);
      },
      has(key) {
        return has.call(this, key, true);
      },
      add: createReadonlyMethod("add"),
      set: createReadonlyMethod("set"),
      delete: createReadonlyMethod("delete"),
      clear: createReadonlyMethod("clear"),
      forEach: createForEach(true, true)
    };
    const iteratorMethods = ["keys", "values", "entries", Symbol.iterator];
    iteratorMethods.forEach((method) => {
      mutableInstrumentations2[method] = createIterableMethod(
        method,
        false,
        false
      );
      readonlyInstrumentations2[method] = createIterableMethod(
        method,
        true,
        false
      );
      shallowInstrumentations2[method] = createIterableMethod(
        method,
        false,
        true
      );
      shallowReadonlyInstrumentations2[method] = createIterableMethod(
        method,
        true,
        true
      );
    });
    return [
      mutableInstrumentations2,
      readonlyInstrumentations2,
      shallowInstrumentations2,
      shallowReadonlyInstrumentations2
    ];
  }
  const [
    mutableInstrumentations,
    readonlyInstrumentations,
    shallowInstrumentations,
    shallowReadonlyInstrumentations
  ] = /* @__PURE__ */ createInstrumentations();
  function createInstrumentationGetter(isReadonly, shallow) {
    const instrumentations = shallow ? isReadonly ? shallowReadonlyInstrumentations : shallowInstrumentations : isReadonly ? readonlyInstrumentations : mutableInstrumentations;
    return (target, key, receiver) => {
      if (key === "__v_isReactive") {
        return !isReadonly;
      } else if (key === "__v_isReadonly") {
        return isReadonly;
      } else if (key === "__v_raw") {
        return target;
      }
      return Reflect.get(
        hasOwn(instrumentations, key) && key in target ? instrumentations : target,
        key,
        receiver
      );
    };
  }
  const mutableCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(false, false)
  };
  const readonlyCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(true, false)
  };
  const shallowReadonlyCollectionHandlers = {
    get: /* @__PURE__ */ createInstrumentationGetter(true, true)
  };
  function checkIdentityKeys(target, has2, key) {
    const rawKey = toRaw(key);
    if (rawKey !== key && has2.call(target, rawKey)) {
      const type = toRawType(target);
      console.warn(
        `Reactive ${type} contains both the raw and reactive versions of the same object${type === `Map` ? ` as keys` : ``}, which can lead to inconsistencies. Avoid differentiating between the raw and reactive versions of an object and only use the reactive version if possible.`
      );
    }
  }

  const reactiveMap = /* @__PURE__ */ new WeakMap();
  const shallowReactiveMap = /* @__PURE__ */ new WeakMap();
  const readonlyMap = /* @__PURE__ */ new WeakMap();
  const shallowReadonlyMap = /* @__PURE__ */ new WeakMap();
  function targetTypeMap(rawType) {
    switch (rawType) {
      case "Object":
      case "Array":
        return 1 /* COMMON */;
      case "Map":
      case "Set":
      case "WeakMap":
      case "WeakSet":
        return 2 /* COLLECTION */;
      default:
        return 0 /* INVALID */;
    }
  }
  function getTargetType(value) {
    return value["__v_skip"] || !Object.isExtensible(value) ? 0 /* INVALID */ : targetTypeMap(toRawType(value));
  }
  function reactive(target) {
    if (isReadonly(target)) {
      return target;
    }
    return createReactiveObject(
      target,
      false,
      mutableHandlers,
      mutableCollectionHandlers,
      reactiveMap
    );
  }
  function readonly(target) {
    return createReactiveObject(
      target,
      true,
      readonlyHandlers,
      readonlyCollectionHandlers,
      readonlyMap
    );
  }
  function shallowReadonly(target) {
    return createReactiveObject(
      target,
      true,
      shallowReadonlyHandlers,
      shallowReadonlyCollectionHandlers,
      shallowReadonlyMap
    );
  }
  function createReactiveObject(target, isReadonly2, baseHandlers, collectionHandlers, proxyMap) {
    if (!isObject(target)) {
      {
        console.warn(`value cannot be made reactive: ${String(target)}`);
      }
      return target;
    }
    if (target["__v_raw"] && !(isReadonly2 && target["__v_isReactive"])) {
      return target;
    }
    const existingProxy = proxyMap.get(target);
    if (existingProxy) {
      return existingProxy;
    }
    const targetType = getTargetType(target);
    if (targetType === 0 /* INVALID */) {
      return target;
    }
    const proxy = new Proxy(
      target,
      targetType === 2 /* COLLECTION */ ? collectionHandlers : baseHandlers
    );
    proxyMap.set(target, proxy);
    return proxy;
  }
  function isReactive(value) {
    if (isReadonly(value)) {
      return isReactive(value["__v_raw"]);
    }
    return !!(value && value["__v_isReactive"]);
  }
  function isReadonly(value) {
    return !!(value && value["__v_isReadonly"]);
  }
  function isShallow$1(value) {
    return !!(value && value["__v_isShallow"]);
  }
  function isProxy(value) {
    return isReactive(value) || isReadonly(value);
  }
  function toRaw(observed) {
    const raw = observed && observed["__v_raw"];
    return raw ? toRaw(raw) : observed;
  }
  function markRaw(value) {
    def(value, "__v_skip", true);
    return value;
  }
  const toReactive = (value) => isObject(value) ? reactive(value) : value;
  const toReadonly = (value) => isObject(value) ? readonly(value) : value;
  function isRef(r) {
    return !!(r && r.__v_isRef === true);
  }
  function unref(ref2) {
    return isRef(ref2) ? ref2.value : ref2;
  }
  const shallowUnwrapHandlers = {
    get: (target, key, receiver) => unref(Reflect.get(target, key, receiver)),
    set: (target, key, value, receiver) => {
      const oldValue = target[key];
      if (isRef(oldValue) && !isRef(value)) {
        oldValue.value = value;
        return true;
      } else {
        return Reflect.set(target, key, value, receiver);
      }
    }
  };
  function proxyRefs(objectWithRefs) {
    return isReactive(objectWithRefs) ? objectWithRefs : new Proxy(objectWithRefs, shallowUnwrapHandlers);
  }

  const stack = [];
  function pushWarningContext(vnode) {
    stack.push(vnode);
  }
  function popWarningContext() {
    stack.pop();
  }
  function warn(msg, ...args) {
    pauseTracking();
    const instance = stack.length ? stack[stack.length - 1].component : null;
    const appWarnHandler = instance && instance.appContext.config.warnHandler;
    const trace = getComponentTrace();
    if (appWarnHandler) {
      callWithErrorHandling(
        appWarnHandler,
        instance,
        11,
        [
          msg + args.join(""),
          instance && instance.proxy,
          trace.map(
            ({ vnode }) => `at <${formatComponentName(instance, vnode.type)}>`
          ).join("\n"),
          trace
        ]
      );
    } else {
      const warnArgs = [`[Vue warn]: ${msg}`, ...args];
      if (trace.length && // avoid spamming console during tests
      true) {
        warnArgs.push(`
`, ...formatTrace(trace));
      }
      console.warn(...warnArgs);
    }
    resetTracking();
  }
  function getComponentTrace() {
    let currentVNode = stack[stack.length - 1];
    if (!currentVNode) {
      return [];
    }
    const normalizedStack = [];
    while (currentVNode) {
      const last = normalizedStack[0];
      if (last && last.vnode === currentVNode) {
        last.recurseCount++;
      } else {
        normalizedStack.push({
          vnode: currentVNode,
          recurseCount: 0
        });
      }
      const parentInstance = currentVNode.component && currentVNode.component.parent;
      currentVNode = parentInstance && parentInstance.vnode;
    }
    return normalizedStack;
  }
  function formatTrace(trace) {
    const logs = [];
    trace.forEach((entry, i) => {
      logs.push(...i === 0 ? [] : [`
`], ...formatTraceEntry(entry));
    });
    return logs;
  }
  function formatTraceEntry({ vnode, recurseCount }) {
    const postfix = recurseCount > 0 ? `... (${recurseCount} recursive calls)` : ``;
    const isRoot = vnode.component ? vnode.component.parent == null : false;
    const open = ` at <${formatComponentName(
    vnode.component,
    vnode.type,
    isRoot
  )}`;
    const close = `>` + postfix;
    return vnode.props ? [open, ...formatProps(vnode.props), close] : [open + close];
  }
  function formatProps(props) {
    const res = [];
    const keys = Object.keys(props);
    keys.slice(0, 3).forEach((key) => {
      res.push(...formatProp(key, props[key]));
    });
    if (keys.length > 3) {
      res.push(` ...`);
    }
    return res;
  }
  function formatProp(key, value, raw) {
    if (isString(value)) {
      value = JSON.stringify(value);
      return raw ? value : [`${key}=${value}`];
    } else if (typeof value === "number" || typeof value === "boolean" || value == null) {
      return raw ? value : [`${key}=${value}`];
    } else if (isRef(value)) {
      value = formatProp(key, toRaw(value.value), true);
      return raw ? value : [`${key}=Ref<`, value, `>`];
    } else if (isFunction(value)) {
      return [`${key}=fn${value.name ? `<${value.name}>` : ``}`];
    } else {
      value = toRaw(value);
      return raw ? value : [`${key}=`, value];
    }
  }

  const ErrorTypeStrings = {
    ["sp"]: "serverPrefetch hook",
    ["bc"]: "beforeCreate hook",
    ["c"]: "created hook",
    ["bm"]: "beforeMount hook",
    ["m"]: "mounted hook",
    ["bu"]: "beforeUpdate hook",
    ["u"]: "updated",
    ["bum"]: "beforeUnmount hook",
    ["um"]: "unmounted hook",
    ["a"]: "activated hook",
    ["da"]: "deactivated hook",
    ["ec"]: "errorCaptured hook",
    ["rtc"]: "renderTracked hook",
    ["rtg"]: "renderTriggered hook",
    [0]: "setup function",
    [1]: "render function",
    [2]: "watcher getter",
    [3]: "watcher callback",
    [4]: "watcher cleanup function",
    [5]: "native event handler",
    [6]: "component event handler",
    [7]: "vnode hook",
    [8]: "directive hook",
    [9]: "transition hook",
    [10]: "app errorHandler",
    [11]: "app warnHandler",
    [12]: "ref function",
    [13]: "async component loader",
    [14]: "scheduler flush. This is likely a Vue internals bug. Please open an issue at https://new-issue.vuejs.org/?repo=vuejs/core"
  };
  function callWithErrorHandling(fn, instance, type, args) {
    let res;
    try {
      res = args ? fn(...args) : fn();
    } catch (err) {
      handleError(err, instance, type);
    }
    return res;
  }
  function callWithAsyncErrorHandling(fn, instance, type, args) {
    if (isFunction(fn)) {
      const res = callWithErrorHandling(fn, instance, type, args);
      if (res && isPromise(res)) {
        res.catch((err) => {
          handleError(err, instance, type);
        });
      }
      return res;
    }
    const values = [];
    for (let i = 0; i < fn.length; i++) {
      values.push(callWithAsyncErrorHandling(fn[i], instance, type, args));
    }
    return values;
  }
  function handleError(err, instance, type, throwInDev = true) {
    const contextVNode = instance ? instance.vnode : null;
    if (instance) {
      let cur = instance.parent;
      const exposedInstance = instance.proxy;
      const errorInfo = ErrorTypeStrings[type] ;
      while (cur) {
        const errorCapturedHooks = cur.ec;
        if (errorCapturedHooks) {
          for (let i = 0; i < errorCapturedHooks.length; i++) {
            if (errorCapturedHooks[i](err, exposedInstance, errorInfo) === false) {
              return;
            }
          }
        }
        cur = cur.parent;
      }
      const appErrorHandler = instance.appContext.config.errorHandler;
      if (appErrorHandler) {
        callWithErrorHandling(
          appErrorHandler,
          null,
          10,
          [err, exposedInstance, errorInfo]
        );
        return;
      }
    }
    logError(err, type, contextVNode, throwInDev);
  }
  function logError(err, type, contextVNode, throwInDev = true) {
    {
      const info = ErrorTypeStrings[type];
      if (contextVNode) {
        pushWarningContext(contextVNode);
      }
      warn(`Unhandled error${info ? ` during execution of ${info}` : ``}`);
      if (contextVNode) {
        popWarningContext();
      }
      if (throwInDev) {
        throw err;
      } else {
        console.error(err);
      }
    }
  }

  let isFlushing = false;
  let isFlushPending = false;
  const queue = [];
  let flushIndex = 0;
  const pendingPostFlushCbs = [];
  let activePostFlushCbs = null;
  let postFlushIndex = 0;
  const resolvedPromise = /* @__PURE__ */ Promise.resolve();
  let currentFlushPromise = null;
  const RECURSION_LIMIT = 100;
  function nextTick(fn) {
    const p = currentFlushPromise || resolvedPromise;
    return fn ? p.then(this ? fn.bind(this) : fn) : p;
  }
  function findInsertionIndex(id) {
    let start = flushIndex + 1;
    let end = queue.length;
    while (start < end) {
      const middle = start + end >>> 1;
      const middleJobId = getId(queue[middle]);
      middleJobId < id ? start = middle + 1 : end = middle;
    }
    return start;
  }
  function queueJob(job) {
    if (!queue.length || !queue.includes(
      job,
      isFlushing && job.allowRecurse ? flushIndex + 1 : flushIndex
    )) {
      if (job.id == null) {
        queue.push(job);
      } else {
        queue.splice(findInsertionIndex(job.id), 0, job);
      }
      queueFlush();
    }
  }
  function queueFlush() {
    if (!isFlushing && !isFlushPending) {
      isFlushPending = true;
      currentFlushPromise = resolvedPromise.then(flushJobs);
    }
  }
  function queuePostFlushCb(cb) {
    if (!isArray(cb)) {
      if (!activePostFlushCbs || !activePostFlushCbs.includes(
        cb,
        cb.allowRecurse ? postFlushIndex + 1 : postFlushIndex
      )) {
        pendingPostFlushCbs.push(cb);
      }
    } else {
      pendingPostFlushCbs.push(...cb);
    }
    queueFlush();
  }
  function flushPostFlushCbs(seen) {
    if (pendingPostFlushCbs.length) {
      const deduped = [...new Set(pendingPostFlushCbs)];
      pendingPostFlushCbs.length = 0;
      if (activePostFlushCbs) {
        activePostFlushCbs.push(...deduped);
        return;
      }
      activePostFlushCbs = deduped;
      {
        seen = seen || /* @__PURE__ */ new Map();
      }
      activePostFlushCbs.sort((a, b) => getId(a) - getId(b));
      for (postFlushIndex = 0; postFlushIndex < activePostFlushCbs.length; postFlushIndex++) {
        if (checkRecursiveUpdates(seen, activePostFlushCbs[postFlushIndex])) {
          continue;
        }
        activePostFlushCbs[postFlushIndex]();
      }
      activePostFlushCbs = null;
      postFlushIndex = 0;
    }
  }
  const getId = (job) => job.id == null ? Infinity : job.id;
  const comparator = (a, b) => {
    const diff = getId(a) - getId(b);
    if (diff === 0) {
      if (a.pre && !b.pre)
        return -1;
      if (b.pre && !a.pre)
        return 1;
    }
    return diff;
  };
  function flushJobs(seen) {
    isFlushPending = false;
    isFlushing = true;
    {
      seen = seen || /* @__PURE__ */ new Map();
    }
    queue.sort(comparator);
    const check = (job) => checkRecursiveUpdates(seen, job) ;
    try {
      for (flushIndex = 0; flushIndex < queue.length; flushIndex++) {
        const job = queue[flushIndex];
        if (job && job.active !== false) {
          if (!!("development" !== "production") && check(job)) {
            continue;
          }
          callWithErrorHandling(job, null, 14);
        }
      }
    } finally {
      flushIndex = 0;
      queue.length = 0;
      flushPostFlushCbs(seen);
      isFlushing = false;
      currentFlushPromise = null;
      if (queue.length || pendingPostFlushCbs.length) {
        flushJobs(seen);
      }
    }
  }
  function checkRecursiveUpdates(seen, fn) {
    if (!seen.has(fn)) {
      seen.set(fn, 1);
    } else {
      const count = seen.get(fn);
      if (count > RECURSION_LIMIT) {
        const instance = fn.ownerInstance;
        const componentName = instance && getComponentName(instance.type);
        warn(
          `Maximum recursive updates exceeded${componentName ? ` in component <${componentName}>` : ``}. This means you have a reactive effect that is mutating its own dependencies and thus recursively triggering itself. Possible sources include component template, render function, updated hook or watcher source function.`
        );
        return true;
      } else {
        seen.set(fn, count + 1);
      }
    }
  }
  const hmrDirtyComponents = /* @__PURE__ */ new Set();
  {
    getGlobalThis().__VUE_HMR_RUNTIME__ = {
      createRecord: tryWrap(createRecord),
      rerender: tryWrap(rerender),
      reload: tryWrap(reload)
    };
  }
  const map = /* @__PURE__ */ new Map();
  function createRecord(id, initialDef) {
    if (map.has(id)) {
      return false;
    }
    map.set(id, {
      initialDef: normalizeClassComponent(initialDef),
      instances: /* @__PURE__ */ new Set()
    });
    return true;
  }
  function normalizeClassComponent(component) {
    return isClassComponent(component) ? component.__vccOpts : component;
  }
  function rerender(id, newRender) {
    const record = map.get(id);
    if (!record) {
      return;
    }
    record.initialDef.render = newRender;
    [...record.instances].forEach((instance) => {
      if (newRender) {
        instance.render = newRender;
        normalizeClassComponent(instance.type).render = newRender;
      }
      instance.renderCache = [];
      instance.update();
    });
  }
  function reload(id, newComp) {
    const record = map.get(id);
    if (!record)
      return;
    newComp = normalizeClassComponent(newComp);
    updateComponentDef(record.initialDef, newComp);
    const instances = [...record.instances];
    for (const instance of instances) {
      const oldComp = normalizeClassComponent(instance.type);
      if (!hmrDirtyComponents.has(oldComp)) {
        if (oldComp !== record.initialDef) {
          updateComponentDef(oldComp, newComp);
        }
        hmrDirtyComponents.add(oldComp);
      }
      instance.appContext.propsCache.delete(instance.type);
      instance.appContext.emitsCache.delete(instance.type);
      instance.appContext.optionsCache.delete(instance.type);
      if (instance.ceReload) {
        hmrDirtyComponents.add(oldComp);
        instance.ceReload(newComp.styles);
        hmrDirtyComponents.delete(oldComp);
      } else if (instance.parent) {
        queueJob(instance.parent.update);
      } else if (instance.appContext.reload) {
        instance.appContext.reload();
      } else if (typeof window !== "undefined") {
        window.location.reload();
      } else {
        console.warn(
          "[HMR] Root or manually mounted instance modified. Full reload required."
        );
      }
    }
    queuePostFlushCb(() => {
      for (const instance of instances) {
        hmrDirtyComponents.delete(
          normalizeClassComponent(instance.type)
        );
      }
    });
  }
  function updateComponentDef(oldComp, newComp) {
    extend(oldComp, newComp);
    for (const key in oldComp) {
      if (key !== "__file" && !(key in newComp)) {
        delete oldComp[key];
      }
    }
  }
  function tryWrap(fn) {
    return (id, arg) => {
      try {
        return fn(id, arg);
      } catch (e) {
        console.error(e);
        console.warn(
          `[HMR] Something went wrong during Vue component hot-reload. Full reload required.`
        );
      }
    };
  }

  let currentRenderingInstance = null;
  let currentScopeId = null;

  const isSuspense = (type) => type.__isSuspense;
  function queueEffectWithSuspense(fn, suspense) {
    if (suspense && suspense.pendingBranch) {
      if (isArray(fn)) {
        suspense.effects.push(...fn);
      } else {
        suspense.effects.push(fn);
      }
    } else {
      queuePostFlushCb(fn);
    }
  }
  const INITIAL_WATCHER_VALUE = {};
  function doWatch(source, cb, { immediate, deep, flush, onTrack, onTrigger } = EMPTY_OBJ) {
    var _a;
    if (!cb) {
      if (immediate !== void 0) {
        warn(
          `watch() "immediate" option is only respected when using the watch(source, callback, options?) signature.`
        );
      }
      if (deep !== void 0) {
        warn(
          `watch() "deep" option is only respected when using the watch(source, callback, options?) signature.`
        );
      }
    }
    const warnInvalidSource = (s) => {
      warn(
        `Invalid watch source: `,
        s,
        `A watch source can only be a getter/effect function, a ref, a reactive object, or an array of these types.`
      );
    };
    const instance = getCurrentScope() === ((_a = currentInstance) == null ? void 0 : _a.scope) ? currentInstance : null;
    let getter;
    let forceTrigger = false;
    let isMultiSource = false;
    if (isRef(source)) {
      getter = () => source.value;
      forceTrigger = isShallow$1(source);
    } else if (isReactive(source)) {
      getter = () => source;
      deep = true;
    } else if (isArray(source)) {
      isMultiSource = true;
      forceTrigger = source.some((s) => isReactive(s) || isShallow$1(s));
      getter = () => source.map((s) => {
        if (isRef(s)) {
          return s.value;
        } else if (isReactive(s)) {
          return traverse(s);
        } else if (isFunction(s)) {
          return callWithErrorHandling(s, instance, 2);
        } else {
          warnInvalidSource(s);
        }
      });
    } else if (isFunction(source)) {
      if (cb) {
        getter = () => callWithErrorHandling(source, instance, 2);
      } else {
        getter = () => {
          if (instance && instance.isUnmounted) {
            return;
          }
          if (cleanup) {
            cleanup();
          }
          return callWithAsyncErrorHandling(
            source,
            instance,
            3,
            [onCleanup]
          );
        };
      }
    } else {
      getter = NOOP;
      warnInvalidSource(source);
    }
    if (cb && deep) {
      const baseGetter = getter;
      getter = () => traverse(baseGetter());
    }
    let cleanup;
    let onCleanup = (fn) => {
      cleanup = effect.onStop = () => {
        callWithErrorHandling(fn, instance, 4);
      };
    };
    let oldValue = isMultiSource ? new Array(source.length).fill(INITIAL_WATCHER_VALUE) : INITIAL_WATCHER_VALUE;
    const job = () => {
      if (!effect.active) {
        return;
      }
      if (cb) {
        const newValue = effect.run();
        if (deep || forceTrigger || (isMultiSource ? newValue.some(
          (v, i) => hasChanged(v, oldValue[i])
        ) : hasChanged(newValue, oldValue)) || false) {
          if (cleanup) {
            cleanup();
          }
          callWithAsyncErrorHandling(cb, instance, 3, [
            newValue,
            // pass undefined as the old value when it's changed for the first time
            oldValue === INITIAL_WATCHER_VALUE ? void 0 : isMultiSource && oldValue[0] === INITIAL_WATCHER_VALUE ? [] : oldValue,
            onCleanup
          ]);
          oldValue = newValue;
        }
      } else {
        effect.run();
      }
    };
    job.allowRecurse = !!cb;
    let scheduler;
    if (flush === "sync") {
      scheduler = job;
    } else if (flush === "post") {
      scheduler = () => queuePostRenderEffect(job, instance && instance.suspense);
    } else {
      job.pre = true;
      if (instance)
        job.id = instance.uid;
      scheduler = () => queueJob(job);
    }
    const effect = new ReactiveEffect(getter, scheduler);
    {
      effect.onTrack = onTrack;
      effect.onTrigger = onTrigger;
    }
    if (cb) {
      if (immediate) {
        job();
      } else {
        oldValue = effect.run();
      }
    } else if (flush === "post") {
      queuePostRenderEffect(
        effect.run.bind(effect),
        instance && instance.suspense
      );
    } else {
      effect.run();
    }
    const unwatch = () => {
      effect.stop();
      if (instance && instance.scope) {
        remove(instance.scope.effects, effect);
      }
    };
    return unwatch;
  }
  function instanceWatch(source, value, options) {
    const publicThis = this.proxy;
    const getter = isString(source) ? source.includes(".") ? createPathGetter(publicThis, source) : () => publicThis[source] : source.bind(publicThis, publicThis);
    let cb;
    if (isFunction(value)) {
      cb = value;
    } else {
      cb = value.handler;
      options = value;
    }
    const cur = currentInstance;
    setCurrentInstance(this);
    const res = doWatch(getter, cb.bind(publicThis), options);
    if (cur) {
      setCurrentInstance(cur);
    } else {
      unsetCurrentInstance();
    }
    return res;
  }
  function createPathGetter(ctx, path) {
    const segments = path.split(".");
    return () => {
      let cur = ctx;
      for (let i = 0; i < segments.length && cur; i++) {
        cur = cur[segments[i]];
      }
      return cur;
    };
  }
  function traverse(value, seen) {
    if (!isObject(value) || value["__v_skip"]) {
      return value;
    }
    seen = seen || /* @__PURE__ */ new Set();
    if (seen.has(value)) {
      return value;
    }
    seen.add(value);
    if (isRef(value)) {
      traverse(value.value, seen);
    } else if (isArray(value)) {
      for (let i = 0; i < value.length; i++) {
        traverse(value[i], seen);
      }
    } else if (isSet(value) || isMap(value)) {
      value.forEach((v) => {
        traverse(v, seen);
      });
    } else if (isPlainObject(value)) {
      for (const key in value) {
        traverse(value[key], seen);
      }
    }
    return value;
  }
  const NULL_DYNAMIC_COMPONENT = Symbol.for("v-ndc");

  const getPublicInstance = (i) => {
    if (!i)
      return null;
    if (isStatefulComponent(i))
      return getExposeProxy(i) || i.proxy;
    return getPublicInstance(i.parent);
  };
  const publicPropertiesMap = (
    // Move PURE marker to new line to workaround compiler discarding it
    // due to type annotation
    /* @__PURE__ */ extend(/* @__PURE__ */ Object.create(null), {
      $: (i) => i,
      $el: (i) => i.vnode.el,
      $data: (i) => i.data,
      $props: (i) => shallowReadonly(i.props) ,
      $attrs: (i) => shallowReadonly(i.attrs) ,
      $slots: (i) => shallowReadonly(i.slots) ,
      $refs: (i) => shallowReadonly(i.refs) ,
      $parent: (i) => getPublicInstance(i.parent),
      $root: (i) => getPublicInstance(i.root),
      $emit: (i) => i.emit,
      $options: (i) => __VUE_OPTIONS_API__ ? resolveMergedOptions(i) : i.type,
      $forceUpdate: (i) => i.f || (i.f = () => queueJob(i.update)),
      $nextTick: (i) => i.n || (i.n = nextTick.bind(i.proxy)),
      $watch: (i) => __VUE_OPTIONS_API__ ? instanceWatch.bind(i) : NOOP
    })
  );
  const hasSetupBinding = (state, key) => state !== EMPTY_OBJ && !state.__isScriptSetup && hasOwn(state, key);
  const PublicInstanceProxyHandlers = {
    get({ _: instance }, key) {
      const { ctx, setupState, data, props, accessCache, type, appContext } = instance;
      if (key === "__isVue") {
        return true;
      }
      let normalizedProps;
      if (key[0] !== "$") {
        const n = accessCache[key];
        if (n !== void 0) {
          switch (n) {
            case 1 /* SETUP */:
              return setupState[key];
            case 2 /* DATA */:
              return data[key];
            case 4 /* CONTEXT */:
              return ctx[key];
            case 3 /* PROPS */:
              return props[key];
          }
        } else if (hasSetupBinding(setupState, key)) {
          accessCache[key] = 1 /* SETUP */;
          return setupState[key];
        } else if (data !== EMPTY_OBJ && hasOwn(data, key)) {
          accessCache[key] = 2 /* DATA */;
          return data[key];
        } else if (
          // only cache other properties when instance has declared (thus stable)
          // props
          (normalizedProps = instance.propsOptions[0]) && hasOwn(normalizedProps, key)
        ) {
          accessCache[key] = 3 /* PROPS */;
          return props[key];
        } else if (ctx !== EMPTY_OBJ && hasOwn(ctx, key)) {
          accessCache[key] = 4 /* CONTEXT */;
          return ctx[key];
        } else if (!__VUE_OPTIONS_API__ || shouldCacheAccess) {
          accessCache[key] = 0 /* OTHER */;
        }
      }
      const publicGetter = publicPropertiesMap[key];
      let cssModule, globalProperties;
      if (publicGetter) {
        if (key === "$attrs") {
          track(instance, "get", key);
        } else if (key === "$slots") {
          track(instance, "get", key);
        }
        return publicGetter(instance);
      } else if (
        // css module (injected by vue-loader)
        (cssModule = type.__cssModules) && (cssModule = cssModule[key])
      ) {
        return cssModule;
      } else if (ctx !== EMPTY_OBJ && hasOwn(ctx, key)) {
        accessCache[key] = 4 /* CONTEXT */;
        return ctx[key];
      } else if (
        // global properties
        globalProperties = appContext.config.globalProperties, hasOwn(globalProperties, key)
      ) {
        {
          return globalProperties[key];
        }
      } else ;
    },
    set({ _: instance }, key, value) {
      const { data, setupState, ctx } = instance;
      if (hasSetupBinding(setupState, key)) {
        setupState[key] = value;
        return true;
      } else if (setupState.__isScriptSetup && hasOwn(setupState, key)) {
        warn(`Cannot mutate <script setup> binding "${key}" from Options API.`);
        return false;
      } else if (data !== EMPTY_OBJ && hasOwn(data, key)) {
        data[key] = value;
        return true;
      } else if (hasOwn(instance.props, key)) {
        warn(`Attempting to mutate prop "${key}". Props are readonly.`);
        return false;
      }
      if (key[0] === "$" && key.slice(1) in instance) {
        warn(
          `Attempting to mutate public property "${key}". Properties starting with $ are reserved and readonly.`
        );
        return false;
      } else {
        if (key in instance.appContext.config.globalProperties) {
          Object.defineProperty(ctx, key, {
            enumerable: true,
            configurable: true,
            value
          });
        } else {
          ctx[key] = value;
        }
      }
      return true;
    },
    has({
      _: { data, setupState, accessCache, ctx, appContext, propsOptions }
    }, key) {
      let normalizedProps;
      return !!accessCache[key] || data !== EMPTY_OBJ && hasOwn(data, key) || hasSetupBinding(setupState, key) || (normalizedProps = propsOptions[0]) && hasOwn(normalizedProps, key) || hasOwn(ctx, key) || hasOwn(publicPropertiesMap, key) || hasOwn(appContext.config.globalProperties, key);
    },
    defineProperty(target, key, descriptor) {
      if (descriptor.get != null) {
        target._.accessCache[key] = 0;
      } else if (hasOwn(descriptor, "value")) {
        this.set(target, key, descriptor.value, null);
      }
      return Reflect.defineProperty(target, key, descriptor);
    }
  };
  {
    PublicInstanceProxyHandlers.ownKeys = (target) => {
      warn(
        `Avoid app logic that relies on enumerating keys on a component instance. The keys will be empty in production mode to avoid performance overhead.`
      );
      return Reflect.ownKeys(target);
    };
  }
  function normalizePropsOrEmits(props) {
    return isArray(props) ? props.reduce(
      (normalized, p) => (normalized[p] = null, normalized),
      {}
    ) : props;
  }
  let shouldCacheAccess = true;
  function resolveMergedOptions(instance) {
    const base = instance.type;
    const { mixins, extends: extendsOptions } = base;
    const {
      mixins: globalMixins,
      optionsCache: cache,
      config: { optionMergeStrategies }
    } = instance.appContext;
    const cached = cache.get(base);
    let resolved;
    if (cached) {
      resolved = cached;
    } else if (!globalMixins.length && !mixins && !extendsOptions) {
      {
        resolved = base;
      }
    } else {
      resolved = {};
      if (globalMixins.length) {
        globalMixins.forEach(
          (m) => mergeOptions(resolved, m, optionMergeStrategies, true)
        );
      }
      mergeOptions(resolved, base, optionMergeStrategies);
    }
    if (isObject(base)) {
      cache.set(base, resolved);
    }
    return resolved;
  }
  function mergeOptions(to, from, strats, asMixin = false) {
    const { mixins, extends: extendsOptions } = from;
    if (extendsOptions) {
      mergeOptions(to, extendsOptions, strats, true);
    }
    if (mixins) {
      mixins.forEach(
        (m) => mergeOptions(to, m, strats, true)
      );
    }
    for (const key in from) {
      if (asMixin && key === "expose") {
        warn(
          `"expose" option is ignored when declared in mixins or extends. It should only be declared in the base component itself.`
        );
      } else {
        const strat = internalOptionMergeStrats[key] || strats && strats[key];
        to[key] = strat ? strat(to[key], from[key]) : from[key];
      }
    }
    return to;
  }
  const internalOptionMergeStrats = {
    data: mergeDataFn,
    props: mergeEmitsOrPropsOptions,
    emits: mergeEmitsOrPropsOptions,
    // objects
    methods: mergeObjectOptions,
    computed: mergeObjectOptions,
    // lifecycle
    beforeCreate: mergeAsArray,
    created: mergeAsArray,
    beforeMount: mergeAsArray,
    mounted: mergeAsArray,
    beforeUpdate: mergeAsArray,
    updated: mergeAsArray,
    beforeDestroy: mergeAsArray,
    beforeUnmount: mergeAsArray,
    destroyed: mergeAsArray,
    unmounted: mergeAsArray,
    activated: mergeAsArray,
    deactivated: mergeAsArray,
    errorCaptured: mergeAsArray,
    serverPrefetch: mergeAsArray,
    // assets
    components: mergeObjectOptions,
    directives: mergeObjectOptions,
    // watch
    watch: mergeWatchOptions,
    // provide / inject
    provide: mergeDataFn,
    inject: mergeInject
  };
  function mergeDataFn(to, from) {
    if (!from) {
      return to;
    }
    if (!to) {
      return from;
    }
    return function mergedDataFn() {
      return (extend)(
        isFunction(to) ? to.call(this, this) : to,
        isFunction(from) ? from.call(this, this) : from
      );
    };
  }
  function mergeInject(to, from) {
    return mergeObjectOptions(normalizeInject(to), normalizeInject(from));
  }
  function normalizeInject(raw) {
    if (isArray(raw)) {
      const res = {};
      for (let i = 0; i < raw.length; i++) {
        res[raw[i]] = raw[i];
      }
      return res;
    }
    return raw;
  }
  function mergeAsArray(to, from) {
    return to ? [...new Set([].concat(to, from))] : from;
  }
  function mergeObjectOptions(to, from) {
    return to ? extend(/* @__PURE__ */ Object.create(null), to, from) : from;
  }
  function mergeEmitsOrPropsOptions(to, from) {
    if (to) {
      if (isArray(to) && isArray(from)) {
        return [.../* @__PURE__ */ new Set([...to, ...from])];
      }
      return extend(
        /* @__PURE__ */ Object.create(null),
        normalizePropsOrEmits(to),
        normalizePropsOrEmits(from != null ? from : {})
      );
    } else {
      return from;
    }
  }
  function mergeWatchOptions(to, from) {
    if (!to)
      return from;
    if (!from)
      return to;
    const merged = extend(/* @__PURE__ */ Object.create(null), to);
    for (const key in from) {
      merged[key] = mergeAsArray(to[key], from[key]);
    }
    return merged;
  }

  const queuePostRenderEffect = queueEffectWithSuspense ;

  const isTeleport = (type) => type.__isTeleport;

  const Fragment = Symbol.for("v-fgt");
  const Text = Symbol.for("v-txt");
  const Comment = Symbol.for("v-cmt");
  let currentBlock = null;
  function isVNode(value) {
    return value ? value.__v_isVNode === true : false;
  }
  const createVNodeWithArgsTransform = (...args) => {
    return _createVNode(
      ...args
    );
  };
  const InternalObjectKey = `__vInternal`;
  const normalizeKey = ({ key }) => key != null ? key : null;
  const normalizeRef = ({
    ref,
    ref_key,
    ref_for
  }) => {
    if (typeof ref === "number") {
      ref = "" + ref;
    }
    return ref != null ? isString(ref) || isRef(ref) || isFunction(ref) ? { i: currentRenderingInstance, r: ref, k: ref_key, f: !!ref_for } : ref : null;
  };
  function createBaseVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, shapeFlag = type === Fragment ? 0 : 1, isBlockNode = false, needFullChildrenNormalization = false) {
    const vnode = {
      __v_isVNode: true,
      __v_skip: true,
      type,
      props,
      key: props && normalizeKey(props),
      ref: props && normalizeRef(props),
      scopeId: currentScopeId,
      slotScopeIds: null,
      children,
      component: null,
      suspense: null,
      ssContent: null,
      ssFallback: null,
      dirs: null,
      transition: null,
      el: null,
      anchor: null,
      target: null,
      targetAnchor: null,
      staticCount: 0,
      shapeFlag,
      patchFlag,
      dynamicProps,
      dynamicChildren: null,
      appContext: null,
      ctx: currentRenderingInstance
    };
    if (needFullChildrenNormalization) {
      normalizeChildren(vnode, children);
      if (shapeFlag & 128) {
        type.normalize(vnode);
      }
    } else if (children) {
      vnode.shapeFlag |= isString(children) ? 8 : 16;
    }
    if (vnode.key !== vnode.key) {
      warn(`VNode created with invalid key (NaN). VNode type:`, vnode.type);
    }
    if (// avoid a block node from tracking itself
    !isBlockNode && // has current parent block
    currentBlock && // presence of a patch flag indicates this node needs patching on updates.
    // component nodes also should always be patched, because even if the
    // component doesn't need to update, it needs to persist the instance on to
    // the next vnode so that it can be properly unmounted later.
    (vnode.patchFlag > 0 || shapeFlag & 6) && // the EVENTS flag is only for hydration and if it is the only flag, the
    // vnode should not be considered dynamic due to handler caching.
    vnode.patchFlag !== 32) {
      currentBlock.push(vnode);
    }
    return vnode;
  }
  const createVNode = createVNodeWithArgsTransform ;
  function _createVNode(type, props = null, children = null, patchFlag = 0, dynamicProps = null, isBlockNode = false) {
    if (!type || type === NULL_DYNAMIC_COMPONENT) {
      if (!type) {
        warn(`Invalid vnode type when creating vnode: ${type}.`);
      }
      type = Comment;
    }
    if (isVNode(type)) {
      const cloned = cloneVNode(
        type,
        props,
        true
        /* mergeRef: true */
      );
      if (children) {
        normalizeChildren(cloned, children);
      }
      if (!isBlockNode && currentBlock) {
        if (cloned.shapeFlag & 6) {
          currentBlock[currentBlock.indexOf(type)] = cloned;
        } else {
          currentBlock.push(cloned);
        }
      }
      cloned.patchFlag |= -2;
      return cloned;
    }
    if (isClassComponent(type)) {
      type = type.__vccOpts;
    }
    if (props) {
      props = guardReactiveProps(props);
      let { class: klass, style } = props;
      if (klass && !isString(klass)) {
        props.class = normalizeClass(klass);
      }
      if (isObject(style)) {
        if (isProxy(style) && !isArray(style)) {
          style = extend({}, style);
        }
        props.style = normalizeStyle(style);
      }
    }
    const shapeFlag = isString(type) ? 1 : isSuspense(type) ? 128 : isTeleport(type) ? 64 : isObject(type) ? 4 : isFunction(type) ? 2 : 0;
    if (shapeFlag & 4 && isProxy(type)) {
      type = toRaw(type);
      warn(
        `Vue received a Component which was made a reactive object. This can lead to unnecessary performance overhead, and should be avoided by marking the component with \`markRaw\` or using \`shallowRef\` instead of \`ref\`.`,
        `
Component that was made reactive: `,
        type
      );
    }
    return createBaseVNode(
      type,
      props,
      children,
      patchFlag,
      dynamicProps,
      shapeFlag,
      isBlockNode,
      true
    );
  }
  function guardReactiveProps(props) {
    if (!props)
      return null;
    return isProxy(props) || InternalObjectKey in props ? extend({}, props) : props;
  }
  function cloneVNode(vnode, extraProps, mergeRef = false) {
    const { props, ref, patchFlag, children } = vnode;
    const mergedProps = extraProps ? mergeProps(props || {}, extraProps) : props;
    const cloned = {
      __v_isVNode: true,
      __v_skip: true,
      type: vnode.type,
      props: mergedProps,
      key: mergedProps && normalizeKey(mergedProps),
      ref: extraProps && extraProps.ref ? (
        // #2078 in the case of <component :is="vnode" ref="extra"/>
        // if the vnode itself already has a ref, cloneVNode will need to merge
        // the refs so the single vnode can be set on multiple refs
        mergeRef && ref ? isArray(ref) ? ref.concat(normalizeRef(extraProps)) : [ref, normalizeRef(extraProps)] : normalizeRef(extraProps)
      ) : ref,
      scopeId: vnode.scopeId,
      slotScopeIds: vnode.slotScopeIds,
      children: patchFlag === -1 && isArray(children) ? children.map(deepCloneVNode) : children,
      target: vnode.target,
      targetAnchor: vnode.targetAnchor,
      staticCount: vnode.staticCount,
      shapeFlag: vnode.shapeFlag,
      // if the vnode is cloned with extra props, we can no longer assume its
      // existing patch flag to be reliable and need to add the FULL_PROPS flag.
      // note: preserve flag for fragments since they use the flag for children
      // fast paths only.
      patchFlag: extraProps && vnode.type !== Fragment ? patchFlag === -1 ? 16 : patchFlag | 16 : patchFlag,
      dynamicProps: vnode.dynamicProps,
      dynamicChildren: vnode.dynamicChildren,
      appContext: vnode.appContext,
      dirs: vnode.dirs,
      transition: vnode.transition,
      // These should technically only be non-null on mounted VNodes. However,
      // they *should* be copied for kept-alive vnodes. So we just always copy
      // them since them being non-null during a mount doesn't affect the logic as
      // they will simply be overwritten.
      component: vnode.component,
      suspense: vnode.suspense,
      ssContent: vnode.ssContent && cloneVNode(vnode.ssContent),
      ssFallback: vnode.ssFallback && cloneVNode(vnode.ssFallback),
      el: vnode.el,
      anchor: vnode.anchor,
      ctx: vnode.ctx,
      ce: vnode.ce
    };
    return cloned;
  }
  function deepCloneVNode(vnode) {
    const cloned = cloneVNode(vnode);
    if (isArray(vnode.children)) {
      cloned.children = vnode.children.map(deepCloneVNode);
    }
    return cloned;
  }
  function createTextVNode(text = " ", flag = 0) {
    return createVNode(Text, null, text, flag);
  }
  function normalizeChildren(vnode, children) {
    let type = 0;
    const { shapeFlag } = vnode;
    if (children == null) {
      children = null;
    } else if (isArray(children)) {
      type = 16;
    } else if (typeof children === "object") {
      if (shapeFlag & (1 | 64)) {
        const slot = children.default;
        if (slot) {
          slot._c && (slot._d = false);
          normalizeChildren(vnode, slot());
          slot._c && (slot._d = true);
        }
        return;
      } else {
        type = 32;
        const slotFlag = children._;
        if (!slotFlag && !(InternalObjectKey in children)) {
          children._ctx = currentRenderingInstance;
        } else if (slotFlag === 3 && currentRenderingInstance) {
          if (currentRenderingInstance.slots._ === 1) {
            children._ = 1;
          } else {
            children._ = 2;
            vnode.patchFlag |= 1024;
          }
        }
      }
    } else if (isFunction(children)) {
      children = { default: children, _ctx: currentRenderingInstance };
      type = 32;
    } else {
      children = String(children);
      if (shapeFlag & 64) {
        type = 16;
        children = [createTextVNode(children)];
      } else {
        type = 8;
      }
    }
    vnode.children = children;
    vnode.shapeFlag |= type;
  }
  function mergeProps(...args) {
    const ret = {};
    for (let i = 0; i < args.length; i++) {
      const toMerge = args[i];
      for (const key in toMerge) {
        if (key === "class") {
          if (ret.class !== toMerge.class) {
            ret.class = normalizeClass([ret.class, toMerge.class]);
          }
        } else if (key === "style") {
          ret.style = normalizeStyle([ret.style, toMerge.style]);
        } else if (isOn(key)) {
          const existing = ret[key];
          const incoming = toMerge[key];
          if (incoming && existing !== incoming && !(isArray(existing) && existing.includes(incoming))) {
            ret[key] = existing ? [].concat(existing, incoming) : incoming;
          }
        } else if (key !== "") {
          ret[key] = toMerge[key];
        }
      }
    }
    return ret;
  }
  let currentInstance = null;
  let internalSetCurrentInstance;
  let globalCurrentInstanceSetters;
  let settersKey = "__VUE_INSTANCE_SETTERS__";
  {
    if (!(globalCurrentInstanceSetters = getGlobalThis()[settersKey])) {
      globalCurrentInstanceSetters = getGlobalThis()[settersKey] = [];
    }
    globalCurrentInstanceSetters.push((i) => currentInstance = i);
    internalSetCurrentInstance = (instance) => {
      if (globalCurrentInstanceSetters.length > 1) {
        globalCurrentInstanceSetters.forEach((s) => s(instance));
      } else {
        globalCurrentInstanceSetters[0](instance);
      }
    };
  }
  const setCurrentInstance = (instance) => {
    internalSetCurrentInstance(instance);
    instance.scope.on();
  };
  const unsetCurrentInstance = () => {
    currentInstance && currentInstance.scope.off();
    internalSetCurrentInstance(null);
  };
  function isStatefulComponent(instance) {
    return instance.vnode.shapeFlag & 4;
  }
  function getExposeProxy(instance) {
    if (instance.exposed) {
      return instance.exposeProxy || (instance.exposeProxy = new Proxy(proxyRefs(markRaw(instance.exposed)), {
        get(target, key) {
          if (key in target) {
            return target[key];
          } else if (key in publicPropertiesMap) {
            return publicPropertiesMap[key](instance);
          }
        },
        has(target, key) {
          return key in target || key in publicPropertiesMap;
        }
      }));
    }
  }
  const classifyRE = /(?:^|[-_])(\w)/g;
  const classify = (str) => str.replace(classifyRE, (c) => c.toUpperCase()).replace(/[-_]/g, "");
  function getComponentName(Component, includeInferred = true) {
    return isFunction(Component) ? Component.displayName || Component.name : Component.name || includeInferred && Component.__name;
  }
  function formatComponentName(instance, Component, isRoot = false) {
    let name = getComponentName(Component);
    if (!name && Component.__file) {
      const match = Component.__file.match(/([^/\\]+)\.\w+$/);
      if (match) {
        name = match[1];
      }
    }
    if (!name && instance && instance.parent) {
      const inferFromRegistry = (registry) => {
        for (const key in registry) {
          if (registry[key] === Component) {
            return key;
          }
        }
      };
      name = inferFromRegistry(
        instance.components || instance.parent.type.components
      ) || inferFromRegistry(instance.appContext.components);
    }
    return name ? classify(name) : isRoot ? `App` : `Anonymous`;
  }
  function isClassComponent(value) {
    return isFunction(value) && "__vccOpts" in value;
  }

  function isShallow(value) {
    return !!(value && value["__v_isShallow"]);
  }

  function initCustomFormatter() {
    if (typeof window === "undefined") {
      return;
    }
    const vueStyle = { style: "color:#3ba776" };
    const numberStyle = { style: "color:#0b1bc9" };
    const stringStyle = { style: "color:#b62e24" };
    const keywordStyle = { style: "color:#9d288c" };
    const formatter = {
      header(obj) {
        if (!isObject(obj)) {
          return null;
        }
        if (obj.__isVue) {
          return ["div", vueStyle, `VueInstance`];
        } else if (isRef(obj)) {
          return [
            "div",
            {},
            ["span", vueStyle, genRefFlag(obj)],
            "<",
            formatValue(obj.value),
            `>`
          ];
        } else if (isReactive(obj)) {
          return [
            "div",
            {},
            ["span", vueStyle, isShallow(obj) ? "ShallowReactive" : "Reactive"],
            "<",
            formatValue(obj),
            `>${isReadonly(obj) ? ` (readonly)` : ``}`
          ];
        } else if (isReadonly(obj)) {
          return [
            "div",
            {},
            ["span", vueStyle, isShallow(obj) ? "ShallowReadonly" : "Readonly"],
            "<",
            formatValue(obj),
            ">"
          ];
        }
        return null;
      },
      hasBody(obj) {
        return obj && obj.__isVue;
      },
      body(obj) {
        if (obj && obj.__isVue) {
          return [
            "div",
            {},
            ...formatInstance(obj.$)
          ];
        }
      }
    };
    function formatInstance(instance) {
      const blocks = [];
      if (instance.type.props && instance.props) {
        blocks.push(createInstanceBlock("props", toRaw(instance.props)));
      }
      if (instance.setupState !== EMPTY_OBJ) {
        blocks.push(createInstanceBlock("setup", instance.setupState));
      }
      if (instance.data !== EMPTY_OBJ) {
        blocks.push(createInstanceBlock("data", toRaw(instance.data)));
      }
      const computed = extractKeys(instance, "computed");
      if (computed) {
        blocks.push(createInstanceBlock("computed", computed));
      }
      const injected = extractKeys(instance, "inject");
      if (injected) {
        blocks.push(createInstanceBlock("injected", injected));
      }
      blocks.push([
        "div",
        {},
        [
          "span",
          {
            style: keywordStyle.style + ";opacity:0.66"
          },
          "$ (internal): "
        ],
        ["object", { object: instance }]
      ]);
      return blocks;
    }
    function createInstanceBlock(type, target) {
      target = extend({}, target);
      if (!Object.keys(target).length) {
        return ["span", {}];
      }
      return [
        "div",
        { style: "line-height:1.25em;margin-bottom:0.6em" },
        [
          "div",
          {
            style: "color:#476582"
          },
          type
        ],
        [
          "div",
          {
            style: "padding-left:1.25em"
          },
          ...Object.keys(target).map((key) => {
            return [
              "div",
              {},
              ["span", keywordStyle, key + ": "],
              formatValue(target[key], false)
            ];
          })
        ]
      ];
    }
    function formatValue(v, asRaw = true) {
      if (typeof v === "number") {
        return ["span", numberStyle, v];
      } else if (typeof v === "string") {
        return ["span", stringStyle, JSON.stringify(v)];
      } else if (typeof v === "boolean") {
        return ["span", keywordStyle, v];
      } else if (isObject(v)) {
        return ["object", { object: asRaw ? toRaw(v) : v }];
      } else {
        return ["span", stringStyle, String(v)];
      }
    }
    function extractKeys(instance, type) {
      const Comp = instance.type;
      if (isFunction(Comp)) {
        return;
      }
      const extracted = {};
      for (const key in instance.ctx) {
        if (isKeyOfType(Comp, key, type)) {
          extracted[key] = instance.ctx[key];
        }
      }
      return extracted;
    }
    function isKeyOfType(Comp, key, type) {
      const opts = Comp[type];
      if (isArray(opts) && opts.includes(key) || isObject(opts) && key in opts) {
        return true;
      }
      if (Comp.extends && isKeyOfType(Comp.extends, key, type)) {
        return true;
      }
      if (Comp.mixins && Comp.mixins.some((m) => isKeyOfType(m, key, type))) {
        return true;
      }
    }
    function genRefFlag(v) {
      if (isShallow(v)) {
        return `ShallowRef`;
      }
      if (v.effect) {
        return `ComputedRef`;
      }
      return `Ref`;
    }
    if (window.devtoolsFormatters) {
      window.devtoolsFormatters.push(formatter);
    } else {
      window.devtoolsFormatters = [formatter];
    }
  }

  function initDev() {
    {
      initCustomFormatter();
    }
  }

  {
    initDev();
  }

  var OnetwotreeIcon = {
    name: 'OnetwotreeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-123",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 10l2 -2v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 8h3a1 1 0 0 1 1 1v2a1 1 0 0 1 -1 1h-2a1 1 0 0 0 -1 1v2a1 1 0 0 0 1 1h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 8h2.5a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1 -1.5 1.5h-1.5h1.5a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1 -1.5 1.5h-2.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var TwentyFourHoursIcon = {
    name: 'TwentyFourHoursIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-24-hours",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 11a8.1 8.1 0 0 0 -15.5 -2m-.5 -4v4h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 13a8.094 8.094 0 0 0 3 5.24"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 15h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 15v2a1 1 0 0 0 1 1h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 15v6"
      }, null), createTextVNode(" ")]);
    }
  };

  var TwoFactorAuthIcon = {
    name: 'TwoFactorAuthIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-2fa",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 16h-4l3.47 -4.66a2 2 0 1 0 -3.47 -1.54"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 16v-8h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 12l3 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 16v-6a2 2 0 0 1 4 0v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 13l4 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var Deg360ViewIcon = {
    name: 'Deg360ViewIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-360-view",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 6a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h2a1 1 0 0 0 1 -1v-2a1 1 0 0 0 -1 -1h-3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5h2.5a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1 -1.5 1.5h-1.5h1.5a1.5 1.5 0 0 1 1.5 1.5v1a1.5 1.5 0 0 1 -1.5 1.5h-2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 7v4a2 2 0 1 0 4 0v-4a2 2 0 1 0 -4 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 16c0 1.657 4.03 3 9 3s9 -1.343 9 -3"
      }, null), createTextVNode(" ")]);
    }
  };

  var Deg360Icon = {
    name: 'Deg360Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-360",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 15.328c2.414 -.718 4 -1.94 4 -3.328c0 -2.21 -4.03 -4 -9 -4s-9 1.79 -9 4s4.03 4 9 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 13l3 3l-3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ThreedCubeSphereOffIcon = {
    name: 'ThreedCubeSphereOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-3d-cube-sphere-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 17.6l-2 -1.1v-2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10v-2.5l2 -1.1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 4.1l2 -1.1l2 1.1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 6.4l2 1.1v2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 14v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 19.9l-2 1.1l-2 -1.1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 8.6l2 -1.1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12v2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18.5v2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l-2 -1.12"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 8.6l-2 -1.1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var ThreedCubeSphereIcon = {
    name: 'ThreedCubeSphereIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-3d-cube-sphere",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 17.6l-2 -1.1v-2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10v-2.5l2 -1.1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 4.1l2 -1.1l2 1.1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 6.4l2 1.1v2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 14v2.5l-2 1.12"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 19.9l-2 1.1l-2 -1.1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l2 -1.1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 8.6l2 -1.1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l0 2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18.5l0 2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l-2 -1.12"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 8.6l-2 -1.1"
      }, null), createTextVNode(" ")]);
    }
  };

  var ThreedRotateIcon = {
    name: 'ThreedRotateIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-3d-rotate",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3a7 7 0 0 1 7 7v4l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M22 11l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 15.5l-5 -3l5 -3l5 3v5.5l-5 3z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 12.5v5.5l5 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 15.545l5 -3.03"
      }, null), createTextVNode(" ")]);
    }
  };

  var AB2Icon = {
    name: 'AB2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-a-b-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 21h3c.81 0 1.48 -.67 1.48 -1.48l.02 -.02c0 -.82 -.69 -1.5 -1.5 -1.5h-3v3z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 15h2.5c.84 -.01 1.5 .66 1.5 1.5s-.66 1.5 -1.5 1.5h-2.5v-3z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 9v-4c0 -1.036 .895 -2 2 -2s2 .964 2 2v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M2.99 11.98a9 9 0 0 0 9 9m9 -9a9 9 0 0 0 -9 -9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 7h-4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ABOffIcon = {
    name: 'ABOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-a-b-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 16v-5.5a2.5 2.5 0 0 1 5 0v5.5m0 -4h-5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 6v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 8h3a2 2 0 1 1 0 4h-3m3 0a2 2 0 0 1 .83 3.82m-3.83 -3.82v-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var ABIcon = {
    name: 'ABIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-a-b",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 16v-5.5a2.5 2.5 0 0 1 5 0v5.5m0 -4h-5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 6l0 12"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 16v-8h3a2 2 0 0 1 0 4h-3m3 0a2 2 0 0 1 0 4h-3"
      }, null), createTextVNode(" ")]);
    }
  };

  var AbacusOffIcon = {
    name: 'AbacusOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-abacus-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 5v16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 21v-2m0 -4v-12"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 7h2m4 0h8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 15h10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 13v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 13v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 16v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 5v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 5v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 8v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 21h18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AbacusIcon = {
    name: 'AbacusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-abacus",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 3v18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 21v-18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 7h14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 15h14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 13v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 13v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 13v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 5v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 5v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 5v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 21h18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AbcIcon = {
    name: 'AbcIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-abc",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 16v-6a2 2 0 1 1 4 0v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 13h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 8v6a2 2 0 1 0 4 0v-1a2 2 0 1 0 -4 0v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.732 12a2 2 0 0 0 -3.732 1v1a2 2 0 0 0 3.726 1.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AccessPointOffIcon = {
    name: 'AccessPointOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-access-point-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.828 9.172a4 4 0 0 1 1.172 2.828"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.657 6.343a8 8 0 0 1 1.635 8.952"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.168 14.828a4 4 0 0 1 0 -5.656"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.337 17.657a8 8 0 0 1 0 -11.314"
      }, null), createTextVNode(" ")]);
    }
  };

  var AccessPointIcon = {
    name: 'AccessPointIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-access-point",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.828 9.172a4 4 0 0 1 0 5.656"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.657 6.343a8 8 0 0 1 0 11.314"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.168 14.828a4 4 0 0 1 0 -5.656"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.337 17.657a8 8 0 0 1 0 -11.314"
      }, null), createTextVNode(" ")]);
    }
  };

  var AccessibleOffFilledIcon = {
    name: 'AccessibleOffFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-accessible-off-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 3.34a10 10 0 1 1 -14.995 8.984l-.005 -.324l.005 -.324a10 10 0 0 1 14.995 -8.336zm-1.051 6.844a1 1 0 0 0 -1.152 -.663l-.113 .03l-2.684 .895l-2.684 -.895l-.113 -.03a1 1 0 0 0 -.628 1.884l.109 .044l2.316 .771v.976l-1.832 2.75l-.06 .1a1 1 0 0 0 .237 1.21l.1 .076l.101 .06a1 1 0 0 0 1.21 -.237l.076 -.1l1.168 -1.752l1.168 1.752l.07 .093a1 1 0 0 0 1.653 -1.102l-.059 -.1l-1.832 -2.75v-.977l2.316 -.771l.109 -.044a1 1 0 0 0 .524 -1.221zm-3.949 -4.184a1.5 1.5 0 1 0 0 3a1.5 1.5 0 0 0 0 -3z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AccessibleOffIcon = {
    name: 'AccessibleOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-accessible-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 16.5l2 -3l2 3m-2 -3v-1.5m2.627 -1.376l.373 -.124m-6 0l2.231 .744"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.042 16.045a9 9 0 0 0 -12.087 -12.087m-2.318 1.677a9 9 0 1 0 12.725 12.73"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8a.5 .5 0 1 0 -.5 -.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AccessibleIcon = {
    name: 'AccessibleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-accessible",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 16.5l2 -3l2 3m-2 -3v-2l3 -1m-6 0l3 1"
      }, null), createTextVNode("   "), createVNode("circle", {
        "cx": "12",
        "cy": "7.5",
        "r": ".5",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ActivityHeartbeatIcon = {
    name: 'ActivityHeartbeatIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-activity-heartbeat",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 12h4.5l1.5 -6l4 12l2 -9l1.5 3h4.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var ActivityIcon = {
    name: 'ActivityIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-activity",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 12h4l3 8l4 -16l3 8h4"
      }, null), createTextVNode(" ")]);
    }
  };

  var Ad2Icon = {
    name: 'Ad2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ad-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.933 5h-6.933v16h13v-8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 17h-5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 13h5v-4h-5z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 5v-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 6l2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 9h2"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdCircleFilledIcon = {
    name: 'AdCircleFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ad-circle-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 2c5.523 0 10 4.477 10 10s-4.477 10 -10 10c-5.43 0 -9.848 -4.327 -9.996 -9.72l-.004 -.28l.004 -.28c.148 -5.393 4.566 -9.72 9.996 -9.72zm-3.5 6a2.5 2.5 0 0 0 -2.495 2.336l-.005 .164v4.5l.007 .117a1 1 0 0 0 1.986 0l.007 -.117v-1h1v1l.007 .117a1 1 0 0 0 1.986 0l.007 -.117v-4.5l-.005 -.164a2.5 2.5 0 0 0 -2.495 -2.336zm6.5 0h-1a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h1a3 3 0 0 0 3 -3v-2a3 3 0 0 0 -3 -3zm0 2a1 1 0 0 1 1 1v2a1 1 0 0 1 -.883 .993l-.117 .007v-4zm-6.5 0a.5 .5 0 0 1 .492 .41l.008 .09v1.5h-1v-1.5l.008 -.09a.5 .5 0 0 1 .492 -.41z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdCircleOffIcon = {
    name: 'AdCircleOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ad-circle-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4.91 4.949a9.968 9.968 0 0 0 -2.91 7.051c0 5.523 4.477 10 10 10a9.968 9.968 0 0 0 7.05 -2.909"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.778 16.793a9.955 9.955 0 0 0 1.222 -4.793c0 -5.523 -4.477 -10 -10 -10c-1.74 0 -3.376 .444 -4.8 1.225"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 15v-4.5a1.5 1.5 0 0 1 2.138 -1.358"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.854 9.853c.094 .196 .146 .415 .146 .647v4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 13h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 14v1h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 13v-2a2 2 0 0 0 -2 -2h-1v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdCircleIcon = {
    name: 'AdCircleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ad-circle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-10 0a10 10 0 1 0 20 0a10 10 0 1 0 -20 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 15v-4.5a1.5 1.5 0 0 1 3 0v4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 13h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdFilledIcon = {
    name: 'AdFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ad-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 4h-14a3 3 0 0 0 -3 3v10a3 3 0 0 0 3 3h14a3 3 0 0 0 3 -3v-10a3 3 0 0 0 -3 -3zm-10 4a3 3 0 0 1 2.995 2.824l.005 .176v4a1 1 0 0 1 -1.993 .117l-.007 -.117v-1h-2v1a1 1 0 0 1 -1.993 .117l-.007 -.117v-4a3 3 0 0 1 3 -3zm0 2a1 1 0 0 0 -.993 .883l-.007 .117v1h2v-1a1 1 0 0 0 -1 -1zm8 -2a1 1 0 0 1 .993 .883l.007 .117v6a1 1 0 0 1 -.883 .993l-.117 .007h-1.5a2.5 2.5 0 1 1 .326 -4.979l.174 .029v-2.05a1 1 0 0 1 .883 -.993l.117 -.007zm-1.41 5.008l-.09 -.008a.5 .5 0 0 0 -.09 .992l.09 .008h.5v-.5l-.008 -.09a.5 .5 0 0 0 -.318 -.379l-.084 -.023z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdOffIcon = {
    name: 'AdOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ad-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 5h10a2 2 0 0 1 2 2v10m-2 2h-14a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 15v-4a2 2 0 0 1 2 -2m2 2v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 13h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 9v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.115 12.131c.33 .149 .595 .412 .747 .74"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdIcon = {
    name: 'AdIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ad",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 15v-4a2 2 0 0 1 4 0v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 13l4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 9v6h-1.5a1.5 1.5 0 1 1 1.5 -1.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var AddressBookOffIcon = {
    name: 'AddressBookOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-address-book-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4h10a2 2 0 0 1 2 2v10m-.57 3.399c-.363 .37 -.87 .601 -1.43 .601h-10a2 2 0 0 1 -2 -2v-12"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 16h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 11a2 2 0 0 0 2 2m2 -2a2 2 0 0 0 -2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AddressBookIcon = {
    name: 'AddressBookIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-address-book",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 6v12a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 16h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 11m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16h3"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsAltIcon = {
    name: 'AdjustmentsAltIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-alt",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8h4v4h-4z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4l0 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12l0 8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 14h4v4h-4z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4l0 10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18l0 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 5h4v4h-4z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4l0 1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9l0 11"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsBoltIcon = {
    name: 'AdjustmentsBoltIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-bolt",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 16a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 16l-2 3h4l-2 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v3"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsCancelIcon = {
    name: 'AdjustmentsCancelIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-cancel",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.499 14.675a2 2 0 1 0 -1.499 3.325"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 21l4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsCheckIcon = {
    name: 'AdjustmentsCheckIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-check",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.823 15.176a2 2 0 1 0 -2.638 2.651"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 19l2 2l4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsCodeIcon = {
    name: 'AdjustmentsCodeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-code",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.557 14.745a2 2 0 1 0 -1.557 3.255"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 21l2 -2l-2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17l-2 2l2 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsCogIcon = {
    name: 'AdjustmentsCogIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-cog",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.199 14.399a2 2 0 1 0 -1.199 3.601"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.001 15.5v1.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.001 21v1.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M22.032 17.25l-1.299 .75"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.27 20l-1.3 .75"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.97 17.25l1.3 .75"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.733 20l1.3 .75"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsDollarIcon = {
    name: 'AdjustmentsDollarIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-dollar",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.366 14.54a2 2 0 1 0 -.216 3.097"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 21v1m0 -8v1"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsDownIcon = {
    name: 'AdjustmentsDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.945 15.53a2 2 0 1 0 -1.945 2.47"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 16v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M22 19l-3 3l-3 -3"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsExclamationIcon = {
    name: 'AdjustmentsExclamationIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-exclamation",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 16a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 16v3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 22v.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsFilledIcon = {
    name: 'AdjustmentsFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 3a1 1 0 0 1 .993 .883l.007 .117v3.171a3.001 3.001 0 0 1 0 5.658v7.171a1 1 0 0 1 -1.993 .117l-.007 -.117v-7.17a3.002 3.002 0 0 1 -1.995 -2.654l-.005 -.176l.005 -.176a3.002 3.002 0 0 1 1.995 -2.654v-3.17a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3a1 1 0 0 1 .993 .883l.007 .117v9.171a3.001 3.001 0 0 1 0 5.658v1.171a1 1 0 0 1 -1.993 .117l-.007 -.117v-1.17a3.002 3.002 0 0 1 -1.995 -2.654l-.005 -.176l.005 -.176a3.002 3.002 0 0 1 1.995 -2.654v-9.17a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 3a1 1 0 0 1 .993 .883l.007 .117v.171a3.001 3.001 0 0 1 0 5.658v10.171a1 1 0 0 1 -1.993 .117l-.007 -.117v-10.17a3.002 3.002 0 0 1 -1.995 -2.654l-.005 -.176l.005 -.176a3.002 3.002 0 0 1 1.995 -2.654v-.17a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsHeartIcon = {
    name: 'AdjustmentsHeartIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-heart",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v8.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsHorizontalIcon = {
    name: 'AdjustmentsHorizontalIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-horizontal",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 6m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 6l8 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 6l4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l2 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 12l10 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 18m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 18l11 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 18l1 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsMinusIcon = {
    name: 'AdjustmentsMinusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-minus",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.954 15.574a2 2 0 1 0 -1.954 2.426"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 19h6"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsOffIcon = {
    name: 'AdjustmentsOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 6v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 16a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v4m0 4v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v5m0 4v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsPauseIcon = {
    name: 'AdjustmentsPauseIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-pause",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.627 14.836a2 2 0 1 0 -.62 2.892"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 17v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v4.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsPinIcon = {
    name: 'AdjustmentsPinIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-pin",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.071 14.31a2 2 0 1 0 -1.071 3.69"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 18v.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsPlusIcon = {
    name: 'AdjustmentsPlusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-plus",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.958 15.592a2 2 0 1 0 -1.958 2.408"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 19h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 16v6"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsQuestionIcon = {
    name: 'AdjustmentsQuestionIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-question",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.577 14.77a2 2 0 1 0 .117 2.295"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 22v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v2"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsSearchIcon = {
    name: 'AdjustmentsSearchIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-search",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 14a2 2 0 0 0 -1.042 3.707"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.2 20.2l1.8 1.8"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsShareIcon = {
    name: 'AdjustmentsShareIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-share",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.387 14.56a2 2 0 1 0 -.798 3.352"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 22l5 -5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 21.5v-4.5h-4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsStarIcon = {
    name: 'AdjustmentsStarIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-star",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v9.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v1"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsUpIcon = {
    name: 'AdjustmentsUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.927 15.462a2 2 0 1 0 -1.927 2.538"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 22v-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M22 19l-3 -3l-3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsXIcon = {
    name: 'AdjustmentsXIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments-x",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.653 14.874a2 2 0 1 0 -.586 2.818"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M22 22l-5 -5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 22l5 -5"
      }, null), createTextVNode(" ")]);
    }
  };

  var AdjustmentsIcon = {
    name: 'AdjustmentsIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-adjustments",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 16a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9v11"
      }, null), createTextVNode(" ")]);
    }
  };

  var AerialLiftIcon = {
    name: 'AerialLiftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-aerial-lift",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 5l16 -2m-8 1v10m-5.106 -6h10.306c2.45 3 2.45 9 -.2 12h-10.106c-2.544 -3 -2.544 -9 0 -12zm-1.894 6h14"
      }, null), createTextVNode(" ")]);
    }
  };

  var AffiliateFilledIcon = {
    name: 'AffiliateFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-affiliate-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.5 3a2.5 2.5 0 1 1 -.912 4.828l-4.556 4.555a5.475 5.475 0 0 1 .936 3.714l2.624 .787a2.5 2.5 0 1 1 -.575 1.916l-2.623 -.788a5.5 5.5 0 0 1 -10.39 -2.29l-.004 -.222l.004 -.221a5.5 5.5 0 0 1 2.984 -4.673l-.788 -2.624a2.498 2.498 0 0 1 -2.194 -2.304l-.006 -.178l.005 -.164a2.5 2.5 0 1 1 4.111 2.071l.787 2.625a5.475 5.475 0 0 1 3.714 .936l4.555 -4.556a2.487 2.487 0 0 1 -.167 -.748l-.005 -.164l.005 -.164a2.5 2.5 0 0 1 2.495 -2.336z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AffiliateIcon = {
    name: 'AffiliateIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-affiliate",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.931 6.936l1.275 4.249m5.607 5.609l4.251 1.275"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.683 12.317l5.759 -5.759"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.5 5.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.5 5.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.5 18.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.5 15.5m-4.5 0a4.5 4.5 0 1 0 9 0a4.5 4.5 0 1 0 -9 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var AirBalloonIcon = {
    name: 'AirBalloonIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-air-balloon",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 19m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16c3.314 0 6 -4.686 6 -8a6 6 0 1 0 -12 0c0 3.314 2.686 8 6 8z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 9m-2 0a2 7 0 1 0 4 0a2 7 0 1 0 -4 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var AirConditioningDisabledIcon = {
    name: 'AirConditioningDisabledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-air-conditioning-disabled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 8m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v4a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 16v-3a1 1 0 0 1 1 -1h8a1 1 0 0 1 1 1v3"
      }, null), createTextVNode(" ")]);
    }
  };

  var AirConditioningIcon = {
    name: 'AirConditioningIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-air-conditioning",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 16a3 3 0 0 1 -3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 16a3 3 0 0 0 3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v4a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 13v-3a1 1 0 0 1 1 -1h8a1 1 0 0 1 1 1v3"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlarmFilledIcon = {
    name: 'AlarmFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alarm-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 6.072a8 8 0 1 1 -11.995 7.213l-.005 -.285l.005 -.285a8 8 0 0 1 11.995 -6.643zm-4 2.928a1 1 0 0 0 -1 1v3l.007 .117a1 1 0 0 0 .993 .883h2l.117 -.007a1 1 0 0 0 .883 -.993l-.007 -.117a1 1 0 0 0 -.993 -.883h-1v-2l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.412 3.191a1 1 0 0 1 1.273 1.539l-.097 .08l-2.75 2a1 1 0 0 1 -1.273 -1.54l.097 -.08l2.75 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.191 3.412a1 1 0 0 1 1.291 -.288l.106 .067l2.75 2a1 1 0 0 1 -1.07 1.685l-.106 -.067l-2.75 -2a1 1 0 0 1 -.22 -1.397z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlarmMinusFilledIcon = {
    name: 'AlarmMinusFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alarm-minus-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 6.072a8 8 0 1 1 -11.995 7.213l-.005 -.285l.005 -.285a8 8 0 0 1 11.995 -6.643zm-2 5.928h-4l-.117 .007a1 1 0 0 0 .117 1.993h4l.117 -.007a1 1 0 0 0 -.117 -1.993z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.412 3.191a1 1 0 0 1 1.273 1.539l-.097 .08l-2.75 2a1 1 0 0 1 -1.273 -1.54l.097 -.08l2.75 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.191 3.412a1 1 0 0 1 1.291 -.288l.106 .067l2.75 2a1 1 0 0 1 -1.07 1.685l-.106 -.067l-2.75 -2a1 1 0 0 1 -.22 -1.397z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlarmMinusIcon = {
    name: 'AlarmMinusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alarm-minus",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 13m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 4l-2.75 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 4l2.75 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 13h4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlarmOffIcon = {
    name: 'AlarmOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alarm-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7.587 7.566a7 7 0 1 0 9.833 9.864m1.35 -2.645a7 7 0 0 0 -8.536 -8.56"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12v1h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.261 5.265l-1.011 .735"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 4l2.75 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlarmPlusFilledIcon = {
    name: 'AlarmPlusFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alarm-plus-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 6.072a8 8 0 1 1 -11.995 7.213l-.005 -.285l.005 -.285a8 8 0 0 1 11.995 -6.643zm-4 3.928a1 1 0 0 0 -1 1v1h-1l-.117 .007a1 1 0 0 0 .117 1.993h1v1l.007 .117a1 1 0 0 0 1.993 -.117v-1h1l.117 -.007a1 1 0 0 0 -.117 -1.993h-1v-1l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.412 3.191a1 1 0 0 1 1.273 1.539l-.097 .08l-2.75 2a1 1 0 0 1 -1.273 -1.54l.097 -.08l2.75 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.191 3.412a1 1 0 0 1 1.291 -.288l.106 .067l2.75 2a1 1 0 0 1 -1.07 1.685l-.106 -.067l-2.75 -2a1 1 0 0 1 -.22 -1.397z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlarmPlusIcon = {
    name: 'AlarmPlusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alarm-plus",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 13m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 4l-2.75 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 4l2.75 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 13h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 11v4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlarmSnoozeFilledIcon = {
    name: 'AlarmSnoozeFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alarm-snooze-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 6.072a8 8 0 1 1 -11.995 7.213l-.005 -.285l.005 -.285a8 8 0 0 1 11.995 -6.643zm-2 3.928h-4l-.117 .007a1 1 0 0 0 -.883 .993l.007 .117a1 1 0 0 0 .993 .883h1.584l-2.291 2.293l-.076 .084c-.514 .637 -.07 1.623 .783 1.623h4l.117 -.007a1 1 0 0 0 .883 -.993l-.007 -.117a1 1 0 0 0 -.993 -.883h-1.586l2.293 -2.293l.076 -.084c.514 -.637 .07 -1.623 -.783 -1.623z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.412 3.191a1 1 0 0 1 1.273 1.539l-.097 .08l-2.75 2a1 1 0 0 1 -1.273 -1.54l.097 -.08l2.75 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.191 3.412a1 1 0 0 1 1.291 -.288l.106 .067l2.75 2a1 1 0 0 1 -1.07 1.685l-.106 -.067l-2.75 -2a1 1 0 0 1 -.22 -1.397z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlarmSnoozeIcon = {
    name: 'AlarmSnoozeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alarm-snooze",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 13m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 11h4l-4 4h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 4l-2.75 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 4l2.75 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlarmIcon = {
    name: 'AlarmIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alarm",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 13m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 10l0 3l2 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 4l-2.75 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 4l2.75 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlbumOffIcon = {
    name: 'AlbumOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-album-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4h10a2 2 0 0 1 2 2v10m-.581 3.41c-.362 .364 -.864 .59 -1.419 .59h-12a2 2 0 0 1 -2 -2v-12c0 -.552 .224 -1.052 .585 -1.413"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v4m1.503 1.497l.497 -.497l2 2v-7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlbumIcon = {
    name: 'AlbumIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-album",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v7l2 -2l2 2v-7"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlertCircleFilledIcon = {
    name: 'AlertCircleFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alert-circle-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 2c5.523 0 10 4.477 10 10a10 10 0 0 1 -19.995 .324l-.005 -.324l.004 -.28c.148 -5.393 4.566 -9.72 9.996 -9.72zm.01 13l-.127 .007a1 1 0 0 0 0 1.986l.117 .007l.127 -.007a1 1 0 0 0 0 -1.986l-.117 -.007zm-.01 -8a1 1 0 0 0 -.993 .883l-.007 .117v4l.007 .117a1 1 0 0 0 1.986 0l.007 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlertCircleIcon = {
    name: 'AlertCircleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alert-circle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 12a9 9 0 1 0 18 0a9 9 0 0 0 -18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16h.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlertHexagonFilledIcon = {
    name: 'AlertHexagonFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alert-hexagon-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.425 1.414a3.33 3.33 0 0 1 3.026 -.097l.19 .097l6.775 3.995l.096 .063l.092 .077l.107 .075a3.224 3.224 0 0 1 1.266 2.188l.018 .202l.005 .204v7.284c0 1.106 -.57 2.129 -1.454 2.693l-.17 .1l-6.803 4.302c-.918 .504 -2.019 .535 -3.004 .068l-.196 -.1l-6.695 -4.237a3.225 3.225 0 0 1 -1.671 -2.619l-.007 -.207v-7.285c0 -1.106 .57 -2.128 1.476 -2.705l6.95 -4.098zm1.585 13.586l-.127 .007a1 1 0 0 0 0 1.986l.117 .007l.127 -.007a1 1 0 0 0 0 -1.986l-.117 -.007zm-.01 -8a1 1 0 0 0 -.993 .883l-.007 .117v4l.007 .117a1 1 0 0 0 1.986 0l.007 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlertHexagonIcon = {
    name: 'AlertHexagonIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alert-hexagon",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.875 6.27c.7 .398 1.13 1.143 1.125 1.948v7.284c0 .809 -.443 1.555 -1.158 1.948l-6.75 4.27a2.269 2.269 0 0 1 -2.184 0l-6.75 -4.27a2.225 2.225 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l6.75 -3.98a2.33 2.33 0 0 1 2.25 0l6.75 3.98h-.033z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16h.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlertOctagonFilledIcon = {
    name: 'AlertOctagonFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alert-octagon-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.897 1a4 4 0 0 1 2.664 1.016l.165 .156l4.1 4.1a4 4 0 0 1 1.168 2.605l.006 .227v5.794a4 4 0 0 1 -1.016 2.664l-.156 .165l-4.1 4.1a4 4 0 0 1 -2.603 1.168l-.227 .006h-5.795a3.999 3.999 0 0 1 -2.664 -1.017l-.165 -.156l-4.1 -4.1a4 4 0 0 1 -1.168 -2.604l-.006 -.227v-5.794a4 4 0 0 1 1.016 -2.664l.156 -.165l4.1 -4.1a4 4 0 0 1 2.605 -1.168l.227 -.006h5.793zm-2.887 14l-.127 .007a1 1 0 0 0 0 1.986l.117 .007l.127 -.007a1 1 0 0 0 0 -1.986l-.117 -.007zm-.01 -8a1 1 0 0 0 -.993 .883l-.007 .117v4l.007 .117a1 1 0 0 0 1.986 0l.007 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlertOctagonIcon = {
    name: 'AlertOctagonIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alert-octagon",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.103 2h5.794a3 3 0 0 1 2.122 .879l4.101 4.1a3 3 0 0 1 .88 2.125v5.794a3 3 0 0 1 -.879 2.122l-4.1 4.101a3 3 0 0 1 -2.123 .88h-5.795a3 3 0 0 1 -2.122 -.88l-4.101 -4.1a3 3 0 0 1 -.88 -2.124v-5.794a3 3 0 0 1 .879 -2.122l4.1 -4.101a3 3 0 0 1 2.125 -.88z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16h.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlertSmallIcon = {
    name: 'AlertSmallIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alert-small",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16h.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlertSquareFilledIcon = {
    name: 'AlertSquareFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alert-square-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 2a3 3 0 0 1 2.995 2.824l.005 .176v14a3 3 0 0 1 -2.824 2.995l-.176 .005h-14a3 3 0 0 1 -2.995 -2.824l-.005 -.176v-14a3 3 0 0 1 2.824 -2.995l.176 -.005h14zm-6.99 13l-.127 .007a1 1 0 0 0 0 1.986l.117 .007l.127 -.007a1 1 0 0 0 0 -1.986l-.117 -.007zm-.01 -8a1 1 0 0 0 -.993 .883l-.007 .117v4l.007 .117a1 1 0 0 0 1.986 0l.007 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlertSquareRoundedFilledIcon = {
    name: 'AlertSquareRoundedFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alert-square-rounded-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 2l.642 .005l.616 .017l.299 .013l.579 .034l.553 .046c4.687 .455 6.65 2.333 7.166 6.906l.03 .29l.046 .553l.041 .727l.006 .15l.017 .617l.005 .642l-.005 .642l-.017 .616l-.013 .299l-.034 .579l-.046 .553c-.455 4.687 -2.333 6.65 -6.906 7.166l-.29 .03l-.553 .046l-.727 .041l-.15 .006l-.617 .017l-.642 .005l-.642 -.005l-.616 -.017l-.299 -.013l-.579 -.034l-.553 -.046c-4.687 -.455 -6.65 -2.333 -7.166 -6.906l-.03 -.29l-.046 -.553l-.041 -.727l-.006 -.15l-.017 -.617l-.004 -.318v-.648l.004 -.318l.017 -.616l.013 -.299l.034 -.579l.046 -.553c.455 -4.687 2.333 -6.65 6.906 -7.166l.29 -.03l.553 -.046l.727 -.041l.15 -.006l.617 -.017c.21 -.003 .424 -.005 .642 -.005zm.01 13l-.127 .007a1 1 0 0 0 0 1.986l.117 .007l.127 -.007a1 1 0 0 0 0 -1.986l-.117 -.007zm-.01 -8a1 1 0 0 0 -.993 .883l-.007 .117v4l.007 .117a1 1 0 0 0 1.986 0l.007 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlertSquareRoundedIcon = {
    name: 'AlertSquareRoundedIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alert-square-rounded",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3c7.2 0 9 1.8 9 9s-1.8 9 -9 9s-9 -1.8 -9 -9s1.8 -9 9 -9z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16h.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlertSquareIcon = {
    name: 'AlertSquareIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alert-square",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16h.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlertTriangleFilledIcon = {
    name: 'AlertTriangleFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alert-triangle-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.94 2a2.99 2.99 0 0 1 2.45 1.279l.108 .164l8.431 14.074a2.989 2.989 0 0 1 -2.366 4.474l-.2 .009h-16.856a2.99 2.99 0 0 1 -2.648 -4.308l.101 -.189l8.425 -14.065a2.989 2.989 0 0 1 2.555 -1.438zm.07 14l-.127 .007a1 1 0 0 0 0 1.986l.117 .007l.127 -.007a1 1 0 0 0 0 -1.986l-.117 -.007zm-.01 -8a1 1 0 0 0 -.993 .883l-.007 .117v4l.007 .117a1 1 0 0 0 1.986 0l.007 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlertTriangleIcon = {
    name: 'AlertTriangleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alert-triangle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.24 3.957l-8.422 14.06a1.989 1.989 0 0 0 1.7 2.983h16.845a1.989 1.989 0 0 0 1.7 -2.983l-8.423 -14.06a1.989 1.989 0 0 0 -3.4 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 9v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 17h.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlienFilledIcon = {
    name: 'AlienFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alien-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.004 2c4.942 0 8.288 2.503 8.85 6.444a12.884 12.884 0 0 1 -2.163 9.308a11.794 11.794 0 0 1 -3.51 3.356c-1.982 1.19 -4.376 1.19 -6.373 -.008a11.763 11.763 0 0 1 -3.489 -3.34a12.808 12.808 0 0 1 -2.171 -9.306c.564 -3.95 3.91 -6.454 8.856 -6.454zm1.913 14.6a1 1 0 0 0 -1.317 -.517l-.146 .055a1.5 1.5 0 0 1 -1.054 -.055l-.11 -.04a1 1 0 0 0 -.69 1.874a3.5 3.5 0 0 0 2.8 0a1 1 0 0 0 .517 -1.317zm-5.304 -6.39a1 1 0 0 0 -1.32 1.497l2 2l.094 .083a1 1 0 0 0 1.32 -1.497l-2 -2zm8.094 .083a1 1 0 0 0 -1.414 0l-2 2l-.083 .094a1 1 0 0 0 1.497 1.32l2 -2l.083 -.094a1 1 0 0 0 -.083 -1.32z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlienIcon = {
    name: 'AlienIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alien",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 17a2.5 2.5 0 0 0 2 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3c-4.664 0 -7.396 2.331 -7.862 5.595a11.816 11.816 0 0 0 2 8.592a10.777 10.777 0 0 0 3.199 3.064c1.666 1 3.664 1 5.33 0a10.777 10.777 0 0 0 3.199 -3.064a11.89 11.89 0 0 0 2 -8.592c-.466 -3.265 -3.198 -5.595 -7.862 -5.595z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 11l2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 11l-2 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxBottomCenterFilledIcon = {
    name: 'AlignBoxBottomCenterFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-bottom-center-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.333 2c1.96 0 3.56 1.537 3.662 3.472l.005 .195v12.666c0 1.96 -1.537 3.56 -3.472 3.662l-.195 .005h-12.666a3.667 3.667 0 0 1 -3.662 -3.472l-.005 -.195v-12.666c0 -1.96 1.537 -3.56 3.472 -3.662l.195 -.005h12.666zm-9.333 13a1 1 0 0 0 -1 1v2l.007 .117a1 1 0 0 0 1.993 -.117v-2l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 -4a1 1 0 0 0 -1 1v6l.007 .117a1 1 0 0 0 1.993 -.117v-6l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 2a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxBottomCenterIcon = {
    name: 'AlignBoxBottomCenterIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-bottom-center",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 15v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 11v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 13v4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxBottomLeftFilledIcon = {
    name: 'AlignBoxBottomLeftFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-bottom-left-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.333 2c1.96 0 3.56 1.537 3.662 3.472l.005 .195v12.666c0 1.96 -1.537 3.56 -3.472 3.662l-.195 .005h-12.666a3.667 3.667 0 0 1 -3.662 -3.472l-.005 -.195v-12.666c0 -1.96 1.537 -3.56 3.472 -3.662l.195 -.005h12.666zm-12.333 13a1 1 0 0 0 -1 1v2l.007 .117a1 1 0 0 0 1.993 -.117v-2l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 -4a1 1 0 0 0 -1 1v6l.007 .117a1 1 0 0 0 1.993 -.117v-6l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 2a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxBottomLeftIcon = {
    name: 'AlignBoxBottomLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-bottom-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 15v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 11v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 13v4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxBottomRightFilledIcon = {
    name: 'AlignBoxBottomRightFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-bottom-right-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.333 2c1.96 0 3.56 1.537 3.662 3.472l.005 .195v12.666c0 1.96 -1.537 3.56 -3.472 3.662l-.195 .005h-12.666a3.667 3.667 0 0 1 -3.662 -3.472l-.005 -.195v-12.666c0 -1.96 1.537 -3.56 3.472 -3.662l.195 -.005h12.666zm-6.333 13a1 1 0 0 0 -1 1v2l.007 .117a1 1 0 0 0 1.993 -.117v-2l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 -4a1 1 0 0 0 -1 1v6l.007 .117a1 1 0 0 0 1.993 -.117v-6l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 2a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxBottomRightIcon = {
    name: 'AlignBoxBottomRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-bottom-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 15v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 11v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 13v4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxCenterMiddleFilledIcon = {
    name: 'AlignBoxCenterMiddleFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-center-middle-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 2a3 3 0 0 1 2.995 2.824l.005 .176v14a3 3 0 0 1 -2.824 2.995l-.176 .005h-14a3 3 0 0 1 -2.993 -2.802l-.007 -.198v-14a3 3 0 0 1 2.824 -2.995l.176 -.005h14zm-6 12h-2l-.117 .007a1 1 0 0 0 0 1.986l.117 .007h2l.117 -.007a1 1 0 0 0 0 -1.986l-.117 -.007zm2 -3h-6l-.117 .007a1 1 0 0 0 0 1.986l.117 .007h6l.117 -.007a1 1 0 0 0 0 -1.986l-.117 -.007zm-1 -3h-4l-.117 .007a1 1 0 0 0 0 1.986l.117 .007h4l.117 -.007a1 1 0 0 0 0 -1.986l-.117 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxCenterMiddleIcon = {
    name: 'AlignBoxCenterMiddleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-center-middle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 19v-14a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 15h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 12h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 9h4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxLeftBottomFilledIcon = {
    name: 'AlignBoxLeftBottomFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-left-bottom-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.333 2c1.96 0 3.56 1.537 3.662 3.472l.005 .195v12.666c0 1.96 -1.537 3.56 -3.472 3.662l-.195 .005h-12.666a3.667 3.667 0 0 1 -3.662 -3.472l-.005 -.195v-12.666c0 -1.96 1.537 -3.56 3.472 -3.662l.195 -.005h12.666zm-10.333 15h-2l-.117 .007a1 1 0 0 0 .117 1.993h2l.117 -.007a1 1 0 0 0 -.117 -1.993zm4 -3h-6l-.117 .007a1 1 0 0 0 .117 1.993h6l.117 -.007a1 1 0 0 0 -.117 -1.993zm-2 -3h-4l-.117 .007a1 1 0 0 0 .117 1.993h4l.117 -.007a1 1 0 0 0 -.117 -1.993z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxLeftBottomIcon = {
    name: 'AlignBoxLeftBottomIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-left-bottom",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17h-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 14h-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 11h-4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxLeftMiddleFilledIcon = {
    name: 'AlignBoxLeftMiddleFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-left-middle-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.333 2c1.96 0 3.56 1.537 3.662 3.472l.005 .195v12.666c0 1.96 -1.537 3.56 -3.472 3.662l-.195 .005h-12.666a3.667 3.667 0 0 1 -3.662 -3.472l-.005 -.195v-12.666c0 -1.96 1.537 -3.56 3.472 -3.662l.195 -.005h12.666zm-10.333 12h-2l-.117 .007a1 1 0 0 0 .117 1.993h2l.117 -.007a1 1 0 0 0 -.117 -1.993zm4 -3h-6l-.117 .007a1 1 0 0 0 .117 1.993h6l.117 -.007a1 1 0 0 0 -.117 -1.993zm-2 -3h-4l-.117 .007a1 1 0 0 0 .117 1.993h4l.117 -.007a1 1 0 0 0 -.117 -1.993z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxLeftMiddleIcon = {
    name: 'AlignBoxLeftMiddleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-left-middle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 15h-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 12h-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 9h-4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxLeftTopFilledIcon = {
    name: 'AlignBoxLeftTopFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-left-top-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.333 2c1.96 0 3.56 1.537 3.662 3.472l.005 .195v12.666c0 1.96 -1.537 3.56 -3.472 3.662l-.195 .005h-12.666a3.667 3.667 0 0 1 -3.662 -3.472l-.005 -.195v-12.666c0 -1.96 1.537 -3.56 3.472 -3.662l.195 -.005h12.666zm-10.333 9h-2l-.117 .007a1 1 0 0 0 .117 1.993h2l.117 -.007a1 1 0 0 0 -.117 -1.993zm4 -3h-6l-.117 .007a1 1 0 0 0 .117 1.993h6l.117 -.007a1 1 0 0 0 -.117 -1.993zm-2 -3h-4l-.117 .007a1 1 0 0 0 .117 1.993h4l.117 -.007a1 1 0 0 0 -.117 -1.993z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxLeftTopIcon = {
    name: 'AlignBoxLeftTopIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-left-top",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 13h-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 10h-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 7h-4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxRightBottomFilledIcon = {
    name: 'AlignBoxRightBottomFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-right-bottom-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.333 2c1.96 0 3.56 1.537 3.662 3.472l.005 .195v12.666c0 1.96 -1.537 3.56 -3.472 3.662l-.195 .005h-12.666a3.667 3.667 0 0 1 -3.662 -3.472l-.005 -.195v-12.666c0 -1.96 1.537 -3.56 3.472 -3.662l.195 -.005h12.666zm-.333 15h-2l-.117 .007a1 1 0 0 0 .117 1.993h2l.117 -.007a1 1 0 0 0 -.117 -1.993zm0 -3h-6l-.117 .007a1 1 0 0 0 .117 1.993h6l.117 -.007a1 1 0 0 0 -.117 -1.993zm0 -3h-4l-.117 .007a1 1 0 0 0 .117 1.993h4l.117 -.007a1 1 0 0 0 -.117 -1.993z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxRightBottomIcon = {
    name: 'AlignBoxRightBottomIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-right-bottom",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 17h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 14h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 11h4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxRightMiddleFilledIcon = {
    name: 'AlignBoxRightMiddleFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-right-middle-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.333 2c1.96 0 3.56 1.537 3.662 3.472l.005 .195v12.666c0 1.96 -1.537 3.56 -3.472 3.662l-.195 .005h-12.666a3.667 3.667 0 0 1 -3.662 -3.472l-.005 -.195v-12.666c0 -1.96 1.537 -3.56 3.472 -3.662l.195 -.005h12.666zm-.333 12h-2l-.117 .007a1 1 0 0 0 0 1.986l.117 .007h2l.117 -.007a1 1 0 0 0 0 -1.986l-.117 -.007zm0 -3h-6l-.117 .007a1 1 0 0 0 0 1.986l.117 .007h6l.117 -.007a1 1 0 0 0 0 -1.986l-.117 -.007zm0 -3h-4l-.117 .007a1 1 0 0 0 0 1.986l.117 .007h4l.117 -.007a1 1 0 0 0 0 -1.986l-.117 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxRightMiddleIcon = {
    name: 'AlignBoxRightMiddleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-right-middle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 15h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-14z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 12h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 9h4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxRightTopFilledIcon = {
    name: 'AlignBoxRightTopFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-right-top-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.333 2c1.96 0 3.56 1.537 3.662 3.472l.005 .195v12.666c0 1.96 -1.537 3.56 -3.472 3.662l-.195 .005h-12.666a3.667 3.667 0 0 1 -3.662 -3.472l-.005 -.195v-12.666c0 -1.96 1.537 -3.56 3.472 -3.662l.195 -.005h12.666zm-.333 9h-2l-.117 .007a1 1 0 0 0 .117 1.993h2l.117 -.007a1 1 0 0 0 -.117 -1.993zm0 -3h-6l-.117 .007a1 1 0 0 0 .117 1.993h6l.117 -.007a1 1 0 0 0 -.117 -1.993zm0 -3h-4l-.117 .007a1 1 0 0 0 .117 1.993h4l.117 -.007a1 1 0 0 0 -.117 -1.993z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxRightTopIcon = {
    name: 'AlignBoxRightTopIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-right-top",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 13h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 10h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 7h4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxTopCenterFilledIcon = {
    name: 'AlignBoxTopCenterFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-top-center-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.333 2c1.96 0 3.56 1.537 3.662 3.472l.005 .195v12.666c0 1.96 -1.537 3.56 -3.472 3.662l-.195 .005h-12.666a3.667 3.667 0 0 1 -3.662 -3.472l-.005 -.195v-12.666c0 -1.96 1.537 -3.56 3.472 -3.662l.195 -.005h12.666zm-6.333 3a1 1 0 0 0 -1 1v6l.007 .117a1 1 0 0 0 1.993 -.117v-6l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 0a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883zm-6 0a1 1 0 0 0 -1 1v2l.007 .117a1 1 0 0 0 1.993 -.117v-2l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxTopCenterIcon = {
    name: 'AlignBoxTopCenterIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-top-center",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 9v-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 13v-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 11v-4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxTopLeftFilledIcon = {
    name: 'AlignBoxTopLeftFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-top-left-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.333 2c1.96 0 3.56 1.537 3.662 3.472l.005 .195v12.666c0 1.96 -1.537 3.56 -3.472 3.662l-.195 .005h-12.666a3.667 3.667 0 0 1 -3.662 -3.472l-.005 -.195v-12.666c0 -1.96 1.537 -3.56 3.472 -3.662l.195 -.005h12.666zm-9.333 3a1 1 0 0 0 -1 1v6l.007 .117a1 1 0 0 0 1.993 -.117v-6l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 0a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883zm-6 0a1 1 0 0 0 -1 1v2l.007 .117a1 1 0 0 0 1.993 -.117v-2l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxTopLeftIcon = {
    name: 'AlignBoxTopLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-top-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 9v-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 13v-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 11v-4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxTopRightFilledIcon = {
    name: 'AlignBoxTopRightFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-top-right-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.333 2c1.96 0 3.56 1.537 3.662 3.472l.005 .195v12.666c0 1.96 -1.537 3.56 -3.472 3.662l-.195 .005h-12.666a3.667 3.667 0 0 1 -3.662 -3.472l-.005 -.195v-12.666c0 -1.96 1.537 -3.56 3.472 -3.662l.195 -.005h12.666zm-3.333 3a1 1 0 0 0 -1 1v6l.007 .117a1 1 0 0 0 1.993 -.117v-6l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 0a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883zm-6 0a1 1 0 0 0 -1 1v2l.007 .117a1 1 0 0 0 1.993 -.117v-2l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignBoxTopRightIcon = {
    name: 'AlignBoxTopRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-box-top-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v14a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 9v-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 13v-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 11v-4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignCenterIcon = {
    name: 'AlignCenterIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-center",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 6l16 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12l8 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 18l12 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignJustifiedIcon = {
    name: 'AlignJustifiedIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-justified",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 6l16 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l16 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 18l12 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignLeftIcon = {
    name: 'AlignLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 6l16 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l10 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 18l14 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlignRightIcon = {
    name: 'AlignRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-align-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 6l16 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 12l10 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 18l14 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlphaIcon = {
    name: 'AlphaIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alpha",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.1 6c-1.1 2.913 -1.9 4.913 -2.4 6c-1.879 4.088 -3.713 6 -6 6c-2.4 0 -4.8 -2.4 -4.8 -6s2.4 -6 4.8 -6c2.267 0 4.135 1.986 6 6c.512 1.102 1.312 3.102 2.4 6"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlphabetCyrillicIcon = {
    name: 'AlphabetCyrillicIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alphabet-cyrillic",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 10h2a2 2 0 0 1 2 2v5h-3a2 2 0 1 1 0 -4h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 7h-3a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h1a2 2 0 0 0 2 -2v-3a2 2 0 0 0 -2 -2h-3"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlphabetGreekIcon = {
    name: 'AlphabetGreekIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alphabet-greek",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 10v7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 10m0 2a2 2 0 0 1 2 -2h1a2 2 0 0 1 2 2v3a2 2 0 0 1 -2 2h-1a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 20v-11a2 2 0 0 1 2 -2h1a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var AlphabetLatinIcon = {
    name: 'AlphabetLatinIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-alphabet-latin",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 10h2a2 2 0 0 1 2 2v5h-3a2 2 0 1 1 0 -4h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 7v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 10m0 2a2 2 0 0 1 2 -2h1a2 2 0 0 1 2 2v3a2 2 0 0 1 -2 2h-1a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode(" ")]);
    }
  };

  var AmbulanceIcon = {
    name: 'AmbulanceIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ambulance",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 17h-2v-11a1 1 0 0 1 1 -1h9v12m-4 0h6m4 0h2v-6h-8m0 -5h5l3 5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 10h4m-2 -2v4"
      }, null), createTextVNode(" ")]);
    }
  };

  var AmpersandIcon = {
    name: 'AmpersandIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ampersand",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 20l-10.403 -10.972a2.948 2.948 0 0 1 0 -4.165a2.94 2.94 0 0 1 4.161 0a2.948 2.948 0 0 1 0 4.165l-4.68 4.687a3.685 3.685 0 0 0 0 5.207a3.675 3.675 0 0 0 5.2 0l5.722 -5.922"
      }, null), createTextVNode(" ")]);
    }
  };

  var AnalyzeFilledIcon = {
    name: 'AnalyzeFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-analyze-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4.99 12.862a7.1 7.1 0 0 0 12.171 3.924a1.956 1.956 0 0 1 -.156 -.637l-.005 -.149l.005 -.15a2 2 0 1 1 1.769 2.137a9.099 9.099 0 0 1 -15.764 -4.85a1 1 0 0 1 1.98 -.275z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8a4 4 0 1 1 -3.995 4.2l-.005 -.2l.005 -.2a4 4 0 0 1 3.995 -3.8z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.142 3.09a9.1 9.1 0 0 1 7.848 7.772a1 1 0 0 1 -1.98 .276a7.1 7.1 0 0 0 -6.125 -6.064a7.096 7.096 0 0 0 -6.048 2.136a2 2 0 1 1 -3.831 .939l-.006 -.149l.005 -.15a2 2 0 0 1 2.216 -1.838a9.094 9.094 0 0 1 7.921 -2.922z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AnalyzeOffIcon = {
    name: 'AnalyzeOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-analyze-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 11a8.1 8.1 0 0 0 -6.986 -6.918a8.086 8.086 0 0 0 -4.31 .62m-2.383 1.608a8.089 8.089 0 0 0 -1.326 1.69"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 13a8.1 8.1 0 0 0 13.687 4.676"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16a1 1 0 0 0 -1 -1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.888 9.87a3 3 0 1 0 4.233 4.252m.595 -3.397a3.012 3.012 0 0 0 -1.426 -1.435"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AnalyzeIcon = {
    name: 'AnalyzeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-analyze",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 11a8.1 8.1 0 0 0 -6.986 -6.918a8.095 8.095 0 0 0 -8.019 3.918"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 13a8.1 8.1 0 0 0 15 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var AnchorOffIcon = {
    name: 'AnchorOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-anchor-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12v9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 13a8 8 0 0 0 14.138 5.13m1.44 -2.56a7.99 7.99 0 0 0 .422 -2.57"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 13h-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 13h-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.866 8.873a3 3 0 1 0 -3.737 -3.747"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AnchorIcon = {
    name: 'AnchorIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-anchor",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 9v12m-8 -8a8 8 0 0 0 16 0m1 0h-2m-14 0h-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 6m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var AngleIcon = {
    name: 'AngleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-angle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 19h-18l9 -15"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.615 15.171h.015"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.515 11.771h.015"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.715 8.671h.015"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.415 5.971h.015"
      }, null), createTextVNode(" ")]);
    }
  };

  var AnkhIcon = {
    name: 'AnkhIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ankh",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 13h12"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 21v-8l-.422 -.211a6.472 6.472 0 0 1 -3.578 -5.789a4 4 0 1 1 8 0a6.472 6.472 0 0 1 -3.578 5.789l-.422 .211"
      }, null), createTextVNode(" ")]);
    }
  };

  var AntennaBars1Icon = {
    name: 'AntennaBars1Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-antenna-bars-1",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 18l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 18l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 18l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 18l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AntennaBars2Icon = {
    name: 'AntennaBars2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-antenna-bars-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 18l0 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 18l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 18l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 18l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AntennaBars3Icon = {
    name: 'AntennaBars3Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-antenna-bars-3",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 18l0 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 18l0 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 18l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 18l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AntennaBars4Icon = {
    name: 'AntennaBars4Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-antenna-bars-4",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 18l0 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 18l0 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 18l0 -9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 18l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AntennaBars5Icon = {
    name: 'AntennaBars5Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-antenna-bars-5",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 18l0 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 18l0 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 18l0 -9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 18l0 -12"
      }, null), createTextVNode(" ")]);
    }
  };

  var AntennaBarsOffIcon = {
    name: 'AntennaBarsOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-antenna-bars-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 18v-3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 18v-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 18v-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 10v-1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 14v-8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AntennaOffIcon = {
    name: 'AntennaOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-antenna-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4.5v7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 5v3m0 4v9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 8v2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 6v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8h-8m-4 0h-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AntennaIcon = {
    name: 'AntennaIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-antenna",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4.5v7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 5v16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 5.5v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 6v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8h-16"
      }, null), createTextVNode(" ")]);
    }
  };

  var ApertureOffIcon = {
    name: 'ApertureOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-aperture-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3.6 15h10.55"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.641 5.631a9 9 0 1 0 12.719 12.738m1.68 -2.318a9 9 0 0 0 -12.074 -12.098"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7.395 7.534l2.416 7.438"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.032 4.636l-4.852 3.526m-2.334 1.695l-1.349 .98"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.559 14.51l-8.535 -6.201"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.257 20.916l2.123 -6.533m.984 -3.028l.154 -.473"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var ApertureIcon = {
    name: 'ApertureIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-aperture",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3.6 15h10.55"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.551 4.938l3.26 10.034"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.032 4.636l-8.535 6.201"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.559 14.51l-8.535 -6.201"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.257 20.916l3.261 -10.034"
      }, null), createTextVNode(" ")]);
    }
  };

  var ApiAppOffIcon = {
    name: 'ApiAppOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-api-app-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 15h-6.5a2.5 2.5 0 1 1 0 -5h.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 15v3.5a2.5 2.5 0 1 1 -5 0v-.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 9h5.5a2.5 2.5 0 1 1 0 5h-.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 12v-3m.042 -3.957a2.5 2.5 0 0 1 4.958 .457v.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var ApiAppIcon = {
    name: 'ApiAppIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-api-app",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 15h-6.5a2.5 2.5 0 1 1 0 -5h.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 12v6.5a2.5 2.5 0 1 1 -5 0v-.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 9h6.5a2.5 2.5 0 1 1 0 5h-.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 12v-6.5a2.5 2.5 0 0 1 5 0v.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var ApiOffIcon = {
    name: 'ApiOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-api-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 13h5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16v-4m0 -4h3a2 2 0 0 1 2 2v1c0 .554 -.225 1.055 -.589 1.417m-3.411 .583h-1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 16v-5.5a2.5 2.5 0 0 0 -5 0v5.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var ApiIcon = {
    name: 'ApiIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-api",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 13h5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16v-8h3a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2h-3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 16v-5.5a2.5 2.5 0 0 0 -5 0v5.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var AppWindowFilledIcon = {
    name: 'AppWindowFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-app-window-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 4a3 3 0 0 1 3 3v10a3 3 0 0 1 -3 3h-14a3 3 0 0 1 -3 -3v-10a3 3 0 0 1 3 -3zm-12.99 3l-.127 .007a1 1 0 0 0 .117 1.993l.127 -.007a1 1 0 0 0 -.117 -1.993zm3 0l-.127 .007a1 1 0 0 0 .117 1.993l.127 -.007a1 1 0 0 0 -.117 -1.993z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AppWindowIcon = {
    name: 'AppWindowIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-app-window",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 8h.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 8h.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var AppleIcon = {
    name: 'AppleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-apple",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 14m-7 0a7 7 0 1 0 14 0a7 7 0 1 0 -14 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 11v-6a2 2 0 0 1 2 -2h2v1a2 2 0 0 1 -2 2h-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 10.5c1.333 .667 2.667 .667 4 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var AppsFilledIcon = {
    name: 'AppsFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-apps-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 3h-4a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 13h-4a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 13h-4a2 2 0 0 0 -2 2v4a2 2 0 0 0 2 2h4a2 2 0 0 0 2 -2v-4a2 2 0 0 0 -2 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 3a1 1 0 0 1 .993 .883l.007 .117v2h2a1 1 0 0 1 .117 1.993l-.117 .007h-2v2a1 1 0 0 1 -1.993 .117l-.007 -.117v-2h-2a1 1 0 0 1 -.117 -1.993l.117 -.007h2v-2a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AppsOffIcon = {
    name: 'AppsOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-apps-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4h1a1 1 0 0 1 1 1v1m-.29 3.704a1 1 0 0 1 -.71 .296h-4a1 1 0 0 1 -1 -1v-4c0 -.276 .111 -.525 .292 -.706"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 14h1a1 1 0 0 1 1 1v1m-.29 3.704a1 1 0 0 1 -.71 .296h-4a1 1 0 0 1 -1 -1v-4c0 -.276 .111 -.525 .292 -.706"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 14m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 7h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 4v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AppsIcon = {
    name: 'AppsIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-apps",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 14m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 14m0 1a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 7l6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 4l0 6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArchiveFilledIcon = {
    name: 'ArchiveFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-archive-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("rect", {
        "x": "2",
        "y": "3",
        "width": "20",
        "height": "4",
        "rx": "2",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 9c.513 0 .936 .463 .993 1.06l.007 .14v7.2c0 1.917 -1.249 3.484 -2.824 3.594l-.176 .006h-10c-1.598 0 -2.904 -1.499 -2.995 -3.388l-.005 -.212v-7.2c0 -.663 .448 -1.2 1 -1.2h14zm-5 2h-4l-.117 .007a1 1 0 0 0 0 1.986l.117 .007h4l.117 -.007a1 1 0 0 0 0 -1.986l-.117 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArchiveOffIcon = {
    name: 'ArchiveOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-archive-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4h11a2 2 0 1 1 0 4h-7m-4 0h-3a2 2 0 0 1 -.826 -3.822"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 8v10a2 2 0 0 0 2 2h10a2 2 0 0 0 1.824 -1.18m.176 -3.82v-7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 12h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArchiveIcon = {
    name: 'ArchiveIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-archive",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 4m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v0a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 8v10a2 2 0 0 0 2 2h10a2 2 0 0 0 2 -2v-10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 12l4 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var Armchair2OffIcon = {
    name: 'Armchair2OffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-armchair-2-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 10v-4a3 3 0 0 1 .128 -.869m2.038 -2.013c.264 -.078 .544 -.118 .834 -.118h8a3 3 0 0 1 3 3v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.124 12.145a3 3 0 1 1 3.756 3.724m-.88 3.131h-14v-3a3 3 0 1 1 3 -3v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 19v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 19v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var Armchair2Icon = {
    name: 'Armchair2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-armchair-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 10v-4a3 3 0 0 1 3 -3h8a3 3 0 0 1 3 3v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 15v-2a3 3 0 1 1 3 3v3h-14v-3a3 3 0 1 1 3 -3v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12h8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 19v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 19v2"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArmchairOffIcon = {
    name: 'ArmchairOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-armchair-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 13a2 2 0 1 1 4 0v4m-2 2h-14a2 2 0 0 1 -2 -2v-4a2 2 0 1 1 4 0v2h8.036"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 11v-5a3 3 0 0 1 .134 -.89m1.987 -1.98a3 3 0 0 1 .879 -.13h8a3 3 0 0 1 3 3v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 19v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 19v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArmchairIcon = {
    name: 'ArmchairIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-armchair",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 11a2 2 0 0 1 2 2v2h10v-2a2 2 0 1 1 4 0v4a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2v-4a2 2 0 0 1 2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 11v-5a3 3 0 0 1 3 -3h8a3 3 0 0 1 3 3v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 19v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 19v2"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowAutofitContentFilledIcon = {
    name: 'ArrowAutofitContentFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-autofit-content-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.707 3.293a1 1 0 0 1 .083 1.32l-.083 .094l-1.292 1.293h4.585a1 1 0 0 1 .117 1.993l-.117 .007h-4.585l1.292 1.293a1 1 0 0 1 .083 1.32l-.083 .094a1 1 0 0 1 -1.32 .083l-.094 -.083l-3 -3a1.008 1.008 0 0 1 -.097 -.112l-.071 -.11l-.054 -.114l-.035 -.105l-.025 -.118l-.007 -.058l-.004 -.09l.003 -.075l.017 -.126l.03 -.111l.044 -.111l.052 -.098l.064 -.092l.083 -.094l3 -3a1 1 0 0 1 1.414 0z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.613 3.21l.094 .083l3 3a.927 .927 0 0 1 .097 .112l.071 .11l.054 .114l.035 .105l.03 .148l.006 .118l-.003 .075l-.017 .126l-.03 .111l-.044 .111l-.052 .098l-.074 .104l-.073 .082l-3 3a1 1 0 0 1 -1.497 -1.32l.083 -.094l1.292 -1.293h-4.585a1 1 0 0 1 -.117 -1.993l.117 -.007h4.585l-1.292 -1.293a1 1 0 0 1 -.083 -1.32l.083 -.094a1 1 0 0 1 1.32 -.083z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 13h-12a3 3 0 0 0 -3 3v2a3 3 0 0 0 3 3h12a3 3 0 0 0 3 -3v-2a3 3 0 0 0 -3 -3z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowAutofitContentIcon = {
    name: 'ArrowAutofitContentIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-autofit-content",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4l-3 3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4l3 3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 14m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v2a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 7h-7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 7h-7"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowAutofitDownIcon = {
    name: 'ArrowAutofitDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-autofit-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4v17"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 18l3 3l3 -3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowAutofitHeightIcon = {
    name: 'ArrowAutofitHeightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-autofit-height",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 14v7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 3v7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 18l3 3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 6l3 -3l3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowAutofitLeftIcon = {
    name: 'ArrowAutofitLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-autofit-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 18h-17"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 15l-3 3l3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowAutofitRightIcon = {
    name: 'ArrowAutofitRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-autofit-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 12v-6a2 2 0 0 0 -2 -2h-12a2 2 0 0 0 -2 2v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 18h17"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 15l3 3l-3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowAutofitUpIcon = {
    name: 'ArrowAutofitUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-autofit-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4h-6a2 2 0 0 0 -2 2v12a2 2 0 0 0 2 2h8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 20v-17"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 6l3 -3l3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowAutofitWidthIcon = {
    name: 'ArrowAutofitWidthIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-autofit-width",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12v-6a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 18h-7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 18h-7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 15l-3 3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 15l3 3l-3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBackUpDoubleIcon = {
    name: 'ArrowBackUpDoubleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-back-up-double",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 14l-4 -4l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 14l-4 -4l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 10h7a4 4 0 1 1 0 8h-1"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBackUpIcon = {
    name: 'ArrowBackUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-back-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 14l-4 -4l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 10h11a4 4 0 1 1 0 8h-1"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBackIcon = {
    name: 'ArrowBackIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-back",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 11l-4 4l4 4m-4 -4h11a4 4 0 0 0 0 -8h-1"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBadgeDownFilledIcon = {
    name: 'ArrowBadgeDownFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-badge-down-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.375 6.22l-4.375 3.498l-4.375 -3.5a1 1 0 0 0 -1.625 .782v6a1 1 0 0 0 .375 .78l5 4a1 1 0 0 0 1.25 0l5 -4a1 1 0 0 0 .375 -.78v-6a1 1 0 0 0 -1.625 -.78z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBadgeDownIcon = {
    name: 'ArrowBadgeDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-badge-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 13v-6l-5 4l-5 -4v6l5 4z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBadgeLeftFilledIcon = {
    name: 'ArrowBadgeLeftFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-badge-left-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 6h-6a1 1 0 0 0 -.78 .375l-4 5a1 1 0 0 0 0 1.25l4 5a1 1 0 0 0 .78 .375h6l.112 -.006a1 1 0 0 0 .669 -1.619l-3.501 -4.375l3.5 -4.375a1 1 0 0 0 -.78 -1.625z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBadgeLeftIcon = {
    name: 'ArrowBadgeLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-badge-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 17h6l-4 -5l4 -5h-6l-4 5z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBadgeRightFilledIcon = {
    name: 'ArrowBadgeRightFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-badge-right-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 6l-.112 .006a1 1 0 0 0 -.669 1.619l3.501 4.375l-3.5 4.375a1 1 0 0 0 .78 1.625h6a1 1 0 0 0 .78 -.375l4 -5a1 1 0 0 0 0 -1.25l-4 -5a1 1 0 0 0 -.78 -.375h-6z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBadgeRightIcon = {
    name: 'ArrowBadgeRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-badge-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 7h-6l4 5l-4 5h6l4 -5z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBadgeUpFilledIcon = {
    name: 'ArrowBadgeUpFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-badge-up-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.375 6.22l-5 4a1 1 0 0 0 -.375 .78v6l.006 .112a1 1 0 0 0 1.619 .669l4.375 -3.501l4.375 3.5a1 1 0 0 0 1.625 -.78v-6a1 1 0 0 0 -.375 -.78l-5 -4a1 1 0 0 0 -1.25 0z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBadgeUpIcon = {
    name: 'ArrowBadgeUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-badge-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 11v6l-5 -4l-5 4v-6l5 -4z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBarDownIcon = {
    name: 'ArrowBarDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-bar-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20l0 -10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l16 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBarLeftIcon = {
    name: 'ArrowBarLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-bar-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l10 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4l0 16"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBarRightIcon = {
    name: 'ArrowBarRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-bar-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 12l-10 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 12l-4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 12l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l0 16"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBarToDownIcon = {
    name: 'ArrowBarToDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-bar-to-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l16 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 14l0 -10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 14l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 14l-4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBarToLeftIcon = {
    name: 'ArrowBarToLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-bar-to-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 12l10 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 12l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 12l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l0 16"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBarToRightIcon = {
    name: 'ArrowBarToRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-bar-to-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 12l-10 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 12l-4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 12l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4l0 16"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBarToUpIcon = {
    name: 'ArrowBarToUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-bar-to-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 10l0 10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 10l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 10l-4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l16 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBarUpIcon = {
    name: 'ArrowBarUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-bar-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4l0 10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4l-4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l16 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBearLeft2Icon = {
    name: 'ArrowBearLeft2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-bear-left-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 3h-5v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 3l7.536 7.536a5 5 0 0 1 1.464 3.534v6.93"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 5l-4.5 4.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBearLeftIcon = {
    name: 'ArrowBearLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-bear-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 3h-5v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 3l7.536 7.536a5 5 0 0 1 1.464 3.534v6.93"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBearRight2Icon = {
    name: 'ArrowBearRight2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-bear-right-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 3h5v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 3l-7.536 7.536a5 5 0 0 0 -1.464 3.534v6.93"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 5l4.5 4.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBearRightIcon = {
    name: 'ArrowBearRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-bear-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3h5v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 3l-7.536 7.536a5 5 0 0 0 -1.464 3.534v6.93"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigDownFilledIcon = {
    name: 'ArrowBigDownFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-down-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 2l-.15 .005a2 2 0 0 0 -1.85 1.995v6.999l-2.586 .001a2 2 0 0 0 -1.414 3.414l6.586 6.586a2 2 0 0 0 2.828 0l6.586 -6.586a2 2 0 0 0 .434 -2.18l-.068 -.145a2 2 0 0 0 -1.78 -1.089l-2.586 -.001v-6.999a2 2 0 0 0 -2 -2h-4z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigDownLineFilledIcon = {
    name: 'ArrowBigDownLineFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-down-line-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 5l-.117 .007a1 1 0 0 0 -.883 .993v4.999l-2.586 .001a2 2 0 0 0 -1.414 3.414l6.586 6.586a2 2 0 0 0 2.828 0l6.586 -6.586a2 2 0 0 0 .434 -2.18l-.068 -.145a2 2 0 0 0 -1.78 -1.089l-2.586 -.001v-4.999a1 1 0 0 0 -1 -1h-6z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 2a1 1 0 0 1 .117 1.993l-.117 .007h-6a1 1 0 0 1 -.117 -1.993l.117 -.007h6z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigDownLineIcon = {
    name: 'ArrowBigDownLineIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-down-line",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 12h3.586a1 1 0 0 1 .707 1.707l-6.586 6.586a1 1 0 0 1 -1.414 0l-6.586 -6.586a1 1 0 0 1 .707 -1.707h3.586v-6h6v6z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 3h-6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigDownLinesFilledIcon = {
    name: 'ArrowBigDownLinesFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-down-lines-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 8l-.117 .007a1 1 0 0 0 -.883 .993v1.999l-2.586 .001a2 2 0 0 0 -1.414 3.414l6.586 6.586a2 2 0 0 0 2.828 0l6.586 -6.586a2 2 0 0 0 .434 -2.18l-.068 -.145a2 2 0 0 0 -1.78 -1.089l-2.586 -.001v-1.999a1 1 0 0 0 -1 -1h-6z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 2a1 1 0 0 1 .117 1.993l-.117 .007h-6a1 1 0 0 1 -.117 -1.993l.117 -.007h6z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 5a1 1 0 0 1 .117 1.993l-.117 .007h-6a1 1 0 0 1 -.117 -1.993l.117 -.007h6z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigDownLinesIcon = {
    name: 'ArrowBigDownLinesIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-down-lines",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 12h3.586a1 1 0 0 1 .707 1.707l-6.586 6.586a1 1 0 0 1 -1.414 0l-6.586 -6.586a1 1 0 0 1 .707 -1.707h3.586v-3h6v3z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 3h-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 6h-6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigDownIcon = {
    name: 'ArrowBigDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 4v8h3.586a1 1 0 0 1 .707 1.707l-6.586 6.586a1 1 0 0 1 -1.414 0l-6.586 -6.586a1 1 0 0 1 .707 -1.707h3.586v-8a1 1 0 0 1 1 -1h4a1 1 0 0 1 1 1z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigLeftFilledIcon = {
    name: 'ArrowBigLeftFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-left-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.586 4l-6.586 6.586a2 2 0 0 0 0 2.828l6.586 6.586a2 2 0 0 0 2.18 .434l.145 -.068a2 2 0 0 0 1.089 -1.78v-2.586h7a2 2 0 0 0 2 -2v-4l-.005 -.15a2 2 0 0 0 -1.995 -1.85l-7 -.001v-2.585a2 2 0 0 0 -3.414 -1.414z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigLeftLineFilledIcon = {
    name: 'ArrowBigLeftLineFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-left-line-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.586 4l-6.586 6.586a2 2 0 0 0 0 2.828l6.586 6.586a2 2 0 0 0 2.18 .434l.145 -.068a2 2 0 0 0 1.089 -1.78v-2.586h5a1 1 0 0 0 1 -1v-6l-.007 -.117a1 1 0 0 0 -.993 -.883l-5 -.001v-2.585a2 2 0 0 0 -3.414 -1.414z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4.415 12l6.585 -6.586v3.586l.007 .117a1 1 0 0 0 .993 .883l5 -.001v4l-5 .001a1 1 0 0 0 -1 1v3.586l-6.585 -6.586z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 8a1 1 0 0 1 .993 .883l.007 .117v6a1 1 0 0 1 -1.993 .117l-.007 -.117v-6a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigLeftLineIcon = {
    name: 'ArrowBigLeftLineIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-left-line",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 15v3.586a1 1 0 0 1 -1.707 .707l-6.586 -6.586a1 1 0 0 1 0 -1.414l6.586 -6.586a1 1 0 0 1 1.707 .707v3.586h6v6h-6z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 15v-6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigLeftLinesFilledIcon = {
    name: 'ArrowBigLeftLinesFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-left-lines-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.586 4l-6.586 6.586a2 2 0 0 0 0 2.828l6.586 6.586a2 2 0 0 0 2.18 .434l.145 -.068a2 2 0 0 0 1.089 -1.78v-2.586h2a1 1 0 0 0 1 -1v-6l-.007 -.117a1 1 0 0 0 -.993 -.883l-2 -.001v-2.585a2 2 0 0 0 -3.414 -1.414z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 8a1 1 0 0 1 .993 .883l.007 .117v6a1 1 0 0 1 -1.993 .117l-.007 -.117v-6a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 8a1 1 0 0 1 .993 .883l.007 .117v6a1 1 0 0 1 -1.993 .117l-.007 -.117v-6a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigLeftLinesIcon = {
    name: 'ArrowBigLeftLinesIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-left-lines",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 15v3.586a1 1 0 0 1 -1.707 .707l-6.586 -6.586a1 1 0 0 1 0 -1.414l6.586 -6.586a1 1 0 0 1 1.707 .707v3.586h3v6h-3z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 15v-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 15v-6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigLeftIcon = {
    name: 'ArrowBigLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 15h-8v3.586a1 1 0 0 1 -1.707 .707l-6.586 -6.586a1 1 0 0 1 0 -1.414l6.586 -6.586a1 1 0 0 1 1.707 .707v3.586h8a1 1 0 0 1 1 1v4a1 1 0 0 1 -1 1z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigRightFilledIcon = {
    name: 'ArrowBigRightFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-right-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.089 3.634a2 2 0 0 0 -1.089 1.78l-.001 2.586h-6.999a2 2 0 0 0 -2 2v4l.005 .15a2 2 0 0 0 1.995 1.85l6.999 -.001l.001 2.587a2 2 0 0 0 3.414 1.414l6.586 -6.586a2 2 0 0 0 0 -2.828l-6.586 -6.586a2 2 0 0 0 -2.18 -.434l-.145 .068z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigRightLineFilledIcon = {
    name: 'ArrowBigRightLineFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-right-line-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.089 3.634a2 2 0 0 0 -1.089 1.78l-.001 2.586h-4.999a1 1 0 0 0 -1 1v6l.007 .117a1 1 0 0 0 .993 .883l4.999 -.001l.001 2.587a2 2 0 0 0 3.414 1.414l6.586 -6.586a2 2 0 0 0 0 -2.828l-6.586 -6.586a2 2 0 0 0 -2.18 -.434l-.145 .068z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 8a1 1 0 0 1 .993 .883l.007 .117v6a1 1 0 0 1 -1.993 .117l-.007 -.117v-6a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigRightLineIcon = {
    name: 'ArrowBigRightLineIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-right-line",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 9v-3.586a1 1 0 0 1 1.707 -.707l6.586 6.586a1 1 0 0 1 0 1.414l-6.586 6.586a1 1 0 0 1 -1.707 -.707v-3.586h-6v-6h6z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 9v6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigRightLinesFilledIcon = {
    name: 'ArrowBigRightLinesFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-right-lines-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.089 3.634a2 2 0 0 0 -1.089 1.78l-.001 2.585l-1.999 .001a1 1 0 0 0 -1 1v6l.007 .117a1 1 0 0 0 .993 .883l1.999 -.001l.001 2.587a2 2 0 0 0 3.414 1.414l6.586 -6.586a2 2 0 0 0 0 -2.828l-6.586 -6.586a2 2 0 0 0 -2.18 -.434l-.145 .068z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 8a1 1 0 0 1 .993 .883l.007 .117v6a1 1 0 0 1 -1.993 .117l-.007 -.117v-6a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 8a1 1 0 0 1 .993 .883l.007 .117v6a1 1 0 0 1 -1.993 .117l-.007 -.117v-6a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigRightLinesIcon = {
    name: 'ArrowBigRightLinesIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-right-lines",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 9v-3.586a1 1 0 0 1 1.707 -.707l6.586 6.586a1 1 0 0 1 0 1.414l-6.586 6.586a1 1 0 0 1 -1.707 -.707v-3.586h-3v-6h3z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 9v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 9v6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigRightIcon = {
    name: 'ArrowBigRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 9h8v-3.586a1 1 0 0 1 1.707 -.707l6.586 6.586a1 1 0 0 1 0 1.414l-6.586 6.586a1 1 0 0 1 -1.707 -.707v-3.586h-8a1 1 0 0 1 -1 -1v-4a1 1 0 0 1 1 -1z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigUpFilledIcon = {
    name: 'ArrowBigUpFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-up-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.586 3l-6.586 6.586a2 2 0 0 0 -.434 2.18l.068 .145a2 2 0 0 0 1.78 1.089h2.586v7a2 2 0 0 0 2 2h4l.15 -.005a2 2 0 0 0 1.85 -1.995l-.001 -7h2.587a2 2 0 0 0 1.414 -3.414l-6.586 -6.586a2 2 0 0 0 -2.828 0z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigUpLineFilledIcon = {
    name: 'ArrowBigUpLineFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-up-line-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.586 3l-6.586 6.586a2 2 0 0 0 -.434 2.18l.068 .145a2 2 0 0 0 1.78 1.089h2.586v5a1 1 0 0 0 1 1h6l.117 -.007a1 1 0 0 0 .883 -.993l-.001 -5h2.587a2 2 0 0 0 1.414 -3.414l-6.586 -6.586a2 2 0 0 0 -2.828 0z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 20a1 1 0 0 1 .117 1.993l-.117 .007h-6a1 1 0 0 1 -.117 -1.993l.117 -.007h6z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigUpLineIcon = {
    name: 'ArrowBigUpLineIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-up-line",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 12h-3.586a1 1 0 0 1 -.707 -1.707l6.586 -6.586a1 1 0 0 1 1.414 0l6.586 6.586a1 1 0 0 1 -.707 1.707h-3.586v6h-6v-6z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 21h6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigUpLinesFilledIcon = {
    name: 'ArrowBigUpLinesFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-up-lines-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.586 3l-6.586 6.586a2 2 0 0 0 -.434 2.18l.068 .145a2 2 0 0 0 1.78 1.089h2.586v2a1 1 0 0 0 1 1h6l.117 -.007a1 1 0 0 0 .883 -.993l-.001 -2h2.587a2 2 0 0 0 1.414 -3.414l-6.586 -6.586a2 2 0 0 0 -2.828 0z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 20a1 1 0 0 1 .117 1.993l-.117 .007h-6a1 1 0 0 1 -.117 -1.993l.117 -.007h6z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 17a1 1 0 0 1 .117 1.993l-.117 .007h-6a1 1 0 0 1 -.117 -1.993l.117 -.007h6z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigUpLinesIcon = {
    name: 'ArrowBigUpLinesIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-up-lines",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 12h-3.586a1 1 0 0 1 -.707 -1.707l6.586 -6.586a1 1 0 0 1 1.414 0l6.586 6.586a1 1 0 0 1 -.707 1.707h-3.586v3h-6v-3z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 21h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 18h6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBigUpIcon = {
    name: 'ArrowBigUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-big-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 20v-8h-3.586a1 1 0 0 1 -.707 -1.707l6.586 -6.586a1 1 0 0 1 1.414 0l6.586 6.586a1 1 0 0 1 -.707 1.707h-3.586v8a1 1 0 0 1 -1 1h-4a1 1 0 0 1 -1 -1z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowBounceIcon = {
    name: 'ArrowBounceIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-bounce",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 18h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 8a9 9 0 0 1 9 9v1l1.428 -4.285a12 12 0 0 1 6.018 -6.938l.554 -.277"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 6h5v5"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowCurveLeftIcon = {
    name: 'ArrowCurveLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-curve-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 7l-4 -4l-4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 3v4.394a6.737 6.737 0 0 0 3 5.606a6.737 6.737 0 0 1 3 5.606v2.394"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowCurveRightIcon = {
    name: 'ArrowCurveRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-curve-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 7l4 -4l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 3v4.394a6.737 6.737 0 0 1 -3 5.606a6.737 6.737 0 0 0 -3 5.606v2.394"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowDownBarIcon = {
    name: 'ArrowDownBarIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-down-bar",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3v18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 18l3 3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 3h6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowDownCircleIcon = {
    name: 'ArrowDownCircleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-down-circle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 7v14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 18l3 3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 7a2 2 0 1 0 0 -4a2 2 0 0 0 0 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowDownLeftCircleIcon = {
    name: 'ArrowDownLeftCircleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-down-left-circle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.536 8.464l-9.536 9.536"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 14v4h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.586 8.414a2 2 0 1 0 2.828 -2.828a2 2 0 0 0 -2.828 2.828"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowDownLeftIcon = {
    name: 'ArrowDownLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-down-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 7l-10 10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 17l-9 0l0 -9"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowDownRhombusIcon = {
    name: 'ArrowDownRhombusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-down-rhombus",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8v13"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 18l-3 3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.5 5.5l-2.5 -2.5l-2.5 2.5l2.5 2.5z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowDownRightCircleIcon = {
    name: 'ArrowDownRightCircleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-down-right-circle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.464 8.464l9.536 9.536"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 18h4v-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.414 8.414a2 2 0 1 0 -2.828 -2.828a2 2 0 0 0 2.828 2.828"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowDownRightIcon = {
    name: 'ArrowDownRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-down-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 7l10 10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 8l0 9l-9 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowDownSquareIcon = {
    name: 'ArrowDownSquareIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-down-square",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 7v14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 18l3 3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 3v4h-4v-4z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowDownTailIcon = {
    name: 'ArrowDownTailIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-down-tail",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 6v15"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 18l3 3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 3l3 3l3 -3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowDownIcon = {
    name: 'ArrowDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 5l0 14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 13l-6 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 13l6 6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowElbowLeftIcon = {
    name: 'ArrowElbowLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-elbow-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 14v-6h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 8l9 9l9 -9"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowElbowRightIcon = {
    name: 'ArrowElbowRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-elbow-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 14v-6h-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 8l-9 9l-9 -9"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowForkIcon = {
    name: 'ArrowForkIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-fork",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 3h5v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 3h-5v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 3l-7.536 7.536a5 5 0 0 0 -1.464 3.534v6.93"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l7.536 7.536a5 5 0 0 1 1.464 3.534v.93"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowForwardUpDoubleIcon = {
    name: 'ArrowForwardUpDoubleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-forward-up-double",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 14l4 -4l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 14l4 -4l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 10h-7a4 4 0 1 0 0 8h1"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowForwardUpIcon = {
    name: 'ArrowForwardUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-forward-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 14l4 -4l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 10h-11a4 4 0 1 0 0 8h1"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowForwardIcon = {
    name: 'ArrowForwardIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-forward",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 11l4 4l-4 4m4 -4h-11a4 4 0 0 1 0 -8h1"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowGuideIcon = {
    name: 'ArrowGuideIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-guide",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 19h3a2 2 0 0 0 2 -2v-8a2 2 0 0 1 2 -2h7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4l3 3l-3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowIterationIcon = {
    name: 'ArrowIterationIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-iteration",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.5 16a5.5 5.5 0 1 0 -5.5 -5.5v.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 16h18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 13l3 3l-3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowLeftBarIcon = {
    name: 'ArrowLeftBarIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-left-bar",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 12h-18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 9l-3 3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 9v6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowLeftCircleIcon = {
    name: 'ArrowLeftCircleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-left-circle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 12h-14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 9l-3 3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowLeftRhombusIcon = {
    name: 'ArrowLeftRhombusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-left-rhombus",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12h-13"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 9l-3 3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.5 9.5l2.5 2.5l-2.5 2.5l-2.5 -2.5z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowLeftRightIcon = {
    name: 'ArrowLeftRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-left-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 13l4 -4l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 13l-4 -4l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 14a5 5 0 0 1 5 -5h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 19v-5a5 5 0 0 0 -5 -5h-4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowLeftSquareIcon = {
    name: 'ArrowLeftSquareIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-left-square",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 12h-14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 9l-3 3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 14h-4v-4h4z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowLeftTailIcon = {
    name: 'ArrowLeftTailIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-left-tail",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 12h-15"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 9l-3 3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 9l-3 3l3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowLeftIcon = {
    name: 'ArrowLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 12l14 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 12l6 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 12l6 -6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowLoopLeft2Icon = {
    name: 'ArrowLoopLeft2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-loop-left-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 21v-6m0 -6v-1a4 4 0 1 1 4 4h-13"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 16l-4 -4l4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowLoopLeftIcon = {
    name: 'ArrowLoopLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-loop-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 21v-13a4 4 0 1 1 4 4h-13"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 16l-4 -4l4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowLoopRight2Icon = {
    name: 'ArrowLoopRight2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-loop-right-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 21v-6m0 -6v-1a4 4 0 1 0 -4 4h13"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 16l4 -4l-4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowLoopRightIcon = {
    name: 'ArrowLoopRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-loop-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 21v-13a4 4 0 1 0 -4 4h13"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 16l4 -4l-4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowMergeBothIcon = {
    name: 'ArrowMergeBothIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-merge-both",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 8l-4 -4l-4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20v-16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 18c-4 -1.333 -6 -4.667 -6 -10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 18c4 -1.333 6 -4.667 6 -10"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowMergeLeftIcon = {
    name: 'ArrowMergeLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-merge-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 8l4 -4l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20v-16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 18c4 -1.333 6 -4.667 6 -10"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowMergeRightIcon = {
    name: 'ArrowMergeRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-merge-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 8l-4 -4l-4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20v-16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 18c-4 -1.333 -6 -4.667 -6 -10"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowMergeIcon = {
    name: 'ArrowMergeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-merge",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 7l4 -4l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3v5.394a6.737 6.737 0 0 1 -3 5.606a6.737 6.737 0 0 0 -3 5.606v1.394"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3v5.394a6.737 6.737 0 0 0 3 5.606a6.737 6.737 0 0 1 3 5.606v1.394"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowMoveDownIcon = {
    name: 'ArrowMoveDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-move-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 11v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 18l3 3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowMoveLeftIcon = {
    name: 'ArrowMoveLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-move-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 12h-10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 15l-3 -3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 12a2 2 0 1 1 4 0a2 2 0 0 1 -4 0z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowMoveRightIcon = {
    name: 'ArrowMoveRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-move-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 12h10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9l3 3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 12a2 2 0 1 1 -4 0a2 2 0 0 1 4 0z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowMoveUpIcon = {
    name: 'ArrowMoveUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-move-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 13v-10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 6l3 -3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 17a2 2 0 1 1 0 4a2 2 0 0 1 0 -4z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowNarrowDownIcon = {
    name: 'ArrowNarrowDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-narrow-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 5l0 14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 15l-4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 15l4 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowNarrowLeftIcon = {
    name: 'ArrowNarrowLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-narrow-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 12l14 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 12l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 12l4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowNarrowRightIcon = {
    name: 'ArrowNarrowRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-narrow-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 12l14 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 16l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 8l4 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowNarrowUpIcon = {
    name: 'ArrowNarrowUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-narrow-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 5l0 14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 9l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 9l4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRampLeft2Icon = {
    name: 'ArrowRampLeft2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-ramp-left-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 3v8.707"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 14l-4 -4l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 21c0 -6.075 -4.925 -11 -11 -11h-3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRampLeft3Icon = {
    name: 'ArrowRampLeft3Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-ramp-left-3",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 3v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 16l-4 -4l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 21v-6a3 3 0 0 0 -3 -3h-11"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRampLeftIcon = {
    name: 'ArrowRampLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-ramp-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 3l0 8.707"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 7l4 -4l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 14l-4 -4l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 21a11 11 0 0 0 -11 -11h-3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRampRight2Icon = {
    name: 'ArrowRampRight2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-ramp-right-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 3v8.707"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 14l4 -4l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 21c0 -6.075 4.925 -11 11 -11h3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRampRight3Icon = {
    name: 'ArrowRampRight3Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-ramp-right-3",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 3v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 16l4 -4l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 21v-6a3 3 0 0 1 3 -3h11"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRampRightIcon = {
    name: 'ArrowRampRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-ramp-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3l0 8.707"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 7l-4 -4l-4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 14l4 -4l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 21a11 11 0 0 1 11 -11h3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRightBarIcon = {
    name: 'ArrowRightBarIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-right-bar",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 15l3 -3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 12h18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 9v6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRightCircleIcon = {
    name: 'ArrowRightCircleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-right-circle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 15l3 -3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 12h14"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRightRhombusIcon = {
    name: 'ArrowRightRhombusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-right-rhombus",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12h13"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9l3 3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.5 9.5l-2.5 2.5l2.5 2.5l2.5 -2.5z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRightSquareIcon = {
    name: 'ArrowRightSquareIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-right-square",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 12l14 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 15l3 -3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 10h4v4h-4z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRightTailIcon = {
    name: 'ArrowRightTailIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-right-tail",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 15l3 -3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 15l3 -3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12l15 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRightIcon = {
    name: 'ArrowRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 12l14 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 18l6 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 6l6 6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRotaryFirstLeftIcon = {
    name: 'ArrowRotaryFirstLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-rotary-first-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 10a3 3 0 1 1 0 -6a3 3 0 0 1 0 6z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 10v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.5 9.5l-8.5 8.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 18h-5v-5"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRotaryFirstRightIcon = {
    name: 'ArrowRotaryFirstRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-rotary-first-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 7m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 10v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.5 9.5l8.5 8.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 18h5v-5"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRotaryLastLeftIcon = {
    name: 'ArrowRotaryLastLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-rotary-last-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 15a3 3 0 1 1 0 -6a3 3 0 0 1 0 6z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 15v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.5 9.5l-6.5 -6.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 3h-5v5"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRotaryLastRightIcon = {
    name: 'ArrowRotaryLastRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-rotary-last-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 15v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.5 9.5l6.5 -6.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 3h5v5"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRotaryLeftIcon = {
    name: 'ArrowRotaryLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-rotary-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 10a3 3 0 1 1 0 -6a3 3 0 0 1 0 6z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 10v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 7h-10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 11l-4 -4l4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRotaryRightIcon = {
    name: 'ArrowRotaryRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-rotary-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 7m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 10v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 11l4 -4l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 7h10"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRotaryStraightIcon = {
    name: 'ArrowRotaryStraightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-rotary-straight",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 13m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 16v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 3v7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 7l4 -4l4 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRoundaboutLeftIcon = {
    name: 'ArrowRoundaboutLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-roundabout-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 9h8a5 5 0 1 1 5 5v7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 5l-4 4l4 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowRoundaboutRightIcon = {
    name: 'ArrowRoundaboutRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-roundabout-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 9h-8a5 5 0 1 0 -5 5v7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 5l4 4l-4 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowSharpTurnLeftIcon = {
    name: 'ArrowSharpTurnLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-sharp-turn-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 18v-11.31a.7 .7 0 0 0 -1.195 -.495l-9.805 9.805"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 16h-5v-5"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowSharpTurnRightIcon = {
    name: 'ArrowSharpTurnRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-sharp-turn-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 18v-11.31a.7 .7 0 0 1 1.195 -.495l9.805 9.805"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 16h5v-5"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowUpBarIcon = {
    name: 'ArrowUpBarIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-up-bar",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 21l0 -18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 6l-3 -3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 21l6 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowUpCircleIcon = {
    name: 'ArrowUpCircleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-up-circle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 17v-14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 6l-3 -3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 17a2 2 0 1 0 0 4a2 2 0 0 0 0 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowUpLeftCircleIcon = {
    name: 'ArrowUpLeftCircleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-up-left-circle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.536 15.536l-9.536 -9.536"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 6h-4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.586 15.586a2 2 0 1 0 2.828 2.828a2 2 0 0 0 -2.828 -2.828"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowUpLeftIcon = {
    name: 'ArrowUpLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-up-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 7l10 10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7l-9 0l0 9"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowUpRhombusIcon = {
    name: 'ArrowUpRhombusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-up-rhombus",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16v-13"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 6l-3 -3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.5 18.5l-2.5 2.5l-2.5 -2.5l2.5 -2.5z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowUpRightCircleIcon = {
    name: 'ArrowUpRightCircleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-up-right-circle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.464 15.536l9.536 -9.536"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 10v-4h-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.414 15.586a2 2 0 1 0 -2.828 2.828a2 2 0 0 0 2.828 -2.828"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowUpRightIcon = {
    name: 'ArrowUpRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-up-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 7l-10 10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 7l9 0l0 9"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowUpSquareIcon = {
    name: 'ArrowUpSquareIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-up-square",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 17l0 -14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 6l-3 -3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 21v-4h4v4z"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowUpTailIcon = {
    name: 'ArrowUpTailIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-up-tail",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18l0 -15"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 6l-3 -3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 21l-3 -3l-3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowUpIcon = {
    name: 'ArrowUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 5l0 14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 11l-6 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 11l6 -6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowWaveLeftDownIcon = {
    name: 'ArrowWaveLeftDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-wave-left-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 14h-4v-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 12c-.887 1.284 -2.48 2.033 -4 2c-1.52 .033 -3.113 -.716 -4 -2s-2.48 -2.033 -4 -2c-1.52 -.033 -3 1 -4 2l-2 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowWaveLeftUpIcon = {
    name: 'ArrowWaveLeftUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-wave-left-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 10h-4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 12c-.887 -1.285 -2.48 -2.033 -4 -2c-1.52 -.033 -3.113 .715 -4 2c-.887 1.284 -2.48 2.033 -4 2c-1.52 .033 -3 -1 -4 -2l-2 -2"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowWaveRightDownIcon = {
    name: 'ArrowWaveRightDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-wave-right-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 14h4v-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 12c.887 1.284 2.48 2.033 4 2c1.52 .033 3.113 -.716 4 -2s2.48 -2.033 4 -2c1.52 -.033 3 1 4 2l2 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowWaveRightUpIcon = {
    name: 'ArrowWaveRightUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-wave-right-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 10h4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 12c.887 -1.284 2.48 -2.033 4 -2c1.52 -.033 3.113 .716 4 2s2.48 2.033 4 2c1.52 .033 3 -1 4 -2l2 -2"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowZigZagIcon = {
    name: 'ArrowZigZagIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrow-zig-zag",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 20v-10l10 6v-12"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 7l3 -3l3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsCrossIcon = {
    name: 'ArrowsCrossIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-cross",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4h4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 9l5 -5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l5 -5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20h4v-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l16 16"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsDiagonal2Icon = {
    name: 'ArrowsDiagonal2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-diagonal-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20l4 0l0 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 14l6 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4l-4 0l0 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l6 6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsDiagonalMinimize2Icon = {
    name: 'ArrowsDiagonalMinimize2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-diagonal-minimize-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 10h-4v-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4l-6 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 14h4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 14l-6 6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsDiagonalMinimizeIcon = {
    name: 'ArrowsDiagonalMinimizeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-diagonal-minimize",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 10h4v-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l6 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 14h-4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 14l6 6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsDiagonalIcon = {
    name: 'ArrowsDiagonalIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-diagonal",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4l4 0l0 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 10l6 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20l-4 0l0 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l6 -6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsDiffIcon = {
    name: 'ArrowsDiffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-diff",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 16h10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 16l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 16l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 8h-10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 8l-4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 8l-4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsDoubleNeSwIcon = {
    name: 'ArrowsDoubleNeSwIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-double-ne-sw",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 14l11 -11"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 3h4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 17v4h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 10l-11 11"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsDoubleNwSeIcon = {
    name: 'ArrowsDoubleNwSeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-double-nw-se",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 21l-11 -11"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 14v-4h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 14h4v-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 3l11 11"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsDoubleSeNwIcon = {
    name: 'ArrowsDoubleSeNwIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-double-se-nw",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 10l11 11"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 17v4h-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 3h-4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 14l-11 -11"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsDoubleSwNeIcon = {
    name: 'ArrowsDoubleSwNeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-double-sw-ne",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 3l-11 11"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 10v4h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 10h4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 21l11 -11"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsDownUpIcon = {
    name: 'ArrowsDownUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-down-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 3l0 18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 18l-3 3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 21l0 -18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 6l-3 -3l-3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsDownIcon = {
    name: 'ArrowsDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 21l0 -18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 18l-3 3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 18l3 3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 21l0 -18"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsExchange2Icon = {
    name: 'ArrowsExchange2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-exchange-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 10h-14l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 14h14l-4 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsExchangeIcon = {
    name: 'ArrowsExchangeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-exchange",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 10h14l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 14h-14l4 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsHorizontalIcon = {
    name: 'ArrowsHorizontalIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-horizontal",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 8l-4 4l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 8l4 4l-4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 12l18 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsJoin2Icon = {
    name: 'ArrowsJoin2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-join-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 7h1.948c1.913 0 3.705 .933 4.802 2.5a5.861 5.861 0 0 0 4.802 2.5h6.448"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 17h1.95a5.854 5.854 0 0 0 4.798 -2.5a5.854 5.854 0 0 1 4.798 -2.5h5.454"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 15l3 -3l-3 -3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsJoinIcon = {
    name: 'ArrowsJoinIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-join",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 7h5l3.5 5h9.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 17h5l3.495 -5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 15l3 -3l-3 -3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsLeftDownIcon = {
    name: 'ArrowsLeftDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-left-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3l-4 4l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 7h11a3 3 0 0 1 3 3v11"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 17l4 4l4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsLeftRightIcon = {
    name: 'ArrowsLeftRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-left-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 17l-18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 10l-3 -3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 7l18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 20l3 -3l-3 -3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsLeftIcon = {
    name: 'ArrowsLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 7l18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 20l-3 -3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 4l-3 3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 17l18 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsMaximizeIcon = {
    name: 'ArrowsMaximizeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-maximize",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4l4 0l0 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 10l6 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20l-4 0l0 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l6 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20l4 0l0 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 14l6 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4l-4 0l0 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l6 6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsMinimizeIcon = {
    name: 'ArrowsMinimizeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-minimize",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 9l4 0l0 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l6 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 15l4 0l0 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 21l6 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 9l-4 0l0 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 9l6 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 15l-4 0l0 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 15l6 6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsMoveHorizontalIcon = {
    name: 'ArrowsMoveHorizontalIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-move-horizontal",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9l3 3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 12h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 9l-3 3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 12h6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsMoveVerticalIcon = {
    name: 'ArrowsMoveVerticalIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-move-vertical",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 18l3 3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 15v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 6l-3 -3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3v6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsMoveIcon = {
    name: 'ArrowsMoveIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-move",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9l3 3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 12h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 9l-3 3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 12h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 18l3 3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 15v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 6l-3 -3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3v6"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsRandomIcon = {
    name: 'ArrowsRandomIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-random",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 21h-4v-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 21l5 -5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.5 9.504l-3.5 -2l2 -3.504"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 7.504l6.83 -1.87"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16l4 -1l1 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 15l-3.5 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 5l-.5 4l-4 -.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.5 9l-4.5 -5.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsRightDownIcon = {
    name: 'ArrowsRightDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-right-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 17l4 4l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 21v-11a3 3 0 0 1 3 -3h11"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 11l4 -4l-4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsRightLeftIcon = {
    name: 'ArrowsRightLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-right-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 7l-18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 10l3 -3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 20l-3 -3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 17l18 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsRightIcon = {
    name: 'ArrowsRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 17l-18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4l3 3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 20l3 -3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 7l-18 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsShuffle2Icon = {
    name: 'ArrowsShuffle2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-shuffle-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4l3 3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 20l3 -3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 7h3a5 5 0 0 1 5 5a5 5 0 0 0 5 5h5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 17h3a5 5 0 0 0 5 -5a5 5 0 0 1 5 -5h5"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsShuffleIcon = {
    name: 'ArrowsShuffleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-shuffle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 4l3 3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 20l3 -3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 7h3a5 5 0 0 1 5 5a5 5 0 0 0 5 5h5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 7h-5a4.978 4.978 0 0 0 -3 1m-4 8a4.984 4.984 0 0 1 -3 1h-3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsSortIcon = {
    name: 'ArrowsSortIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-sort",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 9l4 -4l4 4m-4 -4v14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 15l-4 4l-4 -4m4 4v-14"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsSplit2Icon = {
    name: 'ArrowsSplit2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-split-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 17h-5.397a5 5 0 0 1 -4.096 -2.133l-.514 -.734a5 5 0 0 0 -4.096 -2.133h-3.897"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 7h-5.395a5 5 0 0 0 -4.098 2.135l-.51 .73a5 5 0 0 1 -4.097 2.135h-3.9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 10l3 -3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 20l3 -3l-3 -3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsSplitIcon = {
    name: 'ArrowsSplitIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-split",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 17h-8l-3.5 -5h-6.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 7h-8l-3.495 5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 10l3 -3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 20l3 -3l-3 -3"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsTransferDownIcon = {
    name: 'ArrowsTransferDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-transfer-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 3v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 18l-3 3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 21v-18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 6l-3 -3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 21v-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 15v-2"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsTransferUpIcon = {
    name: 'ArrowsTransferUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-transfer-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 21v-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 6l-3 -3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 3v18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 18l-3 3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 9v2"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsUpDownIcon = {
    name: 'ArrowsUpDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-up-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3l0 18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 6l-3 -3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 18l-3 3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 21l0 -18"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsUpLeftIcon = {
    name: 'ArrowsUpLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-up-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 7l-4 -4l-4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 3v11a3 3 0 0 1 -3 3h-11"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 13l-4 4l4 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsUpRightIcon = {
    name: 'ArrowsUpRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-up-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 21l4 -4l-4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 17h-11a3 3 0 0 1 -3 -3v-11"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 7l-4 -4l-4 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsUpIcon = {
    name: 'ArrowsUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 3l0 18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 6l3 -3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 6l-3 -3l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3l0 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArrowsVerticalIcon = {
    name: 'ArrowsVerticalIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-arrows-vertical",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 7l4 -4l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 17l4 4l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3l0 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArtboardFilledIcon = {
    name: 'ArtboardFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-artboard-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 7h-6a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h6a2 2 0 0 0 2 -2v-6a2 2 0 0 0 -2 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 7a1 1 0 0 1 .117 1.993l-.117 .007h-1a1 1 0 0 1 -.117 -1.993l.117 -.007h1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 15a1 1 0 0 1 .117 1.993l-.117 .007h-1a1 1 0 0 1 -.117 -1.993l.117 -.007h1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 2a1 1 0 0 1 .993 .883l.007 .117v1a1 1 0 0 1 -1.993 .117l-.007 -.117v-1a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 2a1 1 0 0 1 .993 .883l.007 .117v1a1 1 0 0 1 -1.993 .117l-.007 -.117v-1a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 7a1 1 0 0 1 .117 1.993l-.117 .007h-1a1 1 0 0 1 -.117 -1.993l.117 -.007h1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 15a1 1 0 0 1 .117 1.993l-.117 .007h-1a1 1 0 0 1 -.117 -1.993l.117 -.007h1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 19a1 1 0 0 1 .993 .883l.007 .117v1a1 1 0 0 1 -1.993 .117l-.007 -.117v-1a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 19a1 1 0 0 1 .993 .883l.007 .117v1a1 1 0 0 1 -1.993 .117l-.007 -.117v-1a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArtboardOffIcon = {
    name: 'ArtboardOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-artboard-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8h3a1 1 0 0 1 1 1v3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.716 15.698a1 1 0 0 1 -.716 .302h-6a1 1 0 0 1 -1 -1v-6c0 -.273 .11 -.52 .287 -.7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 8h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 16h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 3v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 3v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArtboardIcon = {
    name: 'ArtboardIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-artboard",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 8m0 1a1 1 0 0 1 1 -1h6a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-6a1 1 0 0 1 -1 -1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 8l1 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 16l1 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 3l0 1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 3l0 1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8l1 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16l1 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20l0 1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20l0 1"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArticleFilledFilledIcon = {
    name: 'ArticleFilledFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-article-filled-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 3a3 3 0 0 1 2.995 2.824l.005 .176v12a3 3 0 0 1 -2.824 2.995l-.176 .005h-14a3 3 0 0 1 -2.995 -2.824l-.005 -.176v-12a3 3 0 0 1 2.824 -2.995l.176 -.005h14zm-2 12h-10l-.117 .007a1 1 0 0 0 0 1.986l.117 .007h10l.117 -.007a1 1 0 0 0 0 -1.986l-.117 -.007zm0 -4h-10l-.117 .007a1 1 0 0 0 0 1.986l.117 .007h10l.117 -.007a1 1 0 0 0 0 -1.986l-.117 -.007zm0 -4h-10l-.117 .007a1 1 0 0 0 0 1.986l.117 .007h10l.117 -.007a1 1 0 0 0 0 -1.986l-.117 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArticleOffIcon = {
    name: 'ArticleOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-article-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4h11a2 2 0 0 1 2 2v11m-1.172 2.821a1.993 1.993 0 0 1 -.828 .179h-14a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 1.156 -1.814"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 8h1m4 0h5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 12h5m4 0h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 16h9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var ArticleIcon = {
    name: 'ArticleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-article",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 4m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 8h10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 12h10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 16h10"
      }, null), createTextVNode(" ")]);
    }
  };

  var AspectRatioFilledIcon = {
    name: 'AspectRatioFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-aspect-ratio-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 4h-14a3 3 0 0 0 -3 3v10a3 3 0 0 0 3 3h14a3 3 0 0 0 3 -3v-10a3 3 0 0 0 -3 -3zm-10 3a1 1 0 0 1 .117 1.993l-.117 .007h-2v2a1 1 0 0 1 -.883 .993l-.117 .007a1 1 0 0 1 -.993 -.883l-.007 -.117v-3a1 1 0 0 1 .883 -.993l.117 -.007h3zm9 5a1 1 0 0 1 .993 .883l.007 .117v3a1 1 0 0 1 -.883 .993l-.117 .007h-3a1 1 0 0 1 -.117 -1.993l.117 -.007h2v-2a1 1 0 0 1 .883 -.993l.117 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AspectRatioOffIcon = {
    name: 'AspectRatioOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-aspect-ratio-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 5h10a2 2 0 0 1 2 2v10m-2 2h-14a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 12v-3h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 12v1m-2 2h-1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AspectRatioIcon = {
    name: 'AspectRatioIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-aspect-ratio",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 12v-3h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 12v3h-3"
      }, null), createTextVNode(" ")]);
    }
  };

  var AssemblyOffIcon = {
    name: 'AssemblyOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-assembly-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.703 4.685l2.326 -1.385a2.056 2.056 0 0 1 2 0l6 3.573h-.029a2 2 0 0 1 1 1.747v6.536c0 .248 -.046 .49 -.132 .715m-2.156 1.837l-4.741 3.029a2 2 0 0 1 -1.942 0l-6 -3.833a2 2 0 0 1 -1.029 -1.747v-6.537a2 2 0 0 1 1.029 -1.748l1.157 -.689"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.593 7.591c.295 -.133 .637 -.12 .921 .04l3 1.79h-.014c.312 .181 .503 .516 .5 .877v1.702m-1.152 2.86l-2.363 1.514a1 1 0 0 1 -.97 0l-3 -1.922a1 1 0 0 1 -.515 -.876v-3.278c0 -.364 .197 -.7 .514 -.877l.568 -.339"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AssemblyIcon = {
    name: 'AssemblyIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-assembly",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.875 6.27a2.225 2.225 0 0 1 1.125 1.948v7.284c0 .809 -.443 1.555 -1.158 1.948l-6.75 4.27a2.269 2.269 0 0 1 -2.184 0l-6.75 -4.27a2.225 2.225 0 0 1 -1.158 -1.948v-7.285c0 -.809 .443 -1.554 1.158 -1.947l6.75 -3.98a2.33 2.33 0 0 1 2.25 0l6.75 3.98h-.033z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.5 9.422c.312 .18 .503 .515 .5 .876v3.277c0 .364 -.197 .7 -.515 .877l-3 1.922a1 1 0 0 1 -.97 0l-3 -1.922a1 1 0 0 1 -.515 -.876v-3.278c0 -.364 .197 -.7 .514 -.877l3 -1.79c.311 -.174 .69 -.174 1 0l3 1.79h-.014z"
      }, null), createTextVNode(" ")]);
    }
  };

  var AssetIcon = {
    name: 'AssetIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-asset",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 15m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.218 17.975l6.619 -12.174"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.079 9.756l12.217 -6.631"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var AsteriskSimpleIcon = {
    name: 'AsteriskSimpleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-asterisk-simple",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12v-9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l-9 -2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l9 -2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l6 8.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l-6 8.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var AsteriskIcon = {
    name: 'AsteriskIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-asterisk",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l8 -4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12v9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l-8 -4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l8 4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3v9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l-8 4.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var AtOffIcon = {
    name: 'AtOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-at-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.174 9.17a4 4 0 0 0 5.646 5.668m1.18 -2.838a4 4 0 0 0 -4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.695 15.697a2.5 2.5 0 0 0 1.305 -2.197v-1.5a9 9 0 0 0 -13.055 -8.047m-2.322 1.683a9 9 0 0 0 9.877 14.644"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AtIcon = {
    name: 'AtIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-at",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-4 0a4 4 0 1 0 8 0a4 4 0 1 0 -8 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12v1.5a2.5 2.5 0 0 0 5 0v-1.5a9 9 0 1 0 -5.5 8.28"
      }, null), createTextVNode(" ")]);
    }
  };

  var Atom2FilledIcon = {
    name: 'Atom2FilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-atom-2-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8a4 4 0 1 1 -3.995 4.2l-.005 -.2l.005 -.2a4 4 0 0 1 3.995 -3.8z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 8a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 8a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M2.89 12.006a1 1 0 0 1 1.104 .884a8 8 0 0 0 4.444 6.311a1 1 0 1 1 -.876 1.799a10 10 0 0 1 -5.556 -7.89a1 1 0 0 1 .884 -1.103z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.993 12l.117 .006a1 1 0 0 1 .884 1.104a10 10 0 0 1 -5.556 7.889a1 1 0 1 1 -.876 -1.798a8 8 0 0 0 4.444 -6.31a1 1 0 0 1 .987 -.891z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.567 4.226a10 10 0 0 1 12.666 0a1 1 0 1 1 -1.266 1.548a8 8 0 0 0 -10.134 0a1 1 0 1 1 -1.266 -1.548z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var Atom2Icon = {
    name: 'Atom2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-atom-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 21l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 9l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 9l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20.1a9 9 0 0 1 -5 -7.1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20.1a9 9 0 0 0 5 -7.1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.2 5a9 9 0 0 1 11.4 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var AtomOffIcon = {
    name: 'AtomOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-atom-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.172 9.172c-3.906 3.905 -5.805 8.337 -4.243 9.9c1.562 1.561 6 -.338 9.9 -4.244m1.884 -2.113c2.587 -3.277 3.642 -6.502 2.358 -7.786c-1.284 -1.284 -4.508 -.23 -7.784 2.357"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4.929 4.929c-1.562 1.562 .337 6 4.243 9.9c3.905 3.905 8.337 5.804 9.9 4.242m-.072 -4.071c-.767 -1.794 -2.215 -3.872 -4.172 -5.828c-1.944 -1.945 -4.041 -3.402 -5.828 -4.172"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AtomIcon = {
    name: 'AtomIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-atom",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.071 4.929c-1.562 -1.562 -6 .337 -9.9 4.243c-3.905 3.905 -5.804 8.337 -4.242 9.9c1.562 1.561 6 -.338 9.9 -4.244c3.905 -3.905 5.804 -8.337 4.242 -9.9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4.929 4.929c-1.562 1.562 .337 6 4.243 9.9c3.905 3.905 8.337 5.804 9.9 4.242c1.561 -1.562 -.338 -6 -4.244 -9.9c-3.905 -3.905 -8.337 -5.804 -9.9 -4.242"
      }, null), createTextVNode(" ")]);
    }
  };

  var AugmentedReality2Icon = {
    name: 'AugmentedReality2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-augmented-reality-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 21h-2a2 2 0 0 1 -2 -2v-14a2 2 0 0 1 2 -2h8a2 2 0 0 1 2 2v3.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17l-4 -2.5l4 -2.5l4 2.5v4.5l-4 2.5z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 14.5v4.5l4 2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17l4 -2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 4h2"
      }, null), createTextVNode(" ")]);
    }
  };

  var AugmentedRealityOffIcon = {
    name: 'AugmentedRealityOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-augmented-reality-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8v-2c0 -.557 .228 -1.061 .595 -1.424"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16v2a2 2 0 0 0 2 2h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4h2a2 2 0 0 1 2 2v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20h2c.558 0 1.062 -.228 1.425 -.596"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12.5l.312 -.195m2.457 -1.536l1.231 -.769"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.225 9.235l-1.225 .765l4 2.5v4.5l3.076 -1.923m.924 -3.077v-2l-4 -2.5l-.302 .189"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 10v4.5l4 2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AugmentedRealityIcon = {
    name: 'AugmentedRealityIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-augmented-reality",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8v-2a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16v2a2 2 0 0 0 2 2h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4h2a2 2 0 0 1 2 2v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20h2a2 2 0 0 0 2 -2v-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12.5l4 -2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 10l4 2.5v4.5l4 -2.5v-4.5l-4 -2.5z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 10v4.5l4 2.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var AwardFilledIcon = {
    name: 'AwardFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-award-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.496 13.983l1.966 3.406a1.001 1.001 0 0 1 -.705 1.488l-.113 .011l-.112 -.001l-2.933 -.19l-1.303 2.636a1.001 1.001 0 0 1 -1.608 .26l-.082 -.094l-.072 -.11l-1.968 -3.407a8.994 8.994 0 0 0 6.93 -3.999z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.43 17.982l-1.966 3.408a1.001 1.001 0 0 1 -1.622 .157l-.076 -.1l-.064 -.114l-1.304 -2.635l-2.931 .19a1.001 1.001 0 0 1 -1.022 -1.29l.04 -.107l.05 -.1l1.968 -3.409a8.994 8.994 0 0 0 6.927 4.001z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 2l.24 .004a7 7 0 0 1 6.76 6.996l-.003 .193l-.007 .192l-.018 .245l-.026 .242l-.024 .178a6.985 6.985 0 0 1 -.317 1.268l-.116 .308l-.153 .348a7.001 7.001 0 0 1 -12.688 -.028l-.13 -.297l-.052 -.133l-.08 -.217l-.095 -.294a6.96 6.96 0 0 1 -.093 -.344l-.06 -.271l-.049 -.271l-.02 -.139l-.039 -.323l-.024 -.365l-.006 -.292a7 7 0 0 1 6.76 -6.996l.24 -.004z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var AwardOffIcon = {
    name: 'AwardOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-award-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.72 12.704a6 6 0 0 0 -8.433 -8.418m-1.755 2.24a6 6 0 0 0 7.936 7.944"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 15l3.4 5.89l1.598 -3.233l.707 .046m1.108 -2.902l-1.617 -2.8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.802 12l-3.4 5.89l3.598 -.233l1.598 3.232l3.4 -5.889"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var AwardIcon = {
    name: 'AwardIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-award",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 9m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 15l3.4 5.89l1.598 -3.233l3.598 .232l-3.4 -5.889"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.802 12l-3.4 5.89l3.598 -.233l1.598 3.232l3.4 -5.889"
      }, null), createTextVNode(" ")]);
    }
  };

  var AxeIcon = {
    name: 'AxeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-axe",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 9l7.383 7.418c.823 .82 .823 2.148 0 2.967a2.11 2.11 0 0 1 -2.976 0l-7.407 -7.385"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.66 15.66l-3.32 -3.32a1.25 1.25 0 0 1 .42 -2.044l3.24 -1.296l6 -6l3 3l-6 6l-1.296 3.24a1.25 1.25 0 0 1 -2.044 .42z"
      }, null), createTextVNode(" ")]);
    }
  };

  var AxisXIcon = {
    name: 'AxisXIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-axis-x",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 13v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 9v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 5v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 20l3 -3l-3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 17h16"
      }, null), createTextVNode(" ")]);
    }
  };

  var AxisYIcon = {
    name: 'AxisYIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-axis-y",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 20h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 20h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 20h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 7l3 -3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 20v-16"
      }, null), createTextVNode(" ")]);
    }
  };

  var BabyBottleIcon = {
    name: 'BabyBottleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-baby-bottle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 10h14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 2v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4a5 5 0 0 1 5 5v11a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2v-11a5 5 0 0 1 5 -5z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BabyCarriageIcon = {
    name: 'BabyCarriageIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-baby-carriage",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M2 5h2.5l1.632 4.897a6 6 0 0 0 5.693 4.103h2.675a5.5 5.5 0 0 0 0 -11h-.5v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 9h14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17l1 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 14l1 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BackhoeIcon = {
    name: 'BackhoeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-backhoe",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 17m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 19l-9 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 15l9 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12v-5h2a3 3 0 0 1 3 3v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 15v-2a1 1 0 0 1 1 -1h7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21.12 9.88l-3.12 -4.88l-5 5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21.12 9.88a3 3 0 0 1 -2.12 5.12a3 3 0 0 1 -2.12 -.88l4.24 -4.24z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BackpackOffIcon = {
    name: 'BackpackOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-backpack-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 6h3a6 6 0 0 1 6 6v3m-.129 3.872a3 3 0 0 1 -2.871 2.128h-8a3 3 0 0 1 -3 -3v-6a5.99 5.99 0 0 1 2.285 -4.712"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 6v-1a2 2 0 1 1 4 0v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BackpackIcon = {
    name: 'BackpackIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-backpack",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 18v-6a6 6 0 0 1 6 -6h2a6 6 0 0 1 6 6v6a3 3 0 0 1 -3 3h-8a3 3 0 0 1 -3 -3z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 6v-1a2 2 0 1 1 4 0v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 21v-4a2 2 0 0 1 2 -2h2a2 2 0 0 1 2 2v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 10h2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BackspaceFilledIcon = {
    name: 'BackspaceFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-backspace-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 5a2 2 0 0 1 1.995 1.85l.005 .15v10a2 2 0 0 1 -1.85 1.995l-.15 .005h-11a1 1 0 0 1 -.608 -.206l-.1 -.087l-5.037 -5.04c-.809 -.904 -.847 -2.25 -.083 -3.23l.12 -.144l5 -5a1 1 0 0 1 .577 -.284l.131 -.009h11zm-7.489 4.14a1 1 0 0 0 -1.301 1.473l.083 .094l1.292 1.293l-1.292 1.293l-.083 .094a1 1 0 0 0 1.403 1.403l.094 -.083l1.293 -1.292l1.293 1.292l.094 .083a1 1 0 0 0 1.403 -1.403l-.083 -.094l-1.292 -1.293l1.292 -1.293l.083 -.094a1 1 0 0 0 -1.403 -1.403l-.094 .083l-1.293 1.292l-1.293 -1.292l-.094 -.083l-.102 -.07z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BackspaceIcon = {
    name: 'BackspaceIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-backspace",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 6a1 1 0 0 1 1 1v10a1 1 0 0 1 -1 1h-11l-5 -5a1.5 1.5 0 0 1 0 -2l5 -5z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 10l4 4m0 -4l-4 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var Badge3dIcon = {
    name: 'Badge3dIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-3d",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 9.5a.5 .5 0 0 1 .5 -.5h1a1.5 1.5 0 0 1 0 3h-.5h.5a1.5 1.5 0 0 1 0 3h-1a.5 .5 0 0 1 -.5 -.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z"
      }, null), createTextVNode(" ")]);
    }
  };

  var Badge4kIcon = {
    name: 'Badge4kIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-4k",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 9v2a1 1 0 0 0 1 1h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 9v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 9v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 9l-2 3l2 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 12h-1"
      }, null), createTextVNode(" ")]);
    }
  };

  var Badge8kIcon = {
    name: 'Badge8kIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-8k",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 9v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 9l-2 3l2 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 12h-1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.5 12h-.5a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1a1 1 0 0 1 1 1v1a1 1 0 0 1 -1 1h-1a1 1 0 0 0 -1 1v1a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgeAdIcon = {
    name: 'BadgeAdIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-ad",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 15v-4.5a1.5 1.5 0 0 1 3 0v4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 13h3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgeArIcon = {
    name: 'BadgeArIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-ar",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 15v-4.5a1.5 1.5 0 0 1 3 0v4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 13h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 12h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6m3 0l-2 -3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgeCcIcon = {
    name: 'BadgeCcIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-cc",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 10.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 10.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgeFilledIcon = {
    name: 'BadgeFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.486 3.143l-4.486 2.69l-4.486 -2.69a1 1 0 0 0 -1.514 .857v13a1 1 0 0 0 .486 .857l5 3a1 1 0 0 0 1.028 0l5 -3a1 1 0 0 0 .486 -.857v-13a1 1 0 0 0 -1.514 -.857z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgeHdIcon = {
    name: 'BadgeHdIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-hd",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 15v-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 15v-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 12h3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgeOffIcon = {
    name: 'BadgeOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 7v10l5 3l5 -3m0 -4v-9l-5 3l-2.496 -1.497"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgeSdIcon = {
    name: 'BadgeSdIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-sd",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 9v6h1a2 2 0 0 0 2 -2v-2a2 2 0 0 0 -2 -2h-1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 14.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgeTmIcon = {
    name: 'BadgeTmIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-tm",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 9h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 9v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 15v-6l2 3l2 -3v6"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgeVoIcon = {
    name: 'BadgeVoIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-vo",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 9l2 6l2 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.5 9a1.5 1.5 0 0 1 1.5 1.5v3a1.5 1.5 0 0 1 -3 0v-3a1.5 1.5 0 0 1 1.5 -1.5z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgeVrIcon = {
    name: 'BadgeVrIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-vr",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 12h1.5a1.5 1.5 0 0 0 0 -3h-1.5v6m3 0l-2 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 9l2 6l2 -6"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgeWcIcon = {
    name: 'BadgeWcIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge-wc",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 5m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.5 9l.5 6l2 -4l2 4l.5 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 10.5a1.5 1.5 0 0 0 -3 0v3a1.5 1.5 0 0 0 3 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgeIcon = {
    name: 'BadgeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badge",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v-13l-5 3l-5 -3v13l5 3z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgesFilledIcon = {
    name: 'BadgesFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badges-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.486 12.143l-4.486 2.69l-4.486 -2.69a1 1 0 0 0 -1.514 .857v4a1 1 0 0 0 .486 .857l5 3a1 1 0 0 0 1.028 0l5 -3a1 1 0 0 0 .486 -.857v-4a1 1 0 0 0 -1.514 -.857z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.486 3.143l-4.486 2.69l-4.486 -2.69a1 1 0 0 0 -1.514 .857v4a1 1 0 0 0 .486 .857l5 3a1 1 0 0 0 1.028 0l5 -3a1 1 0 0 0 .486 -.857v-4a1 1 0 0 0 -1.514 -.857z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgesOffIcon = {
    name: 'BadgesOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badges-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.505 14.497l-2.505 1.503l-5 -3v4l5 3l5 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.873 9.876l3.127 -1.876v-4l-5 3l-2.492 -1.495m-2.508 1.495v1l2.492 1.495"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BadgesIcon = {
    name: 'BadgesIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-badges",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v-4l-5 3l-5 -3v4l5 3z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 8v-4l-5 3l-5 -3v4l5 3z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BaguetteIcon = {
    name: 'BaguetteIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-baguette",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.628 11.283l5.644 -5.637c2.665 -2.663 5.924 -3.747 8.663 -1.205l.188 .181a2.987 2.987 0 0 1 0 4.228l-11.287 11.274a3 3 0 0 1 -4.089 .135l-.143 -.135c-2.728 -2.724 -1.704 -6.117 1.024 -8.841z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.5 7.5l1.5 3.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.5 10.5l1.5 3.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.5 4.5l1.5 3.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var BallAmericanFootballOffIcon = {
    name: 'BallAmericanFootballOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ball-american-football-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 9l-1 1m-2 2l-3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 12l2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 21a5 5 0 0 0 -5 -5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.813 6.802a12.96 12.96 0 0 0 -3.813 9.198a5 5 0 0 0 5 5a12.96 12.96 0 0 0 9.186 -3.801m1.789 -2.227a12.94 12.94 0 0 0 2.025 -6.972a5 5 0 0 0 -5 -5a12.94 12.94 0 0 0 -6.967 2.022"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 3a5 5 0 0 0 5 5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BallAmericanFootballIcon = {
    name: 'BallAmericanFootballIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ball-american-football",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 9l-6 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 12l2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 10l2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 21a5 5 0 0 0 -5 -5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 3c-7.18 0 -13 5.82 -13 13a5 5 0 0 0 5 5c7.18 0 13 -5.82 13 -13a5 5 0 0 0 -5 -5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 3a5 5 0 0 0 5 5"
      }, null), createTextVNode(" ")]);
    }
  };

  var BallBaseballIcon = {
    name: 'BallBaseballIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ball-baseball",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.636 18.364a9 9 0 1 0 12.728 -12.728a9 9 0 0 0 -12.728 12.728z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.495 3.02a9 9 0 0 1 -9.475 9.475"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.98 11.505a9 9 0 0 0 -9.475 9.475"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 9l2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 13l2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 7l2 1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 11l1 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 11l1 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 16l2 1"
      }, null), createTextVNode(" ")]);
    }
  };

  var BallBasketballIcon = {
    name: 'BallBasketballIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ball-basketball",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.65 5.65l12.7 12.7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.65 18.35l12.7 -12.7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3a9 9 0 0 0 9 9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 12a9 9 0 0 1 9 9"
      }, null), createTextVNode(" ")]);
    }
  };

  var BallBowlingIcon = {
    name: 'BallBowlingIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ball-bowling",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 9l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 12l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BallFootballOffIcon = {
    name: 'BallFootballOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ball-football-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.041 16.046a9 9 0 0 0 -12.084 -12.09m-2.323 1.683a9 9 0 0 0 12.726 12.73"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 7l4.755 3.455l-.566 1.743l-.98 3.014l-.209 .788h-6l-1.755 -5.545l1.86 -1.351l2.313 -1.681z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 7v-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 16l2.5 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.755 10.455l3.745 -1.455"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.061 16.045l-2.561 2.955"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7.245 10.455l-3.745 -1.455"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BallFootballIcon = {
    name: 'BallFootballIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ball-football",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 7l4.76 3.45l-1.76 5.55h-6l-1.76 -5.55z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 7v-4m3 13l2.5 3m-.74 -8.55l3.74 -1.45m-11.44 7.05l-2.56 2.95m.74 -8.55l-3.74 -1.45"
      }, null), createTextVNode(" ")]);
    }
  };

  var BallTennisIcon = {
    name: 'BallTennisIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ball-tennis",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 5.3a9 9 0 0 1 0 13.4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 5.3a9 9 0 0 0 0 13.4"
      }, null), createTextVNode(" ")]);
    }
  };

  var BallVolleyballIcon = {
    name: 'BallVolleyballIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ball-volleyball",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12a8 8 0 0 0 8 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7.5 13.5a12 12 0 0 0 8.5 6.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12a8 8 0 0 0 -7.464 4.928"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.951 7.353a12 12 0 0 0 -9.88 4.111"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12a8 8 0 0 0 -.536 -8.928"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.549 15.147a12 12 0 0 0 1.38 -10.611"
      }, null), createTextVNode(" ")]);
    }
  };

  var BalloonFilledIcon = {
    name: 'BalloonFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-balloon-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 1a7 7 0 0 1 7 7c0 5.457 -3.028 10 -7 10c-3.9 0 -6.89 -4.379 -6.997 -9.703l-.003 -.297l.004 -.24a7 7 0 0 1 6.996 -6.76zm0 4a1 1 0 0 0 0 2l.117 .007a1 1 0 0 1 .883 .993l.007 .117a1 1 0 0 0 1.993 -.117a3 3 0 0 0 -3 -3z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16a1 1 0 0 1 .993 .883l.007 .117v1a3 3 0 0 1 -2.824 2.995l-.176 .005h-3a1 1 0 0 0 -.993 .883l-.007 .117a1 1 0 0 1 -2 0a3 3 0 0 1 2.824 -2.995l.176 -.005h3a1 1 0 0 0 .993 -.883l.007 -.117v-1a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BalloonOffIcon = {
    name: 'BalloonOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-balloon-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 8a2 2 0 0 0 -2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7.762 3.753a6 6 0 0 1 10.238 4.247c0 1.847 -.37 3.564 -1.007 4.993m-1.59 2.42c-.967 1 -2.14 1.587 -3.403 1.587c-3.314 0 -6 -4.03 -6 -9c0 -.593 .086 -1.166 .246 -1.707"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 17v1a2 2 0 0 1 -2 2h-3a2 2 0 0 0 -2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BalloonIcon = {
    name: 'BalloonIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-balloon",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 8a2 2 0 0 0 -2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 8a6 6 0 1 1 12 0c0 4.97 -2.686 9 -6 9s-6 -4.03 -6 -9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 17v1a2 2 0 0 1 -2 2h-3a2 2 0 0 0 -2 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BallpenFilledIcon = {
    name: 'BallpenFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ballpen-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.828 2a3 3 0 0 1 1.977 .743l.145 .136l1.171 1.17a3 3 0 0 1 .136 4.1l-.136 .144l-1.706 1.707l2.292 2.293a1 1 0 0 1 .083 1.32l-.083 .094l-4 4a1 1 0 0 1 -1.497 -1.32l.083 -.094l3.292 -3.293l-1.586 -1.585l-7.464 7.464a3.828 3.828 0 0 1 -2.474 1.114l-.233 .008c-.674 0 -1.33 -.178 -1.905 -.508l-1.216 1.214a1 1 0 0 1 -1.497 -1.32l.083 -.094l1.214 -1.216a3.828 3.828 0 0 1 .454 -4.442l.16 -.17l10.586 -10.586a3 3 0 0 1 1.923 -.873l.198 -.006zm0 2a1 1 0 0 0 -.608 .206l-.099 .087l-1.707 1.707l2.586 2.585l1.707 -1.706a1 1 0 0 0 .284 -.576l.01 -.131a1 1 0 0 0 -.207 -.609l-.087 -.099l-1.171 -1.171a1 1 0 0 0 -.708 -.293z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BallpenOffIcon = {
    name: 'BallpenOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ballpen-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 6l7 7l-2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 10l-4.172 4.172a2.828 2.828 0 1 0 4 4l4.172 -4.172"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12l4.414 -4.414a2 2 0 0 0 0 -2.829l-1.171 -1.171a2 2 0 0 0 -2.829 0l-4.414 4.414"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l1.768 -1.768"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BallpenIcon = {
    name: 'BallpenIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ballpen",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 6l7 7l-4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.828 18.172a2.828 2.828 0 0 0 4 0l10.586 -10.586a2 2 0 0 0 0 -2.829l-1.171 -1.171a2 2 0 0 0 -2.829 0l-10.586 10.586a2.828 2.828 0 0 0 0 4z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l1.768 -1.768"
      }, null), createTextVNode(" ")]);
    }
  };

  var BanIcon = {
    name: 'BanIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-ban",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.7 5.7l12.6 12.6"
      }, null), createTextVNode(" ")]);
    }
  };

  var BandageFilledIcon = {
    name: 'BandageFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bandage-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.207 3.793a5.95 5.95 0 0 1 .179 8.228l-.179 .186l-8 8a5.95 5.95 0 0 1 -8.593 -8.228l.179 -.186l8 -8a5.95 5.95 0 0 1 8.414 0zm-8.207 9.207a1 1 0 0 0 -1 1l.007 .127a1 1 0 0 0 1.993 -.117l-.007 -.127a1 1 0 0 0 -.993 -.883zm2 -2a1 1 0 0 0 -1 1l.007 .127a1 1 0 0 0 1.993 -.117l-.007 -.127a1 1 0 0 0 -.993 -.883zm-4 0a1 1 0 0 0 -1 1l.007 .127a1 1 0 0 0 1.993 -.117l-.007 -.127a1 1 0 0 0 -.993 -.883zm2 -2a1 1 0 0 0 -1 1l.007 .127a1 1 0 0 0 1.993 -.117l-.007 -.127a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BandageOffIcon = {
    name: 'BandageOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bandage-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 12v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 14v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.513 6.487l1.987 -1.987a4.95 4.95 0 0 1 7 7l-2.018 2.018m-1.982 1.982l-4 4a4.95 4.95 0 0 1 -7 -7l4 -4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BandageIcon = {
    name: 'BandageIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bandage",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 10l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 14l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4.5 12.5l8 -8a4.94 4.94 0 0 1 7 7l-8 8a4.94 4.94 0 0 1 -7 -7"
      }, null), createTextVNode(" ")]);
    }
  };

  var BarbellOffIcon = {
    name: 'BarbellOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-barbell-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M2 12h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 8h-2a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.298 6.288a1 1 0 0 0 -.298 .712v10a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 12h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 15v2a1 1 0 0 0 1 1h1c.275 0 .523 -.11 .704 -.29m.296 -3.71v-7a1 1 0 0 0 -1 -1h-1a1 1 0 0 0 -1 1v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 8h2a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M22 12h-1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BarbellIcon = {
    name: 'BarbellIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-barbell",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M2 12h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 8h-2a1 1 0 0 0 -1 1v6a1 1 0 0 0 1 1h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 7v10a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-10a1 1 0 0 0 -1 -1h-1a1 1 0 0 0 -1 1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 12h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 7v10a1 1 0 0 0 1 1h1a1 1 0 0 0 1 -1v-10a1 1 0 0 0 -1 -1h-1a1 1 0 0 0 -1 1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 8h2a1 1 0 0 1 1 1v6a1 1 0 0 1 -1 1h-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M22 12h-1"
      }, null), createTextVNode(" ")]);
    }
  };

  var BarcodeOffIcon = {
    name: 'BarcodeOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-barcode-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 7v-1c0 -.552 .224 -1.052 .586 -1.414"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 17v1a2 2 0 0 0 2 2h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4h2a2 2 0 0 1 2 2v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20h2c.551 0 1.05 -.223 1.412 -.584"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 11h1v2h-1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 11v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 11v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 11v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BarcodeIcon = {
    name: 'BarcodeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-barcode",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 7v-1a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 17v1a2 2 0 0 0 2 2h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4h2a2 2 0 0 1 2 2v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20h2a2 2 0 0 0 2 -2v-1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 11h1v2h-1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 11l0 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 11h1v2h-1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 11l0 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BarrelOffIcon = {
    name: 'BarrelOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-barrel-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4h8.722a2 2 0 0 1 1.841 1.22c.958 2.26 1.437 4.52 1.437 6.78a16.35 16.35 0 0 1 -.407 3.609m-.964 3.013l-.066 .158a2 2 0 0 1 -1.841 1.22h-9.444a2 2 0 0 1 -1.841 -1.22c-.958 -2.26 -1.437 -4.52 -1.437 -6.78c0 -2.21 .458 -4.42 1.374 -6.63"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 4c.585 2.337 .913 4.674 .985 7.01m-.114 3.86a33.415 33.415 0 0 1 -.871 5.13"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 4a34.42 34.42 0 0 0 -.366 1.632m-.506 3.501a32.126 32.126 0 0 0 -.128 2.867c0 2.667 .333 5.333 1 8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4.5 16h11.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.5 8h-7.5m-4 0h-3.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BarrelIcon = {
    name: 'BarrelIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-barrel",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7.278 4h9.444a2 2 0 0 1 1.841 1.22c.958 2.26 1.437 4.52 1.437 6.78c0 2.26 -.479 4.52 -1.437 6.78a2 2 0 0 1 -1.841 1.22h-9.444a2 2 0 0 1 -1.841 -1.22c-.958 -2.26 -1.437 -4.52 -1.437 -6.78c0 -2.26 .479 -4.52 1.437 -6.78a2 2 0 0 1 1.841 -1.22z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 4c.667 2.667 1 5.333 1 8s-.333 5.333 -1 8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 4c-.667 2.667 -1 5.333 -1 8s.333 5.333 1 8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4.5 16h15"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.5 8h-15"
      }, null), createTextVNode(" ")]);
    }
  };

  var BarrierBlockOffIcon = {
    name: 'BarrierBlockOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-barrier-block-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 7h8a1 1 0 0 1 1 1v7c0 .27 -.107 .516 -.282 .696"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 16h-11a1 1 0 0 1 -1 -1v-7a1 1 0 0 1 1 -1h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 16v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7.5 16l4.244 -4.244"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.745 9.755l2.755 -2.755"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.5 16l1.249 -1.249"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.741 12.759l3.259 -3.259"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 13.5l4.752 -4.752"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 20h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 20h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 7v-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BarrierBlockIcon = {
    name: 'BarrierBlockIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-barrier-block",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 7m0 1a1 1 0 0 1 1 -1h14a1 1 0 0 1 1 1v7a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 16v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7.5 16l9 -9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.5 16l6.5 -6.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 13.5l6.5 -6.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 16v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 20h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 20h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 7v-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 7v-2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BaselineDensityLargeIcon = {
    name: 'BaselineDensityLargeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-baseline-density-large",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4h16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20h16"
      }, null), createTextVNode(" ")]);
    }
  };

  var BaselineDensityMediumIcon = {
    name: 'BaselineDensityMediumIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-baseline-density-medium",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20h16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12h16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4h16"
      }, null), createTextVNode(" ")]);
    }
  };

  var BaselineDensitySmallIcon = {
    name: 'BaselineDensitySmallIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-baseline-density-small",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 3h16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 9h16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 15h16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 21h16"
      }, null), createTextVNode(" ")]);
    }
  };

  var BaselineIcon = {
    name: 'BaselineIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-baseline",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20h16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 16v-8a4 4 0 1 1 8 0v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 10h8"
      }, null), createTextVNode(" ")]);
    }
  };

  var BasketFilledIcon = {
    name: 'BasketFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-basket-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.684 3.27l.084 .09l4.7 5.64h3.532a1 1 0 0 1 .991 1.131l-.02 .112l-1.984 7.918c-.258 1.578 -1.41 2.781 -2.817 2.838l-.17 .001l-10.148 -.002c-1.37 -.053 -2.484 -1.157 -2.787 -2.57l-.035 -.185l-2 -8a1 1 0 0 1 .857 -1.237l.113 -.006h3.53l4.702 -5.64a1 1 0 0 1 1.452 -.09zm-.684 8.73a3 3 0 0 0 -2.98 2.65l-.015 .174l-.005 .176l.005 .176a3 3 0 1 0 2.995 -3.176zm0 -6.438l-2.865 3.438h5.73l-2.865 -3.438z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BasketOffIcon = {
    name: 'BasketOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-basket-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 10l1.359 -1.63"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.176 6.188l1.824 -2.188l5 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.77 18.757c-.358 .768 -1.027 1.262 -1.77 1.243h-10c-.966 .024 -1.807 -.817 -2 -2l-2 -8h7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 10h7l-1.397 5.587"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BasketIcon = {
    name: 'BasketIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-basket",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 10l5 -6l5 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 10l-2 8a2 2.5 0 0 1 -2 2h-10a2 2.5 0 0 1 -2 -2l-2 -8z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 15m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BatIcon = {
    name: 'BatIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bat",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 16c.74 -2.286 2.778 -3.762 5 -3c-.173 -2.595 .13 -5.314 -2 -7.5c-1.708 2.648 -3.358 2.557 -5 2.5v-4l-3 2l-3 -2v4c-1.642 .057 -3.292 .148 -5 -2.5c-2.13 2.186 -1.827 4.905 -2 7.5c2.222 -.762 4.26 .714 5 3c2.593 0 3.889 .952 5 4c1.111 -3.048 2.407 -4 5 -4z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 8a3 3 0 0 0 6 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BathFilledIcon = {
    name: 'BathFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bath-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 2a1 1 0 0 1 .993 .883l.007 .117v2.25a1 1 0 0 1 -1.993 .117l-.007 -.117v-1.25h-2a1 1 0 0 0 -.993 .883l-.007 .117v6h13a2 2 0 0 1 1.995 1.85l.005 .15v3c0 1.475 -.638 2.8 -1.654 3.715l.486 .73a1 1 0 0 1 -1.594 1.203l-.07 -.093l-.55 -.823a4.98 4.98 0 0 1 -1.337 .26l-.281 .008h-10a4.994 4.994 0 0 1 -1.619 -.268l-.549 .823a1 1 0 0 1 -1.723 -1.009l.059 -.1l.486 -.73a4.987 4.987 0 0 1 -1.647 -3.457l-.007 -.259v-3a2 2 0 0 1 1.85 -1.995l.15 -.005h1v-6a3 3 0 0 1 2.824 -2.995l.176 -.005h3z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BathOffIcon = {
    name: 'BathOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bath-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12h4a1 1 0 0 1 1 1v3c0 .311 -.036 .614 -.103 .904m-1.61 2.378a3.982 3.982 0 0 1 -2.287 .718h-10a4 4 0 0 1 -4 -4v-3a1 1 0 0 1 1 -1h8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v-6m1.178 -2.824c.252 -.113 .53 -.176 .822 -.176h3v2.25"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 21l1 -1.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 21l-1 -1.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BathIcon = {
    name: 'BathIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bath",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12h16a1 1 0 0 1 1 1v3a4 4 0 0 1 -4 4h-10a4 4 0 0 1 -4 -4v-3a1 1 0 0 1 1 -1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 12v-7a2 2 0 0 1 2 -2h3v2.25"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 21l1 -1.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 21l-1 -1.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var Battery1FilledIcon = {
    name: 'Battery1FilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-1-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 6a3 3 0 0 1 2.995 2.824l.005 .176v.086l.052 .019a1.5 1.5 0 0 1 .941 1.25l.007 .145v3a1.5 1.5 0 0 1 -.948 1.395l-.052 .018v.087a3 3 0 0 1 -2.824 2.995l-.176 .005h-11a3 3 0 0 1 -2.995 -2.824l-.005 -.176v-6a3 3 0 0 1 2.824 -2.995l.176 -.005h11zm-10 3a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var Battery1Icon = {
    name: 'Battery1Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-1",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 10l0 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var Battery2FilledIcon = {
    name: 'Battery2FilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-2-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 6a3 3 0 0 1 2.995 2.824l.005 .176v.086l.052 .019a1.5 1.5 0 0 1 .941 1.25l.007 .145v3a1.5 1.5 0 0 1 -.948 1.395l-.052 .018v.087a3 3 0 0 1 -2.824 2.995l-.176 .005h-11a3 3 0 0 1 -2.995 -2.824l-.005 -.176v-6a3 3 0 0 1 2.824 -2.995l.176 -.005h11zm-10 3a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 0a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var Battery2Icon = {
    name: 'Battery2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 10l0 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 10l0 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var Battery3FilledIcon = {
    name: 'Battery3FilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-3-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 6a3 3 0 0 1 2.995 2.824l.005 .176v.086l.052 .019a1.5 1.5 0 0 1 .941 1.25l.007 .145v3a1.5 1.5 0 0 1 -.948 1.395l-.052 .018v.087a3 3 0 0 1 -2.824 2.995l-.176 .005h-11a3 3 0 0 1 -2.995 -2.824l-.005 -.176v-6a3 3 0 0 1 2.824 -2.995l.176 -.005h11zm-10 3a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 0a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 0a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var Battery3Icon = {
    name: 'Battery3Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-3",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 10l0 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 10l0 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 10l0 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var Battery4FilledIcon = {
    name: 'Battery4FilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-4-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 6a3 3 0 0 1 2.995 2.824l.005 .176v.086l.052 .019a1.5 1.5 0 0 1 .941 1.25l.007 .145v3a1.5 1.5 0 0 1 -.948 1.395l-.052 .018v.087a3 3 0 0 1 -2.824 2.995l-.176 .005h-11a3 3 0 0 1 -2.995 -2.824l-.005 -.176v-6a3 3 0 0 1 2.824 -2.995l.176 -.005h11zm-10 3a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 0a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 0a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883zm3 0a1 1 0 0 0 -1 1v4l.007 .117a1 1 0 0 0 1.993 -.117v-4l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var Battery4Icon = {
    name: 'Battery4Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-4",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 10l0 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 10l0 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 10l0 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 10l0 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var BatteryAutomotiveIcon = {
    name: 'BatteryAutomotiveIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-automotive",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 6m0 2a2 2 0 0 1 2 -2h14a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-14a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 6v-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 4l0 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.5 13l3 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.5 13l3 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 11.5l0 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BatteryCharging2Icon = {
    name: 'BatteryCharging2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-charging-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 9a2 2 0 0 1 2 -2h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 15h6v2a2 2 0 0 1 -2 2h-2a2 2 0 0 1 -2 -2v-2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 22v-3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 15v-2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 15v-2.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var BatteryChargingIcon = {
    name: 'BatteryChargingIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-charging",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 7h1a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 7h-2a2 2 0 0 0 -2 2v6a2 2 0 0 0 2 2h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8l-2 4h3l-2 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var BatteryEcoIcon = {
    name: 'BatteryEcoIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-eco",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 9a2 2 0 0 1 2 -2h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-5.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 16.143c0 -2.84 2.09 -5.143 4.667 -5.143h2.333v.857c0 2.84 -2.09 5.143 -4.667 5.143h-2.333v-.857z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 20v-3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BatteryFilledIcon = {
    name: 'BatteryFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 6a3 3 0 0 1 2.995 2.824l.005 .176v.086l.052 .019a1.5 1.5 0 0 1 .941 1.25l.007 .145v3a1.5 1.5 0 0 1 -.948 1.395l-.052 .018v.087a3 3 0 0 1 -2.824 2.995l-.176 .005h-11a3 3 0 0 1 -2.995 -2.824l-.005 -.176v-6a3 3 0 0 1 2.824 -2.995l.176 -.005h11z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BatteryOffIcon = {
    name: 'BatteryOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 7h6a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5m-2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2h1"
      }, null), createTextVNode(" ")]);
    }
  };

  var BatteryIcon = {
    name: 'BatteryIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-battery",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 7h11a2 2 0 0 1 2 2v.5a.5 .5 0 0 0 .5 .5a.5 .5 0 0 1 .5 .5v3a.5 .5 0 0 1 -.5 .5a.5 .5 0 0 0 -.5 .5v.5a2 2 0 0 1 -2 2h-11a2 2 0 0 1 -2 -2v-6a2 2 0 0 1 2 -2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BeachOffIcon = {
    name: 'BeachOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-beach-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.071 15.102a7.502 7.502 0 0 0 -8.124 1.648"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.27 6.269l9.926 5.731a6 6 0 0 0 -10.32 -6.123"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.732 10c1.658 -2.87 2.225 -5.644 1.268 -6.196c-.957 -.552 -3.075 1.326 -4.732 4.196"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 9l-.739 1.279"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.794 12.82l-.794 1.376"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 19.25a2.4 2.4 0 0 1 1 -.25a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 1.135 -.858"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BeachIcon = {
    name: 'BeachIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-beach",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.553 16.75a7.5 7.5 0 0 0 -10.606 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 3.804a6 6 0 0 0 -8.196 2.196l10.392 6a6 6 0 0 0 -2.196 -8.196z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.732 10c1.658 -2.87 2.225 -5.644 1.268 -6.196c-.957 -.552 -3.075 1.326 -4.732 4.196"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 9l-3 5.196"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 19.25a2.4 2.4 0 0 1 1 -.25a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 1 .25"
      }, null), createTextVNode(" ")]);
    }
  };

  var BedFilledIcon = {
    name: 'BedFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bed-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 6a1 1 0 0 1 .993 .883l.007 .117v6h6v-5a1 1 0 0 1 .883 -.993l.117 -.007h8a3 3 0 0 1 2.995 2.824l.005 .176v8a1 1 0 0 1 -1.993 .117l-.007 -.117v-3h-16v3a1 1 0 0 1 -1.993 .117l-.007 -.117v-11a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 8a2 2 0 1 1 -1.995 2.15l-.005 -.15l.005 -.15a2 2 0 0 1 1.995 -1.85z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BedOffIcon = {
    name: 'BedOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bed-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 7v11"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 14h11"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 14h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 18v-8a2 2 0 0 0 -2 -2h-7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 11v3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 10m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BedIcon = {
    name: 'BedIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bed",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 7v11m0 -4h18m0 4v-8a2 2 0 0 0 -2 -2h-8v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 10m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BeerFilledIcon = {
    name: 'BeerFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-beer-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 2a2 2 0 0 1 1.995 1.85l.005 .15v4c0 1.335 -.229 2.386 -.774 3.692l-.157 .363l-.31 .701a8.902 8.902 0 0 0 -.751 3.242l-.008 .377v3.625a2 2 0 0 1 -1.85 1.995l-.15 .005h-6a2 2 0 0 1 -1.995 -1.85l-.005 -.15v-3.625c0 -1.132 -.21 -2.25 -.617 -3.28l-.142 -.34l-.31 -.699c-.604 -1.358 -.883 -2.41 -.925 -3.698l-.006 -.358v-4a2 2 0 0 1 1.85 -1.995l.15 -.005h10zm0 2h-10v3h10v-3z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BeerOffIcon = {
    name: 'BeerOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-beer-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 7v1.111c0 1.242 .29 2.467 .845 3.578l.31 .622a8 8 0 0 1 .845 3.578v4.111h6v-4.111a8 8 0 0 1 .045 -.85m.953 -3.035l.157 -.315a8 8 0 0 0 .845 -3.578v-4.111h-9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 8h1m4 0h5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BeerIcon = {
    name: 'BeerIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-beer",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 21h6a1 1 0 0 0 1 -1v-3.625c0 -1.397 .29 -2.775 .845 -4.025l.31 -.7c.556 -1.25 .845 -2.253 .845 -3.65v-4a1 1 0 0 0 -1 -1h-10a1 1 0 0 0 -1 1v4c0 1.397 .29 2.4 .845 3.65l.31 .7a9.931 9.931 0 0 1 .845 4.025v3.625a1 1 0 0 0 1 1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 8h12"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellBoltIcon = {
    name: 'BellBoltIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-bolt",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.5 17h-9.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 4.368 2.67"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 16l-2 3h4l-2 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellCancelIcon = {
    name: 'BellCancelIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-cancel",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 21l4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellCheckIcon = {
    name: 'BellCheckIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-check",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.5 17h-7.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3c.016 .129 .037 .256 .065 .382"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 2.502 2.959"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 19l2 2l4 -4"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellCodeIcon = {
    name: 'BellCodeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-code",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.5 17h-7.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 2.498 2.958"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 21l2 -2l-2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17l-2 2l2 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellCogIcon = {
    name: 'BellCogIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-cog",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 17h-8a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.001 19m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.001 15.5v1.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.001 21v1.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M22.032 17.25l-1.299 .75"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.27 20l-1.3 .75"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.97 17.25l1.3 .75"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.733 20l1.3 .75"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellDollarIcon = {
    name: 'BellDollarIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-dollar",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 17h-9a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 3.911 5.17"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 4.02 2.822"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 15h-2.5a1.5 1.5 0 0 0 0 3h1a1.5 1.5 0 0 1 0 3h-2.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 21v1m0 -8v1"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellDownIcon = {
    name: 'BellDownIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-down",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 3.518 2.955"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 16v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M22 19l-3 3l-3 -3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellExclamationIcon = {
    name: 'BellExclamationIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-exclamation",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 17h-11a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 6 0v-1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 16v3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 22v.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellFilledIcon = {
    name: 'BellFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.235 19c.865 0 1.322 1.024 .745 1.668a3.992 3.992 0 0 1 -2.98 1.332a3.992 3.992 0 0 1 -2.98 -1.332c-.552 -.616 -.158 -1.579 .634 -1.661l.11 -.006h4.471z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 2c1.358 0 2.506 .903 2.875 2.141l.046 .171l.008 .043a8.013 8.013 0 0 1 4.024 6.069l.028 .287l.019 .289v2.931l.021 .136a3 3 0 0 0 1.143 1.847l.167 .117l.162 .099c.86 .487 .56 1.766 -.377 1.864l-.116 .006h-16c-1.028 0 -1.387 -1.364 -.493 -1.87a3 3 0 0 0 1.472 -2.063l.021 -.143l.001 -2.97a8 8 0 0 1 3.821 -6.454l.248 -.146l.01 -.043a3.003 3.003 0 0 1 2.562 -2.29l.182 -.017l.176 -.004z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellHeartIcon = {
    name: 'BellHeartIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-heart",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 17h-6a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1c0 1.408 .97 2.59 2.28 2.913"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 22l3.35 -3.284a2.143 2.143 0 0 0 .005 -3.071a2.242 2.242 0 0 0 -3.129 -.006l-.224 .22l-.223 -.22a2.242 2.242 0 0 0 -3.128 -.006a2.143 2.143 0 0 0 -.006 3.071l3.355 3.296z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellMinusFilledIcon = {
    name: 'BellMinusFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-minus-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.235 19c.865 0 1.322 1.024 .745 1.668a3.992 3.992 0 0 1 -2.98 1.332a3.992 3.992 0 0 1 -2.98 -1.332c-.552 -.616 -.158 -1.579 .634 -1.661l.11 -.006h4.471z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 2c1.358 0 2.506 .903 2.875 2.141l.046 .171l.008 .043a8.013 8.013 0 0 1 4.024 6.069l.028 .287l.019 .289v2.931l.021 .136a3 3 0 0 0 1.143 1.847l.167 .117l.162 .099c.86 .487 .56 1.766 -.377 1.864l-.116 .006h-16c-1.028 0 -1.387 -1.364 -.493 -1.87a3 3 0 0 0 1.472 -2.063l.021 -.143l.001 -2.97a8 8 0 0 1 3.821 -6.454l.248 -.146l.01 -.043a3.003 3.003 0 0 1 2.562 -2.29l.182 -.017l.176 -.004zm2 8h-4l-.117 .007a1 1 0 0 0 .117 1.993h4l.117 -.007a1 1 0 0 0 -.117 -1.993z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellMinusIcon = {
    name: 'BellMinusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-minus",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3c.047 .386 .149 .758 .3 1.107"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 3.504 2.958"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 19h6"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellOffIcon = {
    name: 'BellOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.346 5.353c.21 -.129 .428 -.246 .654 -.353a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3m-1 3h-13a4 4 0 0 0 2 -3v-3a6.996 6.996 0 0 1 1.273 -3.707"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 6 0v-1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellPauseIcon = {
    name: 'BellPauseIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-pause",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 17h-9a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 4.022 2.821"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 17v5"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellPinIcon = {
    name: 'BellPinIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-pin",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 17h-8a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 3.64 2.931"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21.121 20.121a3 3 0 1 0 -4.242 0c.418 .419 1.125 1.045 2.121 1.879c1.051 -.89 1.759 -1.516 2.121 -1.879z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 18v.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellPlusFilledIcon = {
    name: 'BellPlusFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-plus-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.235 19c.865 0 1.322 1.024 .745 1.668a3.992 3.992 0 0 1 -2.98 1.332a3.992 3.992 0 0 1 -2.98 -1.332c-.552 -.616 -.158 -1.579 .634 -1.661l.11 -.006h4.471z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 2c1.358 0 2.506 .903 2.875 2.141l.046 .171l.008 .043a8.013 8.013 0 0 1 4.024 6.069l.028 .287l.019 .289v2.931l.021 .136a3 3 0 0 0 1.143 1.847l.167 .117l.162 .099c.86 .487 .56 1.766 -.377 1.864l-.116 .006h-16c-1.028 0 -1.387 -1.364 -.493 -1.87a3 3 0 0 0 1.472 -2.063l.021 -.143l.001 -2.97a8 8 0 0 1 3.821 -6.454l.248 -.146l.01 -.043a3.003 3.003 0 0 1 2.562 -2.29l.182 -.017l.176 -.004zm0 6a1 1 0 0 0 -1 1v1h-1l-.117 .007a1 1 0 0 0 .117 1.993h1v1l.007 .117a1 1 0 0 0 1.993 -.117v-1h1l.117 -.007a1 1 0 0 0 -.117 -1.993h-1v-1l-.007 -.117a1 1 0 0 0 -.993 -.883z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellPlusIcon = {
    name: 'BellPlusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-plus",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 3.51 2.957"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 19h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 16v6"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellQuestionIcon = {
    name: 'BellQuestionIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-question",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.5 17h-9.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 5.914 .716"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 22v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellRinging2FilledIcon = {
    name: 'BellRinging2FilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-ringing-2-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.63 17.531c.612 .611 .211 1.658 -.652 1.706a3.992 3.992 0 0 1 -3.05 -1.166a3.992 3.992 0 0 1 -1.165 -3.049c.046 -.826 1.005 -1.228 1.624 -.726l.082 .074l3.161 3.16z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.071 3.929c.96 .96 1.134 2.41 .52 3.547l-.09 .153l-.024 .036a8.013 8.013 0 0 1 -1.446 7.137l-.183 .223l-.191 .218l-2.073 2.072l-.08 .112a3 3 0 0 0 -.499 2.113l.035 .201l.045 .185c.264 .952 -.853 1.645 -1.585 1.051l-.086 -.078l-11.313 -11.313c-.727 -.727 -.017 -1.945 .973 -1.671a3 3 0 0 0 2.5 -.418l.116 -.086l2.101 -2.1a8 8 0 0 1 7.265 -1.86l.278 .071l.037 -.023a3.003 3.003 0 0 1 3.432 .192l.14 .117l.128 .12z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellRinging2Icon = {
    name: 'BellRinging2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-ringing-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.364 4.636a2 2 0 0 1 0 2.828a7 7 0 0 1 -1.414 7.072l-2.122 2.12a4 4 0 0 0 -.707 3.536l-11.313 -11.312a4 4 0 0 0 3.535 -.707l2.121 -2.123a7 7 0 0 1 7.072 -1.414a2 2 0 0 1 2.828 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7.343 12.414l-.707 .707a3 3 0 0 0 4.243 4.243l.707 -.707"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellRingingFilledIcon = {
    name: 'BellRingingFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-ringing-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.451 2.344a1 1 0 0 1 1.41 -.099a12.05 12.05 0 0 1 3.048 4.064a1 1 0 1 1 -1.818 .836a10.05 10.05 0 0 0 -2.54 -3.39a1 1 0 0 1 -.1 -1.41z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.136 2.245a1 1 0 0 1 1.312 1.51a10.05 10.05 0 0 0 -2.54 3.39a1 1 0 1 1 -1.817 -.835a12.05 12.05 0 0 1 3.045 -4.065z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.235 19c.865 0 1.322 1.024 .745 1.668a3.992 3.992 0 0 1 -2.98 1.332a3.992 3.992 0 0 1 -2.98 -1.332c-.552 -.616 -.158 -1.579 .634 -1.661l.11 -.006h4.471z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 2c1.358 0 2.506 .903 2.875 2.141l.046 .171l.008 .043a8.013 8.013 0 0 1 4.024 6.069l.028 .287l.019 .289v2.931l.021 .136a3 3 0 0 0 1.143 1.847l.167 .117l.162 .099c.86 .487 .56 1.766 -.377 1.864l-.116 .006h-16c-1.028 0 -1.387 -1.364 -.493 -1.87a3 3 0 0 0 1.472 -2.063l.021 -.143l.001 -2.97a8 8 0 0 1 3.821 -6.454l.248 -.146l.01 -.043a3.003 3.003 0 0 1 2.562 -2.29l.182 -.017l.176 -.004z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellRingingIcon = {
    name: 'BellRingingIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-ringing",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 5a2 2 0 0 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 6 0v-1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 6.727a11.05 11.05 0 0 0 -2.794 -3.727"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 6.727a11.05 11.05 0 0 1 2.792 -3.727"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellSchoolIcon = {
    name: 'BellSchoolIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-school",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 10m-6 0a6 6 0 1 0 12 0a6 6 0 1 0 -12 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.5 15h.5a2 2 0 0 1 2 2v1a2 2 0 0 1 -2 2h-8a2 2 0 0 1 -2 -2v-1a2 2 0 0 1 2 -2h.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 17a5.698 5.698 0 0 0 4.467 -7.932l-.467 -1.068"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 10v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellSearchIcon = {
    name: 'BellSearchIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-search",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 17h-7a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 2.685 2.984"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.2 20.2l1.8 1.8"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellShareIcon = {
    name: 'BellShareIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-share",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 22l5 -5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 21.5v-4.5h-4.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellStarIcon = {
    name: 'BellStarIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-star",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.5 17h-5.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 3.88 5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 2.15 2.878"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.8 20.817l-2.172 1.138a.392 .392 0 0 1 -.568 -.41l.415 -2.411l-1.757 -1.707a.389 .389 0 0 1 .217 -.665l2.428 -.352l1.086 -2.193a.392 .392 0 0 1 .702 0l1.086 2.193l2.428 .352a.39 .39 0 0 1 .217 .665l-1.757 1.707l.414 2.41a.39 .39 0 0 1 -.567 .411l-2.172 -1.138z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellUpIcon = {
    name: 'BellUpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-up",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.5 17h-8.5a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 3.49 2.96"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 22v-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M22 19l-3 -3l-3 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellXFilledIcon = {
    name: 'BellXFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-x-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.235 19c.865 0 1.322 1.024 .745 1.668a3.992 3.992 0 0 1 -2.98 1.332a3.992 3.992 0 0 1 -2.98 -1.332c-.552 -.616 -.158 -1.579 .634 -1.661l.11 -.006h4.471z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 2c1.358 0 2.506 .903 2.875 2.141l.046 .171l.008 .043a8.013 8.013 0 0 1 4.024 6.069l.028 .287l.019 .289v2.931l.021 .136a3 3 0 0 0 1.143 1.847l.167 .117l.162 .099c.86 .487 .56 1.766 -.377 1.864l-.116 .006h-16c-1.028 0 -1.387 -1.364 -.493 -1.87a3 3 0 0 0 1.472 -2.063l.021 -.143l.001 -2.97a8 8 0 0 1 3.821 -6.454l.248 -.146l.01 -.043a3.003 3.003 0 0 1 2.562 -2.29l.182 -.017l.176 -.004zm-1.489 6.14a1 1 0 0 0 -1.218 1.567l1.292 1.293l-1.292 1.293l-.083 .094a1 1 0 0 0 1.497 1.32l1.293 -1.292l1.293 1.292l.094 .083a1 1 0 0 0 1.32 -1.497l-1.292 -1.293l1.292 -1.293l.083 -.094a1 1 0 0 0 -1.497 -1.32l-1.293 1.292l-1.293 -1.292l-.094 -.083z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellXIcon = {
    name: 'BellXIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-x",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 17h-9a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6a2 2 0 1 1 4 0a7 7 0 0 1 4 6v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 4.194 2.753"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M22 22l-5 -5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 22l5 -5"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellZFilledIcon = {
    name: 'BellZFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-z-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.235 19c.865 0 1.322 1.024 .745 1.668a3.992 3.992 0 0 1 -2.98 1.332a3.992 3.992 0 0 1 -2.98 -1.332c-.552 -.616 -.158 -1.579 .634 -1.661l.11 -.006h4.471z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 2c1.358 0 2.506 .903 2.875 2.141l.046 .171l.008 .043a8.013 8.013 0 0 1 4.024 6.069l.028 .287l.019 .289v2.931l.021 .136a3 3 0 0 0 1.143 1.847l.167 .117l.162 .099c.86 .487 .56 1.766 -.377 1.864l-.116 .006h-16c-1.028 0 -1.387 -1.364 -.493 -1.87a3 3 0 0 0 1.472 -2.063l.021 -.143l.001 -2.97a8 8 0 0 1 3.821 -6.454l.248 -.146l.01 -.043a3.003 3.003 0 0 1 2.562 -2.29l.182 -.017l.176 -.004zm2 6h-4l-.117 .007a1 1 0 0 0 -.883 .993l.007 .117a1 1 0 0 0 .993 .883h1.584l-2.291 2.293l-.076 .084c-.514 .637 -.07 1.623 .783 1.623h4l.117 -.007a1 1 0 0 0 .883 -.993l-.007 -.117a1 1 0 0 0 -.993 -.883h-1.586l2.293 -2.293l.076 -.084c.514 -.637 .07 -1.623 -.783 -1.623z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellZIcon = {
    name: 'BellZIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell-z",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 5a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 6 0v-1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 9h4l-4 4h4"
      }, null), createTextVNode(" ")]);
    }
  };

  var BellIcon = {
    name: 'BellIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bell",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 5a2 2 0 1 1 4 0a7 7 0 0 1 4 6v3a4 4 0 0 0 2 3h-16a4 4 0 0 0 2 -3v-3a7 7 0 0 1 4 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 17v1a3 3 0 0 0 6 0v-1"
      }, null), createTextVNode(" ")]);
    }
  };

  var BetaIcon = {
    name: 'BetaIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-beta",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 22v-14a4 4 0 0 1 4 -4h.5a3.5 3.5 0 0 1 0 7h-.5h.5a4.5 4.5 0 1 1 -4.5 4.5v-.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var BibleIcon = {
    name: 'BibleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bible",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 4v16h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 16h-12a2 2 0 0 0 -2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 7v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 9h4"
      }, null), createTextVNode(" ")]);
    }
  };

  var BikeOffIcon = {
    name: 'BikeOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bike-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.437 16.44a3 3 0 0 0 4.123 4.123m1.44 -2.563a3 3 0 0 0 -3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 19v-4l-3 -3l1.665 -1.332m2.215 -1.772l1.12 -.896l2 3h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BikeIcon = {
    name: 'BikeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bike",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 18m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 19l0 -4l-3 -3l5 -4l2 3l3 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 5m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BinaryOffIcon = {
    name: 'BinaryOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-binary-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 7v-2h-1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 19v-1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.5 5h2a.5 .5 0 0 1 .5 .5v4a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5v-4a.5 .5 0 0 1 .5 -.5z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.5 14h2a.5 .5 0 0 1 .5 .5v4a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5v-4a.5 .5 0 0 1 .5 -.5z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 10v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 19v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BinaryTree2Icon = {
    name: 'BinaryTree2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-binary-tree-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 6a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 14a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 14a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 18a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.316 12.496l4.368 -4.992"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.684 12.496l-4.366 -4.99"
      }, null), createTextVNode(" ")]);
    }
  };

  var BinaryTreeIcon = {
    name: 'BinaryTreeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-binary-tree",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 20a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 12a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 12a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.058 18.306l2.88 -4.606"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.061 10.303l2.877 -4.604"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.065 13.705l2.876 4.6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.063 5.7l2.881 4.61"
      }, null), createTextVNode(" ")]);
    }
  };

  var BinaryIcon = {
    name: 'BinaryIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-binary",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 10v-5h-1m8 14v-5h-1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 5m0 .5a.5 .5 0 0 1 .5 -.5h2a.5 .5 0 0 1 .5 .5v4a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 14m0 .5a.5 .5 0 0 1 .5 -.5h2a.5 .5 0 0 1 .5 .5v4a.5 .5 0 0 1 -.5 .5h-2a.5 .5 0 0 1 -.5 -.5z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 10h.01m-.01 9h.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BiohazardOffIcon = {
    name: 'BiohazardOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-biohazard-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.586 10.586a2 2 0 1 0 2.836 2.82"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.939 14c0 .173 .048 .351 .056 .533v.217a4.75 4.75 0 0 1 -4.533 4.745h-.217"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M2.495 14.745a4.75 4.75 0 0 1 7.737 -3.693"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.745 19.495a4.75 4.75 0 0 1 -4.69 -5.503h-.06"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.533 10.538a4.75 4.75 0 0 1 6.957 3.987v.217"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.295 10.929a4.75 4.75 0 0 1 -2.988 -3.64m.66 -3.324a4.75 4.75 0 0 1 .5 -.66l.164 -.172"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.349 3.133a4.75 4.75 0 0 1 -.836 7.385"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BiohazardIcon = {
    name: 'BiohazardIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-biohazard",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.939 14c0 .173 .048 .351 .056 .533l0 .217a4.75 4.75 0 0 1 -4.533 4.745l-.217 0m-4.75 -4.75a4.75 4.75 0 0 1 7.737 -3.693m6.513 8.443a4.75 4.75 0 0 1 -4.69 -5.503l-.06 0m1.764 -2.944a4.75 4.75 0 0 1 7.731 3.477l0 .217m-11.195 -3.813a4.75 4.75 0 0 1 -1.828 -7.624l.164 -.172m6.718 0a4.75 4.75 0 0 1 -1.665 7.798"
      }, null), createTextVNode(" ")]);
    }
  };

  var BladeFilledIcon = {
    name: 'BladeFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-blade-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.586 3a2 2 0 0 1 2.828 0l.586 .585l.586 -.585a2 2 0 0 1 2.7 -.117l.128 .117l2.586 2.586a2 2 0 0 1 0 2.828l-.586 .586l.586 .586a2 2 0 0 1 0 2.828l-8.586 8.586a2 2 0 0 1 -2.828 0l-.586 -.586l-.586 .586a2 2 0 0 1 -2.828 0l-2.586 -2.586a2 2 0 0 1 0 -2.828l.585 -.587l-.585 -.585a2 2 0 0 1 -.117 -2.7l.117 -.129zm3.027 4.21a1 1 0 0 0 -1.32 1.497l.292 .293l-1.068 1.067a2.003 2.003 0 0 0 -2.512 1.784l-.005 .149l.005 .15c.01 .125 .03 .248 .062 .367l-1.067 1.068l-.293 -.292l-.094 -.083a1 1 0 0 0 -1.32 1.497l.292 .293l-.292 .293l-.083 .094a1 1 0 0 0 1.497 1.32l.293 -.292l.293 .292l.094 .083a1 1 0 0 0 1.32 -1.497l-.292 -.293l1.069 -1.067a2.003 2.003 0 0 0 2.449 -2.45l1.067 -1.068l.293 .292l.094 .083a1 1 0 0 0 1.32 -1.497l-.292 -.293l.292 -.293l.083 -.094a1 1 0 0 0 -1.497 -1.32l-.293 .292l-.293 -.292z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BladeIcon = {
    name: 'BladeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-blade",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.707 3.707l2.586 2.586a1 1 0 0 1 0 1.414l-.586 .586a1 1 0 0 0 0 1.414l.586 .586a1 1 0 0 1 0 1.414l-8.586 8.586a1 1 0 0 1 -1.414 0l-.586 -.586a1 1 0 0 0 -1.414 0l-.586 .586a1 1 0 0 1 -1.414 0l-2.586 -2.586a1 1 0 0 1 0 -1.414l.586 -.586a1 1 0 0 0 0 -1.414l-.586 -.586a1 1 0 0 1 0 -1.414l8.586 -8.586a1 1 0 0 1 1.414 0l.586 .586a1 1 0 0 0 1.414 0l.586 -.586a1 1 0 0 1 1.414 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 16l3.2 -3.2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.8 11.2l3.2 -3.2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 8l2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 14l2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BleachChlorineIcon = {
    name: 'BleachChlorineIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bleach-chlorine",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 12h-1a2 2 0 1 0 0 4h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 12v4h2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BleachNoChlorineIcon = {
    name: 'BleachNoChlorineIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bleach-no-chlorine",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.576 19l7.907 -13.733"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.719 19.014l5.346 -9.284"
      }, null), createTextVNode(" ")]);
    }
  };

  var BleachOffIcon = {
    name: 'BleachOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bleach-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 19h14m1.986 -1.977a2 2 0 0 0 -.146 -.773l-7.1 -12.25a2 2 0 0 0 -3.5 0l-.815 1.405m-1.488 2.568l-4.797 8.277a2 2 0 0 0 1.75 2.75"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BleachIcon = {
    name: 'BleachIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bleach",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 19h14a2 2 0 0 0 1.84 -2.75l-7.1 -12.25a2 2 0 0 0 -3.5 0l-7.1 12.25a2 2 0 0 0 1.75 2.75"
      }, null), createTextVNode(" ")]);
    }
  };

  var BlockquoteIcon = {
    name: 'BlockquoteIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-blockquote",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 15h15"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 19h-15"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 11h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 7h-6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 9h1a1 1 0 1 1 -1 1v-2.5a2 2 0 0 1 2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 9h1a1 1 0 1 1 -1 1v-2.5a2 2 0 0 1 2 -2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BluetoothConnectedIcon = {
    name: 'BluetoothConnectedIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bluetooth-connected",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 8l10 8l-5 4l0 -16l5 4l-10 8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l1 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 12l1 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BluetoothOffIcon = {
    name: 'BluetoothOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bluetooth-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.438 16.45l-4.438 3.55v-8m0 -4v-4l5 4l-2.776 2.22m-2.222 1.779l-5 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var BluetoothXIcon = {
    name: 'BluetoothXIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bluetooth-x",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 8l10 8l-5 4v-16l1 .802m0 6.396l-6 4.802"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 6l4 4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 6l-4 4"
      }, null), createTextVNode(" ")]);
    }
  };

  var BluetoothIcon = {
    name: 'BluetoothIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bluetooth",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 8l10 8l-5 4l0 -16l5 4l-10 8"
      }, null), createTextVNode(" ")]);
    }
  };

  var BlurOffIcon = {
    name: 'BlurOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-blur-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3v5m0 4v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.641 5.631a9 9 0 1 0 12.719 12.738m1.68 -2.318a9 9 0 0 0 -12.074 -12.098"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12h5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 9h7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 6h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 15h3m4 0h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BlurIcon = {
    name: 'BlurIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-blur",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 21a9.01 9.01 0 0 0 2.32 -.302a9 9 0 0 0 1.74 -16.733a9 9 0 1 0 -4.06 17.035z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3v17"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12h9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 9h8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 6h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 15h8"
      }, null), createTextVNode(" ")]);
    }
  };

  var BmpIcon = {
    name: 'BmpIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bmp",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 16v-8h2a2 2 0 1 1 0 4h-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 14a2 2 0 0 1 -2 2h-2v-8h2a2 2 0 1 1 0 4h-2h2a2 2 0 0 1 2 2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 16v-8l3 6l3 -6v8"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoldOffIcon = {
    name: 'BoldOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bold-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 5h4a3.5 3.5 0 0 1 2.222 6.204m-3.222 .796h-5v-5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.107 17.112a3.5 3.5 0 0 1 -3.107 1.888h-7v-7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoldIcon = {
    name: 'BoldIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bold",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 5h6a3.5 3.5 0 0 1 0 7h-6z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 12h1a3.5 3.5 0 0 1 0 7h-7v-7"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoltOffIcon = {
    name: 'BoltOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bolt-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.212 15.21l-4.212 5.79v-7h-6l3.79 -5.21m1.685 -2.32l2.525 -3.47v6m1 1h5l-2.104 2.893"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoltIcon = {
    name: 'BoltIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bolt",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 3l0 7l6 0l-8 11l0 -7l-6 0l8 -11"
      }, null), createTextVNode(" ")]);
    }
  };

  var BombFilledIcon = {
    name: 'BombFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bomb-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.499 3.996a2.2 2.2 0 0 1 1.556 .645l3.302 3.301a2.2 2.2 0 0 1 0 3.113l-.567 .567l.043 .192a8.5 8.5 0 0 1 -3.732 8.83l-.23 .144a8.5 8.5 0 1 1 -2.687 -15.623l.192 .042l.567 -.566a2.2 2.2 0 0 1 1.362 -.636zm-4.499 5.004a4 4 0 0 0 -4 4a1 1 0 0 0 2 0a2 2 0 0 1 2 -2a1 1 0 0 0 0 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 2a1 1 0 0 1 .117 1.993l-.117 .007h-1c0 .83 -.302 1.629 -.846 2.25l-.154 .163l-1.293 1.293a1 1 0 0 1 -1.497 -1.32l.083 -.094l1.293 -1.292c.232 -.232 .375 -.537 .407 -.86l.007 -.14a2 2 0 0 1 1.85 -1.995l.15 -.005h1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BombIcon = {
    name: 'BombIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bomb",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.349 5.349l3.301 3.301a1.2 1.2 0 0 1 0 1.698l-.972 .972a7.5 7.5 0 1 1 -5 -5l.972 -.972a1.2 1.2 0 0 1 1.698 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 7l1.293 -1.293a2.414 2.414 0 0 0 .707 -1.707a1 1 0 0 1 1 -1h1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 13a3 3 0 0 1 3 -3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoneOffIcon = {
    name: 'BoneOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bone-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.5 8.502l.38 -.38a3 3 0 1 1 5.12 -2.122a3 3 0 1 1 -2.12 5.122l-.372 .372m-2.008 2.008l-2.378 2.378a3 3 0 1 1 -5.117 2.297l0 -.177l-.176 0a3 3 0 1 1 2.298 -5.115l2.378 -2.378"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoneIcon = {
    name: 'BoneIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bone",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 3a3 3 0 0 1 3 3a3 3 0 1 1 -2.12 5.122l-4.758 4.758a3 3 0 1 1 -5.117 2.297l0 -.177l-.176 0a3 3 0 1 1 2.298 -5.115l4.758 -4.758a3 3 0 0 1 2.12 -5.122z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BongOffIcon = {
    name: 'BongOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bong-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 5v-2h4v6m1.5 1.5l2.5 -2.5l2 2l-2.5 2.5m-.5 3.505a5 5 0 1 1 -7 -4.589v-2.416"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 3h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.1 17h9.8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BongIcon = {
    name: 'BongIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bong",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 3v8.416c.134 .059 .265 .123 .393 .193l3.607 -3.609l2 2l-3.608 3.608a5 5 0 1 1 -6.392 -2.192v-8.416h4z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 3h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.1 17h9.8"
      }, null), createTextVNode(" ")]);
    }
  };

  var Book2Icon = {
    name: 'Book2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-book-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 4v16h-12a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 16h-12a2 2 0 0 0 -2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 8h6"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookDownloadIcon = {
    name: 'BookDownloadIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-book-download",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20h-6a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 16h-7a2 2 0 0 0 -2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 19l3 3l3 -3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 22v-9"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookFilledIcon = {
    name: 'BookFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-book-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.088 4.82a10 10 0 0 1 9.412 .314a1 1 0 0 1 .493 .748l.007 .118v13a1 1 0 0 1 -1.5 .866a8 8 0 0 0 -8 0a1 1 0 0 1 -1 0a8 8 0 0 0 -7.733 -.148l-.327 .18l-.103 .044l-.049 .016l-.11 .026l-.061 .01l-.117 .006h-.042l-.11 -.012l-.077 -.014l-.108 -.032l-.126 -.056l-.095 -.056l-.089 -.067l-.06 -.056l-.073 -.082l-.064 -.089l-.022 -.036l-.032 -.06l-.044 -.103l-.016 -.049l-.026 -.11l-.01 -.061l-.004 -.049l-.002 -.068v-13a1 1 0 0 1 .5 -.866a10 10 0 0 1 9.412 -.314l.088 .044l.088 -.044z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookOffIcon = {
    name: 'BookOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-book-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 19a9 9 0 0 1 9 0a9 9 0 0 1 5.899 -1.096"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 6a9 9 0 0 1 2.114 -.884m3.8 -.21c1.07 .17 2.116 .534 3.086 1.094a9 9 0 0 1 9 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 6v13"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 6v2m0 4v7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 6v11"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookUploadIcon = {
    name: 'BookUploadIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-book-upload",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 20h-8a2 2 0 0 1 -2 -2v-12a2 2 0 0 1 2 -2h12v5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 16h-5a2 2 0 0 0 -2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 16l3 -3l3 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 13v9"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookIcon = {
    name: 'BookIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-book",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 19a9 9 0 0 1 9 0a9 9 0 0 1 9 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 6a9 9 0 0 1 9 0a9 9 0 0 1 9 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 6l0 13"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 6l0 13"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 6l0 13"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookmarkEditIcon = {
    name: 'BookmarkEditIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bookmark-edit",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.35 17.39l-4.35 2.61v-14a2 2 0 0 1 2 -2h6a2 2 0 0 1 2 2v6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.42 15.61a2.1 2.1 0 0 1 2.97 2.97l-3.39 3.42h-3v-3l3.42 -3.39z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookmarkFilledIcon = {
    name: 'BookmarkFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bookmark-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 3a3 3 0 0 1 2.995 2.824l.005 .176v14a1 1 0 0 1 -1.413 .911l-.101 -.054l-4.487 -2.691l-4.485 2.691a1 1 0 0 1 -1.508 -.743l-.006 -.114v-14a3 3 0 0 1 2.824 -2.995l.176 -.005h6z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookmarkMinusIcon = {
    name: 'BookmarkMinusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bookmark-minus",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.427 17.256l-.427 -.256l-5 3v-14a2 2 0 0 1 2 -2h6a2 2 0 0 1 2 2v9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 19h6"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookmarkOffIcon = {
    name: 'BookmarkOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bookmark-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v3l-5 -3l-5 3v-13m1.178 -2.818c.252 -.113 .53 -.176 .822 -.176h6a2 2 0 0 1 2 2v7"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookmarkPlusIcon = {
    name: 'BookmarkPlusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bookmark-plus",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.357 17.214l-.357 -.214l-5 3v-14a2 2 0 0 1 2 -2h6a2 2 0 0 1 2 2v6.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 19h6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 16v6"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookmarkQuestionIcon = {
    name: 'BookmarkQuestionIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bookmark-question",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.006 18.804l-3.006 -1.804l-5 3v-14a2 2 0 0 1 2 -2h6a2 2 0 0 1 2 2v5.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 22v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 19a2.003 2.003 0 0 0 .914 -3.782a1.98 1.98 0 0 0 -2.414 .483"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookmarkIcon = {
    name: 'BookmarkIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bookmark",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 4h6a2 2 0 0 1 2 2v14l-5 -3l-5 3v-14a2 2 0 0 1 2 -2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookmarksOffIcon = {
    name: 'BookmarksOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bookmarks-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 7h2a2 2 0 0 1 2 2v2m0 4v6l-5 -3l-5 3v-12a2 2 0 0 1 2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.265 4a2 2 0 0 1 1.735 -1h6a2 2 0 0 1 2 2v10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BookmarksIcon = {
    name: 'BookmarksIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bookmarks",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 7a2 2 0 0 1 2 2v12l-5 -3l-5 3v-12a2 2 0 0 1 2 -2h6z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.265 4a2 2 0 0 1 1.735 -1h6a2 2 0 0 1 2 2v12l-1 -.6"
      }, null), createTextVNode(" ")]);
    }
  };

  var BooksOffIcon = {
    name: 'BooksOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-books-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 9v10a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4a1 1 0 0 1 1 1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 5a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 13v6a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 8h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 16h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.254 10.244l-1.218 -4.424a1.02 1.02 0 0 1 .634 -1.219l.133 -.041l2.184 -.53c.562 -.135 1.133 .19 1.282 .732l3.236 11.75"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.585 19.589l-1.572 .38c-.562 .136 -1.133 -.19 -1.282 -.731l-.952 -3.458"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 9l4 -1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.207 15.199l.716 -.18"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BooksIcon = {
    name: 'BooksIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-books",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 4m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 4m0 1a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 8h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 16h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.803 4.56l2.184 -.53c.562 -.135 1.133 .19 1.282 .732l3.695 13.418a1.02 1.02 0 0 1 -.634 1.219l-.133 .041l-2.184 .53c-.562 .135 -1.133 -.19 -1.282 -.732l-3.695 -13.418a1.02 1.02 0 0 1 .634 -1.219l.133 -.041z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 9l4 -1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 16l3.923 -.98"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderAllIcon = {
    name: 'BorderAllIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-all",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l16 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4l0 16"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderBottomIcon = {
    name: 'BorderBottomIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-bottom",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20l-16 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderCornersIcon = {
    name: 'BorderCornersIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-corners",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4h2a2 2 0 0 1 2 2v2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16v2a2 2 0 0 1 -2 2h-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20h-2a2 2 0 0 1 -2 -2v-2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8v-2a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderHorizontalIcon = {
    name: 'BorderHorizontalIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-horizontal",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l16 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderInnerIcon = {
    name: 'BorderInnerIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-inner",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l16 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4l0 16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderLeftIcon = {
    name: 'BorderLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l0 -16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderNoneIcon = {
    name: 'BorderNoneIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-none",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderOuterIcon = {
    name: 'BorderOuterIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-outer",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderRadiusIcon = {
    name: 'BorderRadiusIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-radius",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12v-4a4 4 0 0 1 4 -4h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderRightIcon = {
    name: 'BorderRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4l0 16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderSidesIcon = {
    name: 'BorderSidesIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-sides",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8v8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16v-8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4h8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20h8"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderStyle2Icon = {
    name: 'BorderStyle2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-style-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 18v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 18v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 18v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 18v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 18v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 12h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 12h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 6h16"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderStyleIcon = {
    name: 'BorderStyleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-style",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20v-14a2 2 0 0 1 2 -2h14"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 12v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20v.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderTopIcon = {
    name: 'BorderTopIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-top",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l16 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BorderVerticalIcon = {
    name: 'BorderVerticalIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-border-vertical",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4l0 16"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 12l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20l0 .01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20l0 .01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BottleFilledIcon = {
    name: 'BottleFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bottle-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 1a2 2 0 0 1 1.995 1.85l.005 .15v.5c0 1.317 .381 2.604 1.094 3.705l.17 .25l.05 .072a9.093 9.093 0 0 1 1.68 4.92l.006 .354v6.199a3 3 0 0 1 -2.824 2.995l-.176 .005h-6a3 3 0 0 1 -2.995 -2.824l-.005 -.176v-6.2a9.1 9.1 0 0 1 1.486 -4.982l.2 -.292l.05 -.069a6.823 6.823 0 0 0 1.264 -3.957v-.5a2 2 0 0 1 1.85 -1.995l.15 -.005h2zm.362 5h-2.724a8.827 8.827 0 0 1 -1.08 2.334l-.194 .284l-.05 .069a7.091 7.091 0 0 0 -1.307 3.798l-.003 .125a3.33 3.33 0 0 1 1.975 -.61a3.4 3.4 0 0 1 2.833 1.417c.27 .375 .706 .593 1.209 .583a1.4 1.4 0 0 0 1.166 -.583a3.4 3.4 0 0 1 .81 -.8l.003 .183c0 -1.37 -.396 -2.707 -1.137 -3.852l-.228 -.332a8.827 8.827 0 0 1 -1.273 -2.616z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BottleOffIcon = {
    name: 'BottleOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bottle-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 5h4v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 3.5c0 1.626 .507 3.212 1.45 4.537l.05 .07a8.093 8.093 0 0 1 1.5 4.694v.199m0 4v2a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2v-6.2a8.09 8.09 0 0 1 1.35 -4.474m1.336 -2.63a7.822 7.822 0 0 0 .314 -2.196"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 14.803a2.4 2.4 0 0 0 1 -.803a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 .866 -.142"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BottleIcon = {
    name: 'BottleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bottle",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 5h4v-2a1 1 0 0 0 -1 -1h-2a1 1 0 0 0 -1 1v2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 3.5c0 1.626 .507 3.212 1.45 4.537l.05 .07a8.093 8.093 0 0 1 1.5 4.694v6.199a2 2 0 0 1 -2 2h-6a2 2 0 0 1 -2 -2v-6.2c0 -1.682 .524 -3.322 1.5 -4.693l.05 -.07a7.823 7.823 0 0 0 1.45 -4.537"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 14.803a2.4 2.4 0 0 0 1 -.803a2.4 2.4 0 0 1 2 -1a2.4 2.4 0 0 1 2 1a2.4 2.4 0 0 0 2 1a2.4 2.4 0 0 0 2 -1a2.4 2.4 0 0 1 1 -.805"
      }, null), createTextVNode(" ")]);
    }
  };

  var BounceLeftIcon = {
    name: 'BounceLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bounce-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 15.5c-3 -1 -5.5 -.5 -8 4.5c-.5 -3 -1.5 -5.5 -3 -8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 9a2 2 0 1 1 0 -4a2 2 0 0 1 0 4z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BounceRightIcon = {
    name: 'BounceRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bounce-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 15.5c3 -1 5.5 -.5 8 4.5c.5 -3 1.5 -5.5 3 -8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 9a2 2 0 1 1 0 -4a2 2 0 0 1 0 4z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BowIcon = {
    name: 'BowIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bow",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 3h4v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 3l-15 15"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 18h3v3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.5 20c1.576 -1.576 2.5 -4.095 2.5 -6.5c0 -4.81 -3.69 -8.5 -8.5 -8.5c-2.415 0 -4.922 .913 -6.5 2.5l12.5 12.5z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BowlIcon = {
    name: 'BowlIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-bowl",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8h16a1 1 0 0 1 1 1v.5c0 1.5 -2.517 5.573 -4 6.5v1a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-1c-1.687 -1.054 -4 -5 -4 -6.5v-.5a1 1 0 0 1 1 -1z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignBottomFilledIcon = {
    name: 'BoxAlignBottomFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-bottom-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 13h-16a1 1 0 0 0 -1 1v5a2 2 0 0 0 2 2h14a2 2 0 0 0 2 -2v-5a1 1 0 0 0 -1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignBottomLeftFilledIcon = {
    name: 'BoxAlignBottomLeftFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-bottom-left-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 12h-5a2 2 0 0 0 -2 2v5a2 2 0 0 0 2 2h5a2 2 0 0 0 2 -2v-5a2 2 0 0 0 -2 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 19a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 14a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 19a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignBottomLeftIcon = {
    name: 'BoxAlignBottomLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-bottom-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 13h5a1 1 0 0 1 1 1v5a1 1 0 0 1 -1 1h-5a1 1 0 0 1 -1 -1v-5a1 1 0 0 1 1 -1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 9v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 20v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 9v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 15v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20v.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignBottomRightFilledIcon = {
    name: 'BoxAlignBottomRightFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-bottom-right-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 12h-5a2 2 0 0 0 -2 2v5a2 2 0 0 0 2 2h5a2 2 0 0 0 2 -2v-5a2 2 0 0 0 -2 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 19a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 14a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 19a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignBottomRightIcon = {
    name: 'BoxAlignBottomRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-bottom-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 13h-5a1 1 0 0 0 -1 1v5a1 1 0 0 0 1 1h5a1 1 0 0 0 1 -1v-5a1 1 0 0 0 -1 -1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 9v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 20v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 9v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 15v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20v.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignBottomIcon = {
    name: 'BoxAlignBottomIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-bottom",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 14h16v5a1 1 0 0 1 -1 1h-14a1 1 0 0 1 -1 -1v-5z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 9v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 9v.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignLeftFilledIcon = {
    name: 'BoxAlignLeftFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-left-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.002 3.003h-5a2 2 0 0 0 -2 2v14a2 2 0 0 0 2 2h5a1 1 0 0 0 1 -1v-16a1 1 0 0 0 -1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.002 19.003a1 1 0 0 1 .117 1.993l-.127 .007a1 1 0 0 1 -.117 -1.993l.127 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.003 19.003a1 1 0 0 1 .117 1.993l-.128 .007a1 1 0 0 1 -.117 -1.993l.128 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.003 14.002a1 1 0 0 1 .117 1.993l-.128 .007a1 1 0 0 1 -.117 -1.993l.128 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.003 8.002a1 1 0 0 1 .117 1.993l-.128 .007a1 1 0 0 1 -.117 -1.993l.128 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.003 3.002a1 1 0 0 1 .117 1.993l-.128 .007a1 1 0 0 1 -.117 -1.993l.128 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.002 3.002a1 1 0 0 1 .117 1.993l-.127 .007a1 1 0 0 1 -.117 -1.993l.127 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignLeftIcon = {
    name: 'BoxAlignLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.002 20.003v-16h-5a1 1 0 0 0 -1 1v14a1 1 0 0 0 1 1h5z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.002 20.003h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.003 20.003h-.011"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.003 15.002h-.011"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.003 9.002h-.011"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20.003 4.002h-.011"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.002 4.002h-.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignRightFilledIcon = {
    name: 'BoxAlignRightFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-right-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.998 3.003h-5a1 1 0 0 0 -1 1v16a1 1 0 0 0 1 1h5a2 2 0 0 0 2 -2v-14a2 2 0 0 0 -2 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.008 19.003a1 1 0 0 1 .117 1.993l-.127 .007a1 1 0 0 1 -.117 -1.993l.127 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4.008 19.003a1 1 0 0 1 .117 1.993l-.128 .007a1 1 0 0 1 -.117 -1.993l.128 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4.008 14.002a1 1 0 0 1 .117 1.993l-.128 .007a1 1 0 0 1 -.117 -1.993l.128 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4.008 8.002a1 1 0 0 1 .117 1.993l-.128 .007a1 1 0 0 1 -.117 -1.993l.128 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4.008 3.002a1 1 0 0 1 .117 1.993l-.128 .007a1 1 0 0 1 -.117 -1.993l.128 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.008 3.002a1 1 0 0 1 .117 1.993l-.127 .007a1 1 0 0 1 -.117 -1.993l.127 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignRightIcon = {
    name: 'BoxAlignRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.998 20.003v-16h5a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-5z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.998 20.003h.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3.997 20.003h.011"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3.997 15.002h.011"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3.997 9.002h.011"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3.997 4.002h.011"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.998 4.002h.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignTopFilledIcon = {
    name: 'BoxAlignTopFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-top-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 3.005h-14a2 2 0 0 0 -2 2v5a1 1 0 0 0 1 1h16a1 1 0 0 0 1 -1v-5a2 2 0 0 0 -2 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 13.995a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 18.995a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 18.995a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 18.995a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 18.995a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 13.995a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignTopLeftFilledIcon = {
    name: 'BoxAlignTopLeftFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-top-left-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 3h-5a2 2 0 0 0 -2 2v5a2 2 0 0 0 2 2h5a2 2 0 0 0 2 -2v-5a2 2 0 0 0 -2 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 3a1 1 0 0 1 .117 1.993l-.127 .007a1 1 0 0 1 -.117 -1.993l.127 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 3a1 1 0 0 1 .117 1.993l-.127 .007a1 1 0 0 1 -.117 -1.993l.127 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8a1 1 0 0 1 .117 1.993l-.127 .007a1 1 0 0 1 -.117 -1.993l.127 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 14a1 1 0 0 1 .117 1.993l-.127 .007a1 1 0 0 1 -.117 -1.993l.127 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 14a1 1 0 0 1 .117 1.993l-.127 .007a1 1 0 0 1 -.117 -1.993l.127 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 19a1 1 0 0 1 .117 1.993l-.127 .007a1 1 0 0 1 -.117 -1.993l.127 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 19a1 1 0 0 1 .117 1.993l-.127 .007a1 1 0 0 1 -.117 -1.993l.127 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 19a1 1 0 0 1 .117 1.993l-.127 .007a1 1 0 0 1 -.117 -1.993l.127 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 19a1 1 0 0 1 .117 1.993l-.127 .007a1 1 0 0 1 -.117 -1.993l.127 -.007z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignTopLeftIcon = {
    name: 'BoxAlignTopLeftIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-top-left",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 5v5a1 1 0 0 1 -1 1h-5a1 1 0 0 1 -1 -1v-5a1 1 0 0 1 1 -1h5a1 1 0 0 1 1 1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 4h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 9h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 15h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 15h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 20h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 20h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20h-.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignTopRightFilledIcon = {
    name: 'BoxAlignTopRightFilledIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-top-right-filled",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 3.01h-5a2 2 0 0 0 -2 2v5a2 2 0 0 0 2 2h5a2 2 0 0 0 2 -2v-5a2 2 0 0 0 -2 -2z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 14a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 19a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 19a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 19a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 19a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 14a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 3a1 1 0 0 1 .993 .883l.007 .127a1 1 0 0 1 -1.993 .117l-.007 -.127a1 1 0 0 1 1 -1z",
        "stroke-width": "0",
        "fill": "currentColor"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignTopRightIcon = {
    name: 'BoxAlignTopRightIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-top-right",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 11.01h-5a1 1 0 0 1 -1 -1v-5a1 1 0 0 1 1 -1h5a1 1 0 0 1 1 1v5a1 1 0 0 1 -1 1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 15.01v-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20.01v-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 20.01v-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 20.01v-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 4.01v-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20.01v-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 15.01v-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 9.01v-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4.01v-.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxAlignTopIcon = {
    name: 'BoxAlignTopIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-align-top",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10.005h16v-5a1 1 0 0 0 -1 -1h-14a1 1 0 0 0 -1 1v5z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 15.005v-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20.005v-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 20.005v-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 20.005v-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20.005v-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 15.005v-.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxMarginIcon = {
    name: 'BoxMarginIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-margin",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 8h8v8h-8z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 4v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 20v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 20v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 20v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 20v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 20v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 16v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 12v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 8v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 16v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 12v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 8v.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxModel2OffIcon = {
    name: 'BoxModel2OffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-model-2-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4h10a2 2 0 0 1 2 2v10m-.586 3.414a2 2 0 0 1 -1.414 .586h-12a2 2 0 0 1 -2 -2v-12c0 -.547 .22 -1.043 .576 -1.405"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8h4v4m0 4h-8v-8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxModel2Icon = {
    name: 'BoxModel2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-model-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 8h8v8h-8z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxModelOffIcon = {
    name: 'BoxModelOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-model-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8h4v4m0 4h-8v-8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4h10a2 2 0 0 1 2 2v10m-.586 3.414a2 2 0 0 1 -1.414 .586h-12a2 2 0 0 1 -2 -2v-12c0 -.547 .22 -1.043 .576 -1.405"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 16l3.3 3.3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 8l3.3 -3.3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 8l-3.3 -3.3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 16l-3.3 3.3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxModelIcon = {
    name: 'BoxModelIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-model",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 8h8v8h-8z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 16l3.3 3.3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 8l3.3 -3.3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 8l-3.3 -3.3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 16l-3.3 3.3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxMultiple0Icon = {
    name: 'BoxMultiple0Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-multiple-0",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 6a2 2 0 0 1 2 2v4a2 2 0 1 1 -4 0v-4a2 2 0 0 1 2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxMultiple1Icon = {
    name: 'BoxMultiple1Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-multiple-1",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 14v-8l-2 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxMultiple2Icon = {
    name: 'BoxMultiple2Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-multiple-2",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8a2 2 0 1 1 4 0c0 .591 -.417 1.318 -.816 1.858l-3.184 4.143l4 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxMultiple3Icon = {
    name: 'BoxMultiple3Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-multiple-3",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 10a2 2 0 1 0 -2 -2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12a2 2 0 1 0 2 -2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxMultiple4Icon = {
    name: 'BoxMultiple4Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-multiple-4",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 14v-8l-4 6h5"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxMultiple5Icon = {
    name: 'BoxMultiple5Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-multiple-5",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 14h2a2 2 0 1 0 0 -4h-2v-4h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxMultiple6Icon = {
    name: 'BoxMultiple6Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-multiple-6",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 8a2 2 0 1 0 -4 0v4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxMultiple7Icon = {
    name: 'BoxMultiple7Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-multiple-7",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 6h4l-2 8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxMultiple8Icon = {
    name: 'BoxMultiple8Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-multiple-8",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 8m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxMultiple9Icon = {
    name: 'BoxMultiple9Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-multiple-9",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 8m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12a2 2 0 1 0 4 0v-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxMultipleIcon = {
    name: 'BoxMultipleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-multiple",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 3m0 2a2 2 0 0 1 2 -2h10a2 2 0 0 1 2 2v10a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 17v2a2 2 0 0 1 -2 2h-10a2 2 0 0 1 -2 -2v-10a2 2 0 0 1 2 -2h2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxOffIcon = {
    name: 'BoxOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.765 17.757l-5.765 3.243l-8 -4.5v-9l2.236 -1.258m2.57 -1.445l3.194 -1.797l8 4.5v8.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.561 10.559l5.439 -3.059"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12v9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l-8 -4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxPaddingIcon = {
    name: 'BoxPaddingIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-padding",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4m0 2a2 2 0 0 1 2 -2h12a2 2 0 0 1 2 2v12a2 2 0 0 1 -2 2h-12a2 2 0 0 1 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 16v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 8v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 16v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 8v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 8v.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16v.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxSeamIcon = {
    name: 'BoxSeamIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box-seam",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3l8 4.5v9l-8 4.5l-8 -4.5v-9l8 -4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l8 -4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.2 9.8l7.6 -4.6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12v9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l-8 -4.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var BoxIcon = {
    name: 'BoxIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-box",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3l8 4.5l0 9l-8 4.5l-8 -4.5l0 -9l8 -4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l8 -4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l0 9"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12l-8 -4.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var BracesOffIcon = {
    name: 'BracesOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-braces-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.176 5.177c-.113 .251 -.176 .53 -.176 .823v3c0 1.657 -.895 3 -2 3c1.105 0 2 1.343 2 3v3a2 2 0 0 0 2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 4a2 2 0 0 1 2 2v3c0 1.657 .895 3 2 3c-1.105 0 -2 1.343 -2 3m-.176 3.821a2 2 0 0 1 -1.824 1.179"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BracesIcon = {
    name: 'BracesIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-braces",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 4a2 2 0 0 0 -2 2v3a2 3 0 0 1 -2 3a2 3 0 0 1 2 3v3a2 2 0 0 0 2 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 4a2 2 0 0 1 2 2v3a2 3 0 0 0 2 3a2 3 0 0 0 -2 3v3a2 2 0 0 1 -2 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BracketsContainEndIcon = {
    name: 'BracketsContainEndIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brackets-contain-end",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 4h4v16h-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 16h.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 16h.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 16h.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BracketsContainStartIcon = {
    name: 'BracketsContainStartIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brackets-contain-start",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 4h-4v16h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 16h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 16h-.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 16h-.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BracketsContainIcon = {
    name: 'BracketsContainIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brackets-contain",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 4h-4v16h4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 4h4v16h-4"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 16h.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 16h.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 16h.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BracketsOffIcon = {
    name: 'BracketsOffIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brackets-off",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 5v15h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4h3v11m0 4v1h-3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 3l18 18"
      }, null), createTextVNode(" ")]);
    }
  };

  var BracketsIcon = {
    name: 'BracketsIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brackets",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 4h-3v16h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 4h3v16h-3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrailleIcon = {
    name: 'BrailleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-braille",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 5a1 1 0 1 0 2 0a1 1 0 0 0 -2 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 5a1 1 0 1 0 2 0a1 1 0 0 0 -2 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 19a1 1 0 1 0 2 0a1 1 0 0 0 -2 0z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 12h.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 12h.01"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 19h.01"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrainIcon = {
    name: 'BrainIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brain",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.5 13a3.5 3.5 0 0 0 -3.5 3.5v1a3.5 3.5 0 0 0 7 0v-1.8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.5 13a3.5 3.5 0 0 1 3.5 3.5v1a3.5 3.5 0 0 1 -7 0v-1.8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17.5 16a3.5 3.5 0 0 0 0 -7h-.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 9.3v-2.8a3.5 3.5 0 0 0 -7 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.5 16a3.5 3.5 0 0 1 0 -7h.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 9.3v-2.8a3.5 3.5 0 0 1 7 0v10"
      }, null), createTextVNode(" ")]);
    }
  };

  var Brand4chanIcon = {
    name: 'Brand4chanIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-4chan",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 11s6.054 -1.05 6 -4.5c-.038 -2.324 -2.485 -3.19 -3.016 -1.5c0 0 -.502 -2 -2.01 -2c-1.508 0 -2.984 3 -.974 8z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13.98 11s6.075 -1.05 6.02 -4.5c-.038 -2.324 -2.493 -3.19 -3.025 -1.5c0 0 -.505 -2 -2.017 -2c-1.513 0 -3 3 -.977 8z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M13 13.98l.062 .309l.081 .35l.075 .29l.092 .328l.11 .358l.061 .188l.139 .392c.64 1.73 1.841 3.837 3.88 3.805c2.324 -.038 3.19 -2.493 1.5 -3.025l.148 -.045l.165 -.058a4.13 4.13 0 0 0 .098 -.039l.222 -.098c.586 -.28 1.367 -.832 1.367 -1.777c0 -1.513 -3 -3 -8 -.977z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.02 13l-.309 .062l-.35 .081l-.29 .075l-.328 .092l-.358 .11l-.188 .061l-.392 .139c-1.73 .64 -3.837 1.84 -3.805 3.88c.038 2.324 2.493 3.19 3.025 1.5l.045 .148l.058 .165l.039 .098l.098 .222c.28 .586 .832 1.367 1.777 1.367c1.513 0 3 -3 .977 -8z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11 10.02l-.062 -.309l-.081 -.35l-.075 -.29l-.092 -.328l-.11 -.358l-.128 -.382l-.148 -.399c-.658 -1.687 -1.844 -3.634 -3.804 -3.604c-2.324 .038 -3.19 2.493 -1.5 3.025l-.148 .045l-.164 .058a4.13 4.13 0 0 0 -.1 .039l-.22 .098c-.588 .28 -1.368 .832 -1.368 1.777c0 1.513 3 3 8 .977z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAbstractIcon = {
    name: 'BrandAbstractIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-abstract",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3c7.2 0 9 1.8 9 9s-1.8 9 -9 9s-9 -1.8 -9 -9s1.8 -9 9 -9z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.5 13.5m-2.5 0a2.5 2.5 0 1 0 5 0a2.5 2.5 0 1 0 -5 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 8h8v8"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAdobeIcon = {
    name: 'BrandAdobeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-adobe",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12.893 4.514l7.977 14a.993 .993 0 0 1 -.394 1.365a1.04 1.04 0 0 1 -.5 .127h-3.476l-4.5 -8l-2.5 4h1.5l2 4h-8.977c-.565 0 -1.023 -.45 -1.023 -1c0 -.171 .045 -.34 .13 -.49l7.977 -13.993a1.034 1.034 0 0 1 1.786 0z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAdonisJsIcon = {
    name: 'BrandAdonisJsIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-adonis-js",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3c7.2 0 9 1.8 9 9s-1.8 9 -9 9s-9 -1.8 -9 -9s1.8 -9 9 -9z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.863 16.922c1.137 -.422 1.637 -.922 3.137 -.922s2 .5 3.138 .922c.713 .264 1.516 -.102 1.778 -.772c.126 -.32 .11 -.673 -.044 -.983l-3.708 -7.474c-.297 -.598 -1.058 -.859 -1.7 -.583a1.24 1.24 0 0 0 -.627 .583l-3.709 7.474c-.321 .648 -.017 1.415 .679 1.714c.332 .143 .715 .167 1.056 .04z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAirbnbIcon = {
    name: 'BrandAirbnbIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-airbnb",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 10c-2 0 -3 1 -3 3c0 1.5 1.494 3.535 3 5.5c1 1 1.5 1.5 2.5 2s2.5 1 4.5 -.5s1.5 -3.5 .5 -6s-2.333 -5.5 -5 -9.5c-.834 -1 -1.5 -1.5 -2.503 -1.5c-1 0 -1.623 .45 -2.497 1.5c-2.667 4 -4 7 -5 9.5s-1.5 4.5 .5 6s3.5 1 4.5 .5s1.5 -1 2.5 -2c1.506 -1.965 3 -4 3 -5.5c0 -2 -1 -3 -3 -3z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAirtableIcon = {
    name: 'BrandAirtableIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-airtable",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 10v8l7 -3v-2.6z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 6l9 3l9 -3l-9 -3z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 12.3v8.7l7 -3v-8z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAlgoliaIcon = {
    name: 'BrandAlgoliaIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-algolia",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.5 11c-.414 -1.477 -1.886 -2.5 -3.5 -2.5a3.47 3.47 0 0 0 -3.5 3.5a3.47 3.47 0 0 0 3.5 3.5c.974 0 1.861 -.357 2.5 -1l4.5 4.5v-15h-7c-4.386 0 -8 3.582 -8 8s3.614 8 8 8a7.577 7.577 0 0 0 2.998 -.614"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAlipayIcon = {
    name: 'BrandAlipayIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-alipay",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 3h-14a2 2 0 0 0 -2 2v14a2 2 0 0 0 2 2h14a2 2 0 0 0 2 -2v-14a2 2 0 0 0 -2 -2z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 7h10"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 3v7"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M21 17.314c-2.971 -1.923 -15 -8.779 -15 -1.864c0 1.716 1.52 2.55 2.985 2.55c3.512 0 6.814 -5.425 6.814 -8h-6.604"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAlpineJsIcon = {
    name: 'BrandAlpineJsIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-alpine-js",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 11.5l4.5 4.5h9l-9 -9z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16.5 16l4.5 -4.5l-4.5 -4.5l-4.5 4.5"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAmazonIcon = {
    name: 'BrandAmazonIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-amazon",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 12.5a15.198 15.198 0 0 1 -7.37 1.44a14.62 14.62 0 0 1 -6.63 -2.94"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.5 15c.907 -1.411 1.451 -3.323 1.5 -5c-1.197 -.773 -2.577 -.935 -4 -1"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAmdIcon = {
    name: 'BrandAmdIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-amd",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 16v-7c0 -.566 -.434 -1 -1 -1h-7l-5 -5h17c.566 0 1 .434 1 1v17l-5 -5z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.293 20.707l4.707 -4.707h-7a1 1 0 0 1 -1 -1v-7l-4.707 4.707a1 1 0 0 0 -.293 .707v6.586a1 1 0 0 0 1 1h6.586a1 1 0 0 0 .707 -.293z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAmigoIcon = {
    name: 'BrandAmigoIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-amigo",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.591 3.635l-7.13 14.082c-1.712 3.38 1.759 5.45 3.69 3.573l1.86 -1.81c3.142 -3.054 4.959 -2.99 8.039 .11l1.329 1.337c2.372 2.387 5.865 .078 4.176 -3.225l-7.195 -14.067c-1.114 -2.18 -3.666 -2.18 -4.77 0z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAmongUsIcon = {
    name: 'BrandAmongUsIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-among-us",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10.646 12.774c-1.939 .396 -4.467 .317 -6.234 -.601c-2.454 -1.263 -1.537 -4.66 1.423 -4.982c2.254 -.224 3.814 -.354 5.65 .214c.835 .256 1.93 .569 1.355 3.281c-.191 1.067 -1.07 1.904 -2.194 2.088z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.84 7.132c.083 -.564 .214 -1.12 .392 -1.661c.456 -.936 1.095 -2.068 3.985 -2.456a22.464 22.464 0 0 1 2.867 .08c1.776 .14 2.643 1.234 3.287 3.368c.339 1.157 .46 2.342 .629 3.537v11l-12.704 -.019c-.552 -2.386 -.262 -5.894 .204 -8.481"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 10c.991 .163 2.105 .383 3.069 .67c.255 .13 .52 .275 .534 .505c.264 3.434 .57 7.448 .278 9.825h-3.881"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAndroidIcon = {
    name: 'BrandAndroidIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-android",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 10l0 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 10l0 6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 9h10v8a1 1 0 0 1 -1 1h-8a1 1 0 0 1 -1 -1v-8a5 5 0 0 1 10 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 3l1 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 3l-1 2"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 18l0 3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 18l0 3"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAngularIcon = {
    name: 'BrandAngularIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-angular",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5.428 17.245l6.076 3.471a1 1 0 0 0 .992 0l6.076 -3.471a1 1 0 0 0 .495 -.734l1.323 -9.704a1 1 0 0 0 -.658 -1.078l-7.4 -2.612a1 1 0 0 0 -.665 0l-7.399 2.613a1 1 0 0 0 -.658 1.078l1.323 9.704a1 1 0 0 0 .495 .734z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 15l3 -8l3 8"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M10 13h4"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAnsibleIcon = {
    name: 'BrandAnsibleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-ansible",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9.647 12.294l6.353 3.706l-4 -9l-4 9"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAo3Icon = {
    name: 'BrandAo3Icon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-ao3",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M2 5c7.109 4.1 10.956 10.131 12 14c1.074 -4.67 4.49 -8.94 8 -11"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14 8m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 9c-.278 5.494 -2.337 7.33 -4 10c4.013 -2 6.02 -5 15.05 -5c4.012 0 3.51 2.5 1 3c2 .5 2.508 5 -2.007 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAppgalleryIcon = {
    name: 'BrandAppgalleryIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-appgallery",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4 4m0 4a4 4 0 0 1 4 -4h8a4 4 0 0 1 4 4v8a4 4 0 0 1 -4 4h-8a4 4 0 0 1 -4 -4z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 8a3 3 0 0 0 6 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAppleArcadeIcon = {
    name: 'BrandAppleArcadeIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-apple-arcade",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 5m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M20 12.5v4.75a.734 .734 0 0 1 -.055 .325a.704 .704 0 0 1 -.348 .366l-5.462 2.58a5 5 0 0 1 -4.27 0l-5.462 -2.58a.705 .705 0 0 1 -.401 -.691l0 -4.75"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M4.431 12.216l5.634 -2.332a5.065 5.065 0 0 1 3.87 0l5.634 2.332a.692 .692 0 0 1 .028 1.269l-5.462 2.543a5.064 5.064 0 0 1 -4.27 0l-5.462 -2.543a.691 .691 0 0 1 .028 -1.27z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 7l0 6"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandApplePodcastIcon = {
    name: 'BrandApplePodcastIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-apple-podcast",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18.364 18.364a9 9 0 1 0 -12.728 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M11.766 22h.468a2 2 0 0 0 1.985 -1.752l.5 -4a2 2 0 0 0 -1.985 -2.248h-1.468a2 2 0 0 0 -1.985 2.248l.5 4a2 2 0 0 0 1.985 1.752z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 9m-2 0a2 2 0 1 0 4 0a2 2 0 1 0 -4 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAppleIcon = {
    name: 'BrandAppleIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-apple",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 7c-3 0 -4 3 -4 5.5c0 3 2 7.5 4 7.5c1.088 -.046 1.679 -.5 3 -.5c1.312 0 1.5 .5 3 .5s4 -3 4 -5c-.028 -.01 -2.472 -.403 -2.5 -3c-.019 -2.17 2.416 -2.954 2.5 -3c-1.023 -1.492 -2.951 -1.963 -3.5 -2c-1.433 -.111 -2.83 1 -3.5 1c-.68 0 -1.9 -1 -3 -1z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 4a2 2 0 0 0 2 -2a2 2 0 0 0 -2 2"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAppstoreIcon = {
    name: 'BrandAppstoreIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-appstore",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8 16l1.106 -1.99m1.4 -2.522l2.494 -4.488"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 14h5m2.9 0h2.1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M16 16l-2.51 -4.518m-1.487 -2.677l-1 -1.805"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAsanaIcon = {
    name: 'BrandAsanaIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-asana",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M12 7m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 16m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7 16m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAwsIcon = {
    name: 'BrandAwsIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-aws",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M17 18.5a15.198 15.198 0 0 1 -7.37 1.44a14.62 14.62 0 0 1 -6.63 -2.94"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19.5 21c.907 -1.411 1.451 -3.323 1.5 -5c-1.197 -.773 -2.577 -.935 -4 -1"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 11v-4.5a1.5 1.5 0 0 1 3 0v4.5"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M3 9h3"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 5l1.2 6l1.8 -4l1.8 4l1.2 -6"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M18 10.25c0 .414 .336 .75 .75 .75h1.25a1 1 0 0 0 1 -1v-1a1 1 0 0 0 -1 -1h-1a1 1 0 0 1 -1 -1v-1a1 1 0 0 1 1 -1h1.25a.75 .75 0 0 1 .75 .75"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandAzureIcon = {
    name: 'BrandAzureIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-azure",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6 7.5l-4 9.5h4l6 -15z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M22 20l-7 -15l-3 7l4 5l-8 3z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandBackboneIcon = {
    name: 'BrandBackboneIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-backbone",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 20l14 -8l-14 -8z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 20l-14 -8l14 -8z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandBadooIcon = {
    name: 'BrandBadooIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-badoo",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M22 9.43c0 5.838 -4.477 10.57 -10 10.57s-10 -4.662 -10 -10.5c0 -2.667 1.83 -5.01 4.322 -5.429c2.492 -.418 4.9 1.392 5.678 3.929c.768 -2.54 3.177 -4.354 5.668 -3.931c2.495 .417 4.332 2.69 4.332 5.36z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M7.5 10c0 2.761 2.015 5 4.5 5s4.5 -2.239 4.5 -5"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandBaiduIcon = {
    name: 'BrandBaiduIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-baidu",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M5 9.5m-1 0a1 1.5 0 1 0 2 0a1 1.5 0 1 0 -2 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M14.463 11.596c1.282 1.774 3.476 3.416 3.476 3.416s1.921 1.574 .593 3.636c-1.328 2.063 -4.892 1.152 -4.892 1.152s-1.416 -.44 -3.06 -.088c-1.644 .356 -3.06 .22 -3.06 .22s-2.055 -.22 -2.47 -2.304c-.416 -2.084 1.918 -3.638 2.102 -3.858c.182 -.222 1.409 -.966 2.284 -2.394c.875 -1.428 3.337 -2.287 5.027 .221z"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M9 4.5m-1 0a1 1.5 0 1 0 2 0a1 1.5 0 1 0 -2 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15 4.5m-1 0a1 1.5 0 1 0 2 0a1 1.5 0 1 0 -2 0"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M19 9.5m-1 0a1 1.5 0 1 0 2 0a1 1.5 0 1 0 -2 0"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandBandcampIcon = {
    name: 'BrandBandcampIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-bandcamp",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M8.5 6h13.5l-7 12h-13z"
      }, null), createTextVNode(" ")]);
    }
  };

  var BrandBandlabIcon = {
    name: 'BrandBandlabIcon',
    props: {
      size: {
        type: [Number, String],
        default: 24
      }
    },
    render() {
      const size = this.$props.size + 'px';
      const attrs = this.$data.attrs || {};
      const allAttrs = {
        width: attrs.width || size,
        height: attrs.height || size
      };
      return createVNode("svg", mergeProps({
        "xmlns": "http://www.w3.org/2000/svg",
        "class": "icon-tabler icon-tabler-brand-bandlab",
        "width": "24",
        "height": "24",
        "viewBox": "0 0 24 24",
        "stroke-width": "2",
        "stroke": "currentColor",
        "fill": "none",
        "stroke-linecap": "round",
        "stroke-linejoin": "round"
      }, allAttrs), [createTextVNode("   "), createVNode("path", {
        "stroke": "none",
        "d": "M0 0h24v24H0z",
        "fill": "none"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M6.885 7l-2.536 4.907c-2.021 3.845 -2.499 8.775 3.821 9.093h6.808c4.86 -.207 7.989 -2.975 4.607 -9.093l-2.988 -4.907"
      }, null), createTextVNode("   "), createVNode("path", {
        "d": "M15.078 4h-5.136l3.678 8.7