import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'AbacusOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-abacus-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 5v16"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 21v-2m0 -4v-12"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 7h2m4 0h8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 15h10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 13v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 13v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 16v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 5v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 5v2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 8v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 21h18"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};