import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'AdCircleOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-ad-circle-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4.91 4.949a9.968 9.968 0 0 0 -2.91 7.051c0 5.523 4.477 10 10 10a9.968 9.968 0 0 0 7.05 -2.909"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.778 16.793a9.955 9.955 0 0 0 1.222 -4.793c0 -5.523 -4.477 -10 -10 -10c-1.74 0 -3.376 .444 -4.8 1.225"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 15v-4.5a1.5 1.5 0 0 1 2.138 -1.358"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.854 9.853c.094 .196 .146 .415 .146 .647v4.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 13h3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 14v1h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 13v-2a2 2 0 0 0 -2 -2h-1v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};