import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'AdjustmentsCancelIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-adjustments-cancel",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 10a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 4v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 12v8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13.499 14.675a2 2 0 1 0 -1.499 3.325"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 4v10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 18v2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 7a2 2 0 1 0 4 0a2 2 0 0 0 -4 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 4v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 9v3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 19m-3 0a3 3 0 1 0 6 0a3 3 0 1 0 -6 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 21l4 -4"
    }, null), _createTextVNode(" ")]);
  }
};