import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'AngleIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-angle",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 19h-18l9 -15"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.615 15.171h.015"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.515 11.771h.015"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.715 8.671h.015"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15.415 5.971h.015"
    }, null), _createTextVNode(" ")]);
  }
};