import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ApertureIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-aperture",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.6 15h10.55"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6.551 4.938l3.26 10.034"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.032 4.636l-8.535 6.201"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.559 14.51l-8.535 -6.201"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12.257 20.916l3.261 -10.034"
    }, null), _createTextVNode(" ")]);
  }
};