import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ArrowRotaryFirstLeftIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-arrow-rotary-first-left",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 10a3 3 0 1 1 0 -6a3 3 0 0 1 0 6z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 10v10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13.5 9.5l-8.5 8.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 18h-5v-5"
    }, null), _createTextVNode(" ")]);
  }
};