import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'ArtboardOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-artboard-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 8h3a1 1 0 0 1 1 1v3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15.716 15.698a1 1 0 0 1 -.716 .302h-6a1 1 0 0 1 -1 -1v-6c0 -.273 .11 -.52 .287 -.7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 8h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 16h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 3v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 3v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 8h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 16h1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 20v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 20v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};