import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BallAmericanFootballIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-ball-american-football",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 9l-6 6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 12l2 2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 10l2 2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 21a5 5 0 0 0 -5 -5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 3c-7.18 0 -13 5.82 -13 13a5 5 0 0 0 5 5c7.18 0 13 -5.82 13 -13a5 5 0 0 0 -5 -5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 3a5 5 0 0 0 5 5"
    }, null), _createTextVNode(" ")]);
  }
};