import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BallBaseballIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-ball-baseball",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.636 18.364a9 9 0 1 0 12.728 -12.728a9 9 0 0 0 -12.728 12.728z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12.495 3.02a9 9 0 0 1 -9.475 9.475"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.98 11.505a9 9 0 0 0 -9.475 9.475"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 9l2 2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 13l2 2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 7l2 1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 11l1 2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 11l1 2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 16l2 1"
    }, null), _createTextVNode(" ")]);
  }
};