import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BarcodeOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-barcode-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 7v-1c0 -.552 .224 -1.052 .586 -1.414"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 17v1a2 2 0 0 0 2 2h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 4h2a2 2 0 0 1 2 2v1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 20h2c.551 0 1.05 -.223 1.412 -.584"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 11h1v2h-1z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 11v2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 11v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 11v2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};