import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BarrierBlockOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-barrier-block-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 7h8a1 1 0 0 1 1 1v7c0 .27 -.107 .516 -.282 .696"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 16h-11a1 1 0 0 1 -1 -1v-7a1 1 0 0 1 1 -1h2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 16v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7.5 16l4.244 -4.244"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13.745 9.755l2.755 -2.755"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13.5 16l1.249 -1.249"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16.741 12.759l3.259 -3.259"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 13.5l4.752 -4.752"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 17v3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 20h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 20h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 7v-2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};