import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BinaryTree2Icon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-binary-tree-2",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 6a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 14a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 14a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 18a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 8v8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6.316 12.496l4.368 -4.992"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.684 12.496l-4.366 -4.99"
    }, null), _createTextVNode(" ")]);
  }
};