import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BinaryTreeIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-binary-tree",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 20a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 4a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 20a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 12a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 12a2 2 0 1 0 -4 0a2 2 0 0 0 4 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.058 18.306l2.88 -4.606"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10.061 10.303l2.877 -4.604"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10.065 13.705l2.876 4.6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15.063 5.7l2.881 4.61"
    }, null), _createTextVNode(" ")]);
  }
};