import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BlurIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-blur",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 21a9.01 9.01 0 0 0 2.32 -.302a9 9 0 0 0 1.74 -16.733a9 9 0 1 0 -4.06 17.035z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 3v17"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12h9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 9h8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 6h6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 18h6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 15h8"
    }, null), _createTextVNode(" ")]);
  }
};