import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BooksOffIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-books-off",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 9v10a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-14"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 4a1 1 0 0 1 1 1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 5a1 1 0 0 1 1 -1h2a1 1 0 0 1 1 1v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 13v6a1 1 0 0 1 -1 1h-2a1 1 0 0 1 -1 -1v-10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5 8h3"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 16h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14.254 10.244l-1.218 -4.424a1.02 1.02 0 0 1 .634 -1.219l.133 -.041l2.184 -.53c.562 -.135 1.133 .19 1.282 .732l3.236 11.75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.585 19.589l-1.572 .38c-.562 .136 -1.133 -.19 -1.282 -.731l-.952 -3.458"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 9l4 -1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19.207 15.199l.716 -.18"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 3l18 18"
    }, null), _createTextVNode(" ")]);
  }
};