import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BorderRadiusIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-border-radius",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 12v-4a4 4 0 0 1 4 -4h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 4l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 4l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 8l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 12l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 16l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 16l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 20l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 20l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 20l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 20l0 .01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 20l0 .01"
    }, null), _createTextVNode(" ")]);
  }
};