import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BoxAlignBottomRightIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-box-align-bottom-right",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 13h-5a1 1 0 0 0 -1 1v5a1 1 0 0 0 1 1h5a1 1 0 0 0 1 -1v-5a1 1 0 0 0 -1 -1z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 9v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 4v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 4v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 4v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 20v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 4v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 9v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 15v.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 20v.01"
    }, null), _createTextVNode(" ")]);
  }
};