import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BoxAlignRightIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-box-align-right",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13.998 20.003v-16h5a1 1 0 0 1 1 1v14a1 1 0 0 1 -1 1h-5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8.998 20.003h.01"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.997 20.003h.011"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.997 15.002h.011"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.997 9.002h.011"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.997 4.002h.011"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8.998 4.002h.01"
    }, null), _createTextVNode(" ")]);
  }
};