import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandCitymapperIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-citymapper",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 11a1 1 0 1 1 -1 1.013a1 1 0 0 1 1 -1v-.013z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 11a1 1 0 1 1 -1 1.013a1 1 0 0 1 1 -1v-.013z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 12h8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 9l3 3l-3 3"
    }, null), _createTextVNode(" ")]);
  }
};