import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandCodesandboxIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-codesandbox",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 7.5v9l-4 2.25l-4 2.25l-4 -2.25l-4 -2.25v-9l4 -2.25l4 -2.25l4 2.25z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12l4 -2.25l4 -2.25"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12l0 9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12l-4 -2.25l-4 -2.25"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 12l-4 2v4.75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 12l4 2l0 4.75"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 5.25l4 2.25l4 -2.25"
    }, null), _createTextVNode(" ")]);
  }
};