import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandDeezerIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-deezer",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 16.5h2v.5h-2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 16.5h2.5v.5h-2.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 17h-2.5v-.5h2.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21.5 17h-2.5v-.5h2.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21.5 13h-2.5v.5h2.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21.5 9.5h-2.5v.5h2.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21.5 6h-2.5v.5h2.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 13h-2.5v.5h2.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 13.5h2.5v-.5h-2.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 9.5h2.5v.5h-2.5z"
    }, null), _createTextVNode(" ")]);
  }
};