import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandDenodoIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-denodo",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 11h2v2h-2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.634 15.634l1.732 -1l1 1.732l-1.732 1z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 19h2v2h-2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.634 14.634l1.732 1l-1 1.732l-1.732 -1z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.634 7.634l1.732 -1l1 1.732l-1.732 1z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 3h2v2h-2z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.634 8.366l1 -1.732l1.732 1l-1 1.732z"
    }, null), _createTextVNode(" ")]);
  }
};