import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandGitIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-git",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 8m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 16m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 15v-6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15 11l-2 -2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 7l-1.9 -1.9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13.446 2.6l7.955 7.954a2.045 2.045 0 0 1 0 2.892l-7.955 7.955a2.045 2.045 0 0 1 -2.892 0l-7.955 -7.955a2.045 2.045 0 0 1 0 -2.892l7.955 -7.955a2.045 2.045 0 0 1 2.892 0z"
    }, null), _createTextVNode(" ")]);
  }
};