import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandGraphqlIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-graphql",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.308 7.265l5.385 -3.029"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13.308 4.235l5.384 3.03"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 9.5v5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.693 16.736l-5.385 3.029"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10.692 19.765l-5.384 -3.03"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 14.5v-5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12.772 4.786l6.121 10.202"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.5 16h-13"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.107 14.988l6.122 -10.201"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 3.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 20.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 8m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 16m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 16m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 8m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0"
    }, null), _createTextVNode(" ")]);
  }
};