import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandHboIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-hbo",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M2 16v-8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6 8v8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M2 12h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 16h2a2 2 0 1 0 0 -4h-2h2a2 2 0 1 0 0 -4h-2v8z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 8a4 4 0 1 1 0 8a4 4 0 0 1 0 -8z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M19 12m-1 0a1 1 0 1 0 2 0a1 1 0 1 0 -2 0"
    }, null), _createTextVNode(" ")]);
  }
};