import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandNytimesIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-nytimes",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11.036 5.058a8 8 0 1 0 8.706 9.965"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 21v-11l-7.5 4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.5 3a2.5 2.5 0 1 1 0 5l-11 -5a2.5 2.5 0 0 0 -.67 4.91"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 12v8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 13h-.01"
    }, null), _createTextVNode(" ")]);
  }
};