import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandSnowflakeIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-snowflake",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 21v-5.5l4.5 2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 21v-5.5l-4.5 2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3.5 14.5l4.5 -2.5l-4.5 -2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20.5 9.5l-4.5 2.5l4.5 2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 3v5.5l-4.5 -2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 3v5.5l4.5 -2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 11l1 1l-1 1l-1 -1z"
    }, null), _createTextVNode(" ")]);
  }
};