import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandSpotifyIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-spotify",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 12m-9 0a9 9 0 1 0 18 0a9 9 0 1 0 -18 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 11.973c2.5 -1.473 5.5 -.973 7.5 .527"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 15c1.5 -1 4 -1 5 .5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M7 9c2 -1 6 -2 10 .5"
    }, null), _createTextVNode(" ")]);
  }
};