import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandStackoverflowIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-stackoverflow",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 17v1a2 2 0 0 0 2 2h12a2 2 0 0 0 2 -2v-1"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 16h8"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8.322 12.582l7.956 .836"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8.787 9.168l7.826 1.664"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10.096 5.764l7.608 2.472"
    }, null), _createTextVNode(" ")]);
  }
};