import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandTaobaoIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-taobao",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M2 5c.968 .555 1.335 1.104 2 2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M2 10c5.007 3.674 2.85 6.544 0 10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 4c-.137 4.137 -2.258 5.286 -3.709 6.684"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10 6c2.194 -.8 3.736 -.852 6.056 -.993c4.206 -.158 5.523 2.264 5.803 5.153c.428 4.396 -.077 7.186 -2.117 9.298c-1.188 1.23 -3.238 2.62 -7.207 .259"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11 10h6"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M13 10v6.493"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 13h10"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16 15.512l.853 1.72"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M16.5 17c-1.145 .361 -7 3 -8.5 -.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M11.765 8.539l-1.765 2.461"
    }, null), _createTextVNode(" ")]);
  }
};