import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandThreejsIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-threejs",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8 22l-5 -19l19 5.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12.573 17.58l-6.152 -1.576l8.796 -9.466l1.914 6.64"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12.573 17.58l-1.573 -6.58l6.13 2.179"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9.527 4.893l1.473 6.107l-6.31 -1.564z"
    }, null), _createTextVNode(" ")]);
  }
};