import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandTripadvisorIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-tripadvisor",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6.5 13.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.5 13.5m-1.5 0a1.5 1.5 0 1 0 3 0a1.5 1.5 0 1 0 -3 0"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17.5 9a4.5 4.5 0 1 0 3.5 1.671l1 -1.671h-4.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M6.5 9a4.5 4.5 0 1 1 -3.5 1.671l-1 -1.671h4.5z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M10.5 15.5l1.5 2l1.5 -2"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M9 6.75c2 -.667 4 -.667 6 0"
    }, null), _createTextVNode(" ")]);
  }
};