import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandUnityIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-unity",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M14 3l6 4v7"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18 17l-6 4l-6 -4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 14v-7l6 -4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M4 7l8 5v9"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M20 7l-8 5"
    }, null), _createTextVNode(" ")]);
  }
};