import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandVscoIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-vsco",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 12a9 9 0 1 1 -18 0a9 9 0 0 1 18 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M17 12a5 5 0 1 0 -10 0a5 5 0 0 0 10 0z"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 3v4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M21 12h-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 21v-4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M3 12h4"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.364 5.636l-2.828 2.828"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M18.364 18.364l-2.828 -2.828"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.636 18.364l2.828 -2.828"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M5.636 5.636l2.828 2.828"
    }, null), _createTextVNode(" ")]);
  }
};