import { mergeProps as _mergeProps, createTextVNode as _createTextVNode, createVNode as _createVNode } from "vue";
export default {
  name: 'BrandWalmartIcon',
  props: {
    size: {
      type: [Number, String],
      default: 24
    }
  },
  render() {
    const size = this.$props.size + 'px';
    const attrs = this.$data.attrs || {};
    const allAttrs = {
      width: attrs.width || size,
      height: attrs.height || size
    };
    return _createVNode("svg", _mergeProps({
      "xmlns": "http://www.w3.org/2000/svg",
      "class": "icon-tabler icon-tabler-brand-walmart",
      "width": "24",
      "height": "24",
      "viewBox": "0 0 24 24",
      "stroke-width": "2",
      "stroke": "currentColor",
      "fill": "none",
      "stroke-linecap": "round",
      "stroke-linejoin": "round"
    }, allAttrs), [_createTextVNode("   "), _createVNode("path", {
      "stroke": "none",
      "d": "M0 0h24v24H0z",
      "fill": "none"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 8.04v-5.04"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15.5 10l4.5 -2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M15.5 14l4.5 2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M12 15.96v5.04"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8.5 14l-4.5 2.5"
    }, null), _createTextVNode("   "), _createVNode("path", {
      "d": "M8.5 10l-4.5 -2.505"
    }, null), _createTextVNode(" ")]);
  }
};